/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.session.util;

import com.cntaiping.fsc.core.util.SessionUtil;
import com.cntaiping.fsc.session.util.TpCookieSerializer;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collections;
import java.util.List;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.session.web.http.HttpSessionIdResolver;

public class TpHttpSessionIdResolver
implements HttpSessionIdResolver {
    private String headerName = "TPSESSIONKEY";
    private CookieSerializer cookieSerializer = new TpCookieSerializer();

    public List<String> resolveSessionIds(HttpServletRequest request) {
        String headerValue = request.getHeader(this.headerName);
        if (headerValue != null) {
            return Collections.singletonList(headerValue);
        }
        return this.cookieSerializer.readCookieValues(request);
    }

    public void setSessionId(HttpServletRequest request, HttpServletResponse response, String sessionId) {
        response.setHeader(this.headerName, sessionId);
        this.cookieSerializer.writeCookieValue(new CookieSerializer.CookieValue(request, response, sessionId));
    }

    public void expireSession(HttpServletRequest request, HttpServletResponse response) {
        response.setHeader(this.headerName, "");
        SessionUtil.clearAllCookie((HttpServletRequest)request, (HttpServletResponse)response);
    }

    public void setCookieSerializer(CookieSerializer cookieSerializer) {
        if (cookieSerializer == null) {
            throw new IllegalArgumentException("cookieSerializer cannot be null");
        }
        this.cookieSerializer = cookieSerializer;
    }

    public void setHeaderName(String headerName) {
        if (headerName == null) {
            throw new IllegalArgumentException("headerName cannot be null");
        }
        this.headerName = headerName;
    }
}

