/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.session.util.reactive;

import java.util.Collection;
import java.util.List;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.session.WebSessionIdResolver;

public class TpWebSessionIdResolver
implements WebSessionIdResolver {
    private final List<WebSessionIdResolver> delegates;

    public TpWebSessionIdResolver(List<WebSessionIdResolver> sessionIdResolvers) {
        this.delegates = sessionIdResolvers;
    }

    public List<String> resolveSessionIds(ServerWebExchange exchange) {
        return this.delegates.stream().map(webSessionIdResolver -> webSessionIdResolver.resolveSessionIds(exchange)).flatMap(Collection::stream).filter(StringUtils::hasText).toList();
    }

    public void setSessionId(ServerWebExchange exchange, String sessionId) {
        for (WebSessionIdResolver delegate : this.delegates) {
            delegate.setSessionId(exchange, sessionId);
        }
    }

    public void expireSession(ServerWebExchange exchange) {
        for (WebSessionIdResolver delegate : this.delegates) {
            delegate.expireSession(exchange);
        }
    }
}

