/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.common.filter;

import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class RepeatedlyReadRequestWrapper
extends HttpServletRequestWrapper {
    private ThreadLocal<String> body = new ThreadLocal();

    public RepeatedlyReadRequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
        String body = this.getBodyString(request);
        this.body.set(body);
    }

    public String getBodyString(HttpServletRequest request) throws IOException {
        String contentType = request.getContentType();
        String bodyString = "";
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)contentType) && (contentType.contains("multipart/form-data") || contentType.contains("x-www-form-urlencoded"))) {
            Map parameterMap = request.getParameterMap();
            for (Map.Entry next : parameterMap.entrySet()) {
                Object[] values = (String[])next.getValue();
                Object value = null;
                if (values != null) {
                    value = values.length == 1 ? values[0] : Arrays.toString(values);
                }
                sb.append((String)next.getKey()).append("=").append((String)value).append("&");
            }
            if (sb.length() > 0) {
                bodyString = sb.toString().substring(0, sb.toString().length() - 1);
            }
            return bodyString;
        }
        return IOUtils.toString((InputStream)request.getInputStream(), (Charset)StandardCharsets.UTF_8);
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public ServletInputStream getInputStream() throws IOException {
        final ByteArrayInputStream bais = new ByteArrayInputStream(this.body.get().getBytes());
        return new ServletInputStream(){

            public int read() throws IOException {
                return bais.read();
            }

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener listener) {
            }
        };
    }

    public ThreadLocal<String> getBody() {
        return this.body;
    }

    public void setBody(ThreadLocal<String> body) {
        this.body = body;
    }
}

