/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.common.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.Callable;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Commons {
    public static final char EMPTY_CHAR = ' ';
    private static final Logger LOGGER = LoggerFactory.getLogger(Commons.class);

    private Commons() {
    }

    public static void requireNonEmpty(Object ... objects) {
        if (Commons.isEmpty(objects)) {
            throw new NullPointerException();
        }
        for (Object o : objects) {
            if (!Commons.isEmpty(o)) continue;
            throw new NullPointerException();
        }
    }

    public static void requireNonNull(Object ... objects) {
        Objects.requireNonNull(objects);
        for (Object object : objects) {
            Objects.requireNonNull(object);
        }
    }

    public static <T> List<T> nullToEmpty(List<T> list) {
        return Commons.isNull(list) ? Collections.emptyList() : list;
    }

    public static <K, V> Map<K, V> nullToEmpty(Map<K, V> map) {
        return Commons.isNull(map) ? Collections.emptyMap() : map;
    }

    public static <V> Set<V> nullToEmpty(Set<V> set) {
        return Commons.isNull(set) ? Collections.emptySet() : set;
    }

    public static <T> T nonNullOr(T obj, T other) {
        return Commons.isNull(obj) ? other : obj;
    }

    public static <T> T nonNullOr(T obj, Supplier<T> getter) {
        return Commons.isNull(obj) ? getter.get() : obj;
    }

    public static <O> Optional<O> firstNonNull(O ... obj) {
        return Commons.firstMatch(Commons::notNull, obj);
    }

    public static <O> Optional<O> firstNonEmpty(O ... obj) {
        return Commons.firstMatch(Commons::notEmpty, obj);
    }

    public static <O> Optional<O> firstMatch(Predicate<O> filter, Iterable<O> objs) {
        if (objs == null) {
            return Optional.empty();
        }
        return Commons.firstMatch(filter, objs.iterator());
    }

    public static <O> Optional<O> firstMatch(Predicate<O> filter, Iterator<O> objs) {
        if (objs == null) {
            return Optional.empty();
        }
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(objs, 0), false).filter(filter).findFirst();
    }

    public static <O> Optional<O> firstMatch(Predicate<O> filter, Stream<O> objs) {
        if (objs == null) {
            return Optional.empty();
        }
        return objs.filter(filter).findFirst();
    }

    public static <O> Optional<O> firstMatch(Predicate<O> filter, O[] objs) {
        if (objs == null) {
            return Optional.empty();
        }
        return Commons.firstMatch(filter, Arrays.asList(objs));
    }

    public static <T, E extends Throwable> T nonNullOrThrow(T obj, Supplier<? extends E> getter) throws E {
        if (!Commons.isNull(obj)) {
            return obj;
        }
        throw (Throwable)getter.get();
    }

    public static boolean notNull(Object o) {
        return !Commons.isNull(o);
    }

    public static boolean notEmpty(Object o) {
        return !Commons.isEmpty(o);
    }

    public static <T, E> E nonNullThen(T obj, Function<T, ? extends E> getter) {
        return Commons.isNull(obj) ? null : (E)getter.apply(obj);
    }

    public static <T, E> E nonNullThen(T obj, Function<T, ? extends E> getter, E defaultValue) {
        return Commons.isNull(obj) ? defaultValue : getter.apply(obj);
    }

    public static <T, E> E nonEmptyThen(T obj, Function<T, ? extends E> getter, E defaultValue) {
        return Commons.isEmpty(obj) ? defaultValue : getter.apply(obj);
    }

    public static <T, E> E nonEmptyThen(T obj, Function<T, ? extends E> getter) {
        return Commons.isEmpty(obj) ? null : (E)getter.apply(obj);
    }

    public static <T extends Throwable> void assertCondition(boolean condition, T throwable) throws T {
        if (condition) {
            throw throwable;
        }
    }

    public static <T extends Throwable> void assertCondition(boolean condition, Supplier<T> throwableSupplier) throws T {
        if (condition) {
            throw (Throwable)throwableSupplier.get();
        }
    }

    public static <T extends Throwable> void assertCondition(BooleanSupplier tester, Supplier<T> throwableSupplier) throws T {
        if (tester.getAsBoolean()) {
            throw (Throwable)throwableSupplier.get();
        }
    }

    public static boolean isNotNull(Object o) {
        return !Commons.isNull(o);
    }

    public static boolean isNull(Object o) {
        return o == null;
    }

    public static boolean isNotEmpty(Object o) {
        return !Commons.isEmpty(o);
    }

    public static boolean isEmpty(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof CharSequence) {
            return ((CharSequence)o).isEmpty();
        }
        if (o instanceof Map) {
            return ((Map)o).isEmpty();
        }
        if (o instanceof Collection) {
            return ((Collection)o).isEmpty();
        }
        if (Commons.isArray(o)) {
            return Array.getLength(o) == 0;
        }
        if (o instanceof Iterable) {
            return !((Iterable)o).iterator().hasNext();
        }
        if (o instanceof Optional) {
            return ((Optional)o).isEmpty();
        }
        return false;
    }

    public static boolean isNotBlank(CharSequence s) {
        return !Commons.isBlank(s);
    }

    public static boolean isBlank(CharSequence s) {
        if (Commons.isEmpty(s)) {
            return true;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isArray(Object o) {
        return o != null && o.getClass().isArray();
    }

    public static <T, E extends Throwable> T requireNotEmpty(T o, Supplier<E> exception) throws E {
        Commons.assertCondition(() -> Commons.isEmpty(o), exception);
        return o;
    }

    public static <T, E extends Throwable> T requireNotNull(T o, Supplier<E> exception) throws E {
        Commons.assertCondition(() -> Commons.isNull(o), exception);
        return o;
    }

    public static boolean anyNull(Object ... objects) {
        if (Commons.isNull(objects)) {
            return true;
        }
        for (Object o : objects) {
            if (!Commons.isNull(o)) continue;
            return true;
        }
        return false;
    }

    public static boolean anyEmpty(Object ... objects) {
        if (Commons.isEmpty(objects)) {
            return true;
        }
        for (Object o : objects) {
            if (!Commons.isEmpty(o)) continue;
            return true;
        }
        return false;
    }

    public static boolean anyBlank(CharSequence ... objects) {
        if (Commons.isEmpty(objects)) {
            return true;
        }
        for (CharSequence o : objects) {
            if (!Commons.isBlank(o)) continue;
            return true;
        }
        return false;
    }

    public static boolean allBlank(CharSequence ... objects) {
        if (Commons.isEmpty(objects)) {
            return true;
        }
        for (CharSequence o : objects) {
            if (!Commons.isNotBlank(o)) continue;
            return false;
        }
        return true;
    }

    public static boolean allEmpty(Object ... objects) {
        if (Commons.isEmpty(objects)) {
            return true;
        }
        for (Object o : objects) {
            if (Commons.isEmpty(o)) continue;
            return false;
        }
        return true;
    }

    public static boolean allNull(Object ... objects) {
        if (Commons.isNull(objects)) {
            return true;
        }
        for (Object o : objects) {
            if (Commons.isNull(o)) continue;
            return false;
        }
        return true;
    }

    public static void close(AutoCloseable ... closeables) {
        if (Commons.isNull(closeables)) {
            return;
        }
        for (AutoCloseable closeable : closeables) {
            Commons.close(closeable);
        }
    }

    public static void close(AutoCloseable closeable) {
        if (Commons.isNull(closeable)) {
            return;
        }
        Commons.safeExecuteThrowing(closeable::close);
    }

    public static void safeExecute(Runnable task) {
        try {
            task.run();
        }
        catch (Exception e) {
            LOGGER.warn("an exception occurs when running task.", (Throwable)e);
        }
    }

    public static void safeExecuteThrowing(ThrowingRunnable task) {
        try {
            task.run();
        }
        catch (Exception e) {
            LOGGER.warn("an exception occurs when running task.", (Throwable)e);
        }
    }

    public static <T> Optional<T> safeCall(Callable<T> task) {
        try {
            return Optional.ofNullable(task.call());
        }
        catch (Exception e) {
            LOGGER.warn("an exception occurs when running task.", (Throwable)e);
            return Optional.empty();
        }
    }

    public static <T> T safeGet(T[] arr, int idx, T defaultValue) {
        return Commons.safeGet(arr, idx).orElse(defaultValue);
    }

    public static <T> T safeGet(List<T> list, int idx, T defaultValue) {
        return Commons.safeGet(list, idx).orElse(defaultValue);
    }

    public static <T> Optional<T> safeGet(T[] arr, int idx) {
        if (Commons.isEmpty(arr)) {
            return Optional.empty();
        }
        return Optional.ofNullable(arr.length > idx ? (Object)arr[idx] : null);
    }

    public static <T> Optional<T> safeGet(List<T> list, int idx) {
        if (Commons.isEmpty(list)) {
            return Optional.empty();
        }
        return Optional.ofNullable(list.size() > idx ? (Object)list.get(idx) : null);
    }

    public static interface ThrowingRunnable {
        public void run() throws Exception;
    }
}

