/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.bpm.aop;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.cntaiping.fsc.bpm.dao.BpmMainDao;
import com.cntaiping.fsc.bpm.dao.BpmQueryDao;
import com.cntaiping.fsc.bpm.exception.BpmException;
import com.cntaiping.fsc.bpm.po.BpmInterfaceLog;
import com.cntaiping.fsc.bpm.po.BpmMain;
import com.cntaiping.fsc.bpm.po.BpmTask;
import com.cntaiping.fsc.bpm.service.BpmLogService;
import com.cntaiping.fsc.bpm.service.BpmNodeConfigService;
import com.cntaiping.fsc.bpm.service.BpmProcessService;
import com.cntaiping.fsc.bpm.service.BpmTaskService;
import com.cntaiping.fsc.bpm.util.BeanManager;
import com.cntaiping.fsc.bpm.vo.BpmMainVo;
import com.cntaiping.fsc.bpm.vo.BpmNodeConfigVo;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;

@Component
@Aspect
public class BpmHandlerAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(BpmHandlerAspect.class);
    @Autowired
    private BpmQueryDao bpmQueryDao;
    @Autowired
    private BpmMainDao bpmMainDao;
    @Autowired
    private BpmNodeConfigService bpmNodeConfigService;
    @Autowired
    private BpmLogService bpmLogService;
    @Autowired
    private BpmTaskService bpmTaskService;
    @Autowired
    private BpmProcessService bpmProcessService;

    @Before(value="execution(* com.cntaiping.sg.tpsgi..*.*.bpmEntry*(..)) && args(taskId, userCode, businessId, ..)")
    public void beforeEntryTask(Long taskId, String userCode, String businessId) {
        if (taskId < 1L) {
            LOGGER.info("***BPM-LOG***\u8c03\u7528beforeEntryTask\u65b9\u6cd5\uff0c\u5165\u53c2taskId\u5728\u5de5\u4f5c\u6d41\u4e2d\u65e0\u5bf9\u5e94\u4efb\u52a1\u5b58\u5728");
            return;
        }
        BpmNodeConfigVo bpmNodeConfigVo = this.bpmNodeConfigService.findNodeConfigByTaskId(taskId);
        Boolean doBpmApi = true;
        String onEntryMethod = bpmNodeConfigVo.getOnEntryMethod();
        if (StringUtils.isNotBlank((CharSequence)onEntryMethod)) {
            String[] split = onEntryMethod.split("\\.");
            String className = split[0];
            String methodName = split[1];
            Object bean = BeanManager.getBean(className);
            Class<?> clazz = bean.getClass();
            Method method = ReflectionUtils.findMethod(clazz, (String)methodName, (Class[])new Class[]{Long.class, String.class, String.class});
            doBpmApi = (Boolean)ReflectionUtils.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{taskId, userCode, businessId});
        }
        if (doBpmApi.booleanValue()) {
            String bpmResultJson = this.bpmTaskService.acceptTask(taskId, userCode);
            JSONObject jsonObject = JSON.parseObject((String)bpmResultJson);
            String resCode = jsonObject.getString("resCode");
            String resMsg = jsonObject.getString("resMsg");
            if (!"0000".equals(resCode)) {
                throw new BpmException(resMsg);
            }
        }
    }

    @AfterReturning(value="execution(* com.cntaiping.sg.tpsgi..*.*ServiceImpl.bpmStart*(..)) && args(userCode, ..)", returning="bpmMainVo")
    public void startProcessHandler(String userCode, BpmMainVo bpmMainVo) {
        LOGGER.info("BPM: start process, userCode:{}", (Object)userCode);
        if (bpmMainVo == null) {
            throw new BpmException("***BPM-LOG***bpmMainVo\u4e3anull\uff01");
        }
        bpmMainVo.setCreatorCode(userCode);
        bpmMainVo.setUserCode(userCode);
        String processId = bpmMainVo.getProcessId();
        bpmMainVo.setNodeCode("Start");
        BpmNodeConfigVo bpmNodeConfigVo = this.bpmNodeConfigService.findNodeConfigByProcessIdAndNodeCode(processId, "Start");
        bpmMainVo.setApproveInd(bpmNodeConfigVo.getApproveInd());
        String onExitMethod = bpmNodeConfigVo.getOnExitMethod();
        Boolean doBpmApi = this.businessProcess(onExitMethod, bpmMainVo);
        if (doBpmApi.booleanValue()) {
            BpmInterfaceLog acceptLog = null;
            HashMap<String, Object> params = new HashMap<String, Object>(10);
            Boolean autoAcceptFlag = bpmMainVo.getAutoAcceptFlag();
            if (autoAcceptFlag.booleanValue()) {
                bpmMainVo.setActors(userCode);
            }
            this.bpmTaskService.bpmTransferValidation(bpmMainVo);
            String bpmResultJson = this.bpmProcessService.startProcess(processId, params, bpmMainVo);
            LOGGER.info("BPM: start process bpmProcessService.startProcess \u8fd4\u56de\u503c is: " + bpmResultJson);
            LOGGER.info("BPM: start process bpmProcessService.startProcess \u6267\u884c\u5b8c\uff0cbpmmainvo is: " + JSONObject.toJSONString((Object)bpmMainVo));
            JSONObject jsonObject = JSON.parseObject((String)bpmResultJson);
            String resCode = jsonObject.getString("resCode");
            String resMsg = jsonObject.getString("resMsg");
            BpmInterfaceLog startLog = (BpmInterfaceLog)jsonObject.getObject("startLog", BpmInterfaceLog.class);
            Long processInstanceId = jsonObject.getLong("processInstanceId");
            LOGGER.info("BPM: start process bpmProcessService.startProcess \u6267\u884c\u5b8c\uff0c\u8fd4\u56de\u503c\u4e2d\u7684processInstanceId\u662f: " + processInstanceId);
            if ("0000".equals(resCode) && processInstanceId != -1L) {
                List<BpmTask> taskList = this.bpmQueryDao.findTaskListByProcessInstanceId(processInstanceId);
                if (taskList != null && taskList.size() > 0) {
                    Long taskId = taskList.get(0).getTaskId();
                    bpmMainVo.setTaskId(taskId);
                    if (autoAcceptFlag.booleanValue()) {
                        bpmResultJson = this.bpmTaskService.acceptTask(taskId, userCode);
                        jsonObject = JSON.parseObject((String)bpmResultJson);
                        resCode = jsonObject.getString("resCode");
                        resMsg = jsonObject.getString("resMsg");
                        acceptLog = (BpmInterfaceLog)jsonObject.getObject("acceptLog", BpmInterfaceLog.class);
                        if (!"0000".equals(resCode)) {
                            throw new BpmException(resMsg);
                        }
                    }
                }
            } else {
                throw new BpmException(resMsg);
            }
            try {
                String afterEndMethod = bpmNodeConfigVo.getAfterEndMethod();
                this.businessProcess(afterEndMethod, bpmMainVo);
            }
            catch (Exception e) {
                if (startLog != null && startLog.getId() != null) {
                    startLog.setFlag("0");
                    startLog.setUpdaterCode(userCode);
                    this.bpmLogService.updateBpmInterfaceLogFlag(startLog);
                }
                if (acceptLog != null && acceptLog.getId() != null) {
                    acceptLog.setFlag("0");
                    acceptLog.setUpdaterCode(userCode);
                    this.bpmLogService.updateBpmInterfaceLogFlag(acceptLog);
                }
                throw new BpmException("***BPM-LOG***\u56de\u8c03\u4e1a\u52a1\u7cfb\u7edf\u66f4\u65b0\u6587\u6863\u63a5\u53e3\u5f02\u5e38\uff01", e);
            }
        } else {
            throw new BpmException("***BPM-LOG***\u4e1a\u52a1\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u4e0d\u80fd\u542f\u52a8\u6d41\u7a0b\uff01");
        }
        LOGGER.info("BPM: start process, bpmmainvo is: " + JSONObject.toJSONString((Object)bpmMainVo));
    }

    @AfterReturning(value="execution(* com.cntaiping.sg.tpsgi..*.*ServiceImpl.bpmProcess*(..)) && args(taskId, userCode, ..)", returning="bpmMainVo")
    public void afterProcessTask(Long taskId, String userCode, BpmMainVo bpmMainVo) {
        if (bpmMainVo == null || taskId == null || taskId <= 0L) {
            throw new BpmException(MessageFormat.format("***BPM-LOG***taskId\u4f20\u503c\u5f02\u5e38\u6216bpmMainVo\u4e3anull\uff01taskId={0}", taskId));
        }
        bpmMainVo.setCreatorCode(userCode);
        bpmMainVo.setUserCode(userCode);
        List<BpmTask> taskList = this.bpmQueryDao.findTaskById(taskId);
        if (CollectionUtils.isEmpty(taskList)) {
            throw new BpmException("***BPM-LOG***\u65e0\u5bf9\u5e94\u4efb\u52a1\u5b58\u5728\uff01");
        }
        BpmTask bpmTask = taskList.get(0);
        if ("Created".equals(bpmTask.getStatus()) || "Ready".equals(bpmTask.getStatus()) || "Reserved".equals(bpmTask.getStatus())) {
            throw new BpmException(MessageFormat.format("***BPM-LOG***\u4efb\u52a1{0}\u4e3a\u5f85\u5904\u7406\u72b6\u6001\uff0c\u65e0\u6cd5\u6267\u884c\u7ed3\u675f\u4efb\u52a1\u64cd\u4f5c\uff01", String.valueOf(taskId)));
        }
        String processId = bpmTask.getProcessId();
        String nodeCode = bpmTask.getTaskName();
        bpmMainVo.setProcessId(processId);
        bpmMainVo.setNodeCode(nodeCode);
        bpmMainVo.setContainerId(bpmTask.getContainerId());
        BpmMain queryBpmMain = new BpmMain();
        queryBpmMain.setProcessInstanceId(bpmTask.getParentProcessInstanceId() != -1L ? bpmTask.getParentProcessInstanceId() : bpmTask.getProcessInstanceId());
        queryBpmMain.setValidInd(true);
        List<BpmMain> bpmMainList = this.bpmMainDao.findBpmMain(queryBpmMain);
        if (bpmMainList == null || bpmMainList.size() <= 0) {
            throw new BpmException("***BPM-LOG***\u65e0\u5bf9\u5e94BPM\u4e2d\u95f4\u8868\u6570\u636e\u5b58\u5728\uff01");
        }
        BpmMain bpmMain = bpmMainList.get(0);
        bpmMainVo.setBusinessId(bpmMain.getBusinessId());
        bpmMainVo.setInnerRefNo(bpmMain.getInnerRefNo());
        BpmNodeConfigVo bpmNodeConfigVo = this.bpmNodeConfigService.findNodeConfigByProcessIdAndNodeCode(processId, nodeCode);
        bpmMainVo.setApproveInd(bpmNodeConfigVo.getApproveInd());
        String onExitMethod = bpmNodeConfigVo.getOnExitMethod();
        Boolean doBpmApi = this.businessProcess(onExitMethod, bpmMainVo);
        if (doBpmApi.booleanValue()) {
            this.bpmTaskService.bpmTransferValidation(bpmMainVo);
            HashMap<String, Object> params = new HashMap<String, Object>(10);
            String bpmResultJson = this.bpmTaskService.completeTask(taskId, userCode, params, bpmMainVo);
            JSONObject jsonObject = JSON.parseObject((String)bpmResultJson);
            String resCode = jsonObject.getString("resCode");
            String resMsg = jsonObject.getString("resMsg");
            BpmInterfaceLog completeLog = (BpmInterfaceLog)jsonObject.getObject("completeLog", BpmInterfaceLog.class);
            String bpmInvokeResult = jsonObject.getString("bpmInvokeResult");
            BpmInterfaceLog oldLog = (BpmInterfaceLog)jsonObject.getObject("oldLog", BpmInterfaceLog.class);
            if (!"0000".equals(resCode)) {
                this.writebackLog(userCode, completeLog, bpmInvokeResult, oldLog);
                throw new BpmException(resMsg);
            }
            try {
                String afterEndMethod = bpmNodeConfigVo.getAfterEndMethod();
                this.businessProcess(afterEndMethod, bpmMainVo);
            }
            catch (Exception e) {
                bpmInvokeResult = "0";
                completeLog.setFlag("0");
                throw new BpmException("***BPM-LOG***\u56de\u8c03\u4e1a\u52a1\u7cfb\u7edf\u66f4\u65b0\u6587\u6863\u5f02\u5e38\uff01", e);
            }
            finally {
                this.writebackLog(userCode, completeLog, bpmInvokeResult, oldLog);
            }
        } else {
            throw new BpmException("***BPM-LOG***\u4e1a\u52a1\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u4e0d\u80fd\u6d41\u8f6c\uff01");
        }
    }

    public void writebackLog(String userCode, BpmInterfaceLog log, String bpmInvokeResult, BpmInterfaceLog oldLog) {
        if (oldLog != null && oldLog.getId() != null) {
            if ("1".equals(bpmInvokeResult)) {
                log.setUpdaterCode(userCode);
                log.setId(oldLog.getId());
                this.bpmLogService.updateBpmInterfaceLogFlag(log);
            }
        } else {
            this.bpmLogService.insertBpmInterfaceLog(log, bpmInvokeResult);
        }
    }

    @AfterReturning(value="execution(* com.cntaiping.sg.tpsgi..*.*ServiceImpl.bpmAbortProcess*(..)) && args(taskId, userCode, ..)")
    public void abortProcessInstance(Long taskId, String userCode) {
        if (StringUtils.isBlank((CharSequence)userCode) || taskId == null || taskId < 0L) {
            throw new BpmException(MessageFormat.format("***BPM-LOG***\u7ec8\u6b62\u6d41\u7a0b-taskId or userCode\u4f20\u503c\u5f02\u5e38\uff01taskId={0}, userCode={1}", taskId, userCode));
        }
        String bpmResultJson = this.bpmProcessService.abortProcessInstance(taskId, userCode);
        JSONObject jsonObject = JSON.parseObject((String)bpmResultJson);
        String resCode = jsonObject.getString("resCode");
        String resMsg = jsonObject.getString("resMsg");
        if (!"0000".equals(resCode)) {
            throw new BpmException(resMsg);
        }
    }

    @AfterReturning(value="execution(* com.cntaiping.sg.tpsgi..*.*ServiceImpl.bpmSignal*(..)) && args(taskId, signalName, ..)", returning="bpmMainVo")
    public void signalProcessInstance(Long taskId, String signalName, BpmMainVo bpmMainVo) {
        Map<String, Object> signalValue;
        if (StringUtils.isBlank((CharSequence)signalName) || taskId == null || taskId < 0L) {
            throw new BpmException(MessageFormat.format("***BPM-LOG***\u53d1\u9001\u4fe1\u53f7\u7ed9\u6d41\u7a0b\u5b9e\u4f8b-taskId or signalName\u4f20\u503c\u5f02\u5e38\uff01taskId={0}, signalName={1}", taskId, signalName));
        }
        List<BpmTask> taskList = this.bpmQueryDao.findTaskById(taskId);
        BpmTask bpmTask = taskList != null && taskList.size() > 0 ? taskList.get(0) : new BpmTask();
        String processId = bpmTask.getProcessId();
        String nodeCode = bpmTask.getTaskName();
        String containerId = bpmTask.getContainerId();
        Long processInstanceId = bpmTask.getProcessInstanceId();
        bpmMainVo.setProcessId(processId);
        bpmMainVo.setNodeCode(nodeCode);
        bpmMainVo.setProcessInstanceId(processInstanceId);
        if (signalName.contains("dispatchSignal")) {
            Map<String, Object> params = this.bpmTaskService.dispatch(bpmMainVo);
            if (StringUtils.isNotBlank((CharSequence)bpmMainVo.getTransFlag())) {
                params.put("transFlag", bpmMainVo.getTransFlag());
            }
            if (bpmMainVo.getObtainNextTaskIdFlag().booleanValue()) {
                params.put("previousTaskId", taskId);
            }
            if (StringUtils.isNotBlank((CharSequence)bpmMainVo.getUserCode())) {
                params.put("userId", bpmMainVo.getUserCode());
            }
            signalValue = params;
        } else {
            signalValue = bpmMainVo.getDispatchSignal();
        }
        String bpmResultJson = this.bpmProcessService.signalProcessInstance(containerId, processInstanceId, signalName, signalValue);
        JSONObject jsonObject = JSON.parseObject((String)bpmResultJson);
        String resCode = jsonObject.getString("resCode");
        String resMsg = jsonObject.getString("resMsg");
        if (!"0000".equals(resCode)) {
            throw new BpmException(resMsg);
        }
    }

    public Boolean businessProcess(String invokeMethod, BpmMainVo bpmMainVo) {
        Boolean doBpmApi = true;
        if (StringUtils.isNotBlank((CharSequence)invokeMethod) && bpmMainVo.getCallbackFlag().booleanValue()) {
            String[] split = invokeMethod.split("\\.");
            String className = split[0];
            String methodName = split[1];
            Object bean = BeanManager.getBean(className);
            Class<?> clazz = bean.getClass();
            Method method = ReflectionUtils.findMethod(clazz, (String)methodName, (Class[])new Class[]{BpmMainVo.class});
            doBpmApi = (Boolean)ReflectionUtils.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{bpmMainVo});
        }
        return doBpmApi;
    }

    @AfterReturning(value="execution(* com.cntaiping.sg.tpsgi..*.*ServiceImpl.setTaskExpirationDate*(..)) && args(taskId, expirationDate, ..)")
    public void setTaskExpirationDate(Long taskId, Date expirationDate) {
        this.bpmTaskService.setTaskExpirationDate(taskId, expirationDate);
    }
}

