/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.bpm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.cntaiping.fsc.bpm.conf.BpmConfig;
import com.cntaiping.fsc.bpm.dao.BpmAssignConfigDao;
import com.cntaiping.fsc.bpm.dao.BpmQueryDao;
import com.cntaiping.fsc.bpm.exception.BpmException;
import com.cntaiping.fsc.bpm.vo.BpmMainVo;
import com.cntaiping.fsc.bpm.vo.BpmNodeVariableVo;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang3.StringUtils;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.rest.RestURI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

public abstract class BaseBpmService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseBpmService.class);
    @Autowired
    protected BpmConfig bpmConfig;
    @Autowired
    protected RestTemplate restTemplate;
    @Autowired
    protected BpmQueryDao bpmQueryDao;
    @Autowired
    private BpmAssignConfigDao bpmAssignConfigDao;
    protected Marshaller marshaller;

    protected Marshaller getMarshaller() {
        if (this.marshaller == null) {
            this.marshaller = MarshallerFactory.getMarshaller(null, (MarshallingFormat)MarshallingFormat.JSON, (ClassLoader)(Thread.currentThread().getContextClassLoader() != null ? Thread.currentThread().getContextClassLoader() : BaseBpmService.class.getClassLoader()));
        }
        return this.marshaller;
    }

    @SafeVarargs
    protected final JSONObject post(String template, Map<String, Object> urlParams, Object bodyObject, Map<String, String> ... headMap) {
        return this.post(template, urlParams, bodyObject, String.class, headMap);
    }

    @SafeVarargs
    protected final JSONObject post(String template, Map<String, Object> urlParams, Object bodyObject, Class<?> resultType, Map<String, String> ... headMap) {
        JSONObject jo = new JSONObject();
        jo.put("resCode", (Object)"1000");
        Object resData = null;
        try {
            String body;
            String callUrl = RestURI.build((String)this.bpmConfig.getKieServerUrl(), (String)template, urlParams);
            LOGGER.info("***BPM-LOG***callUrl:{}", (Object)callUrl);
            HttpHeaders headers = this.getHttpHeaders(headMap);
            HttpEntity httpEntity = new HttpEntity((Object)this.getMarshaller().marshall(bodyObject), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(callUrl, (Object)httpEntity, String.class, new Object[0]);
            HttpStatusCode statusCode = responseEntity.getStatusCode();
            if (HttpStatus.OK.equals((Object)statusCode) || HttpStatus.CREATED.equals((Object)statusCode)) {
                jo.put("resCode", (Object)"0000");
            }
            if (StringUtils.isNotBlank((CharSequence)(body = (String)responseEntity.getBody()))) {
                resData = this.getMarshaller().unmarshall((String)responseEntity.getBody(), resultType);
            }
        }
        catch (HttpClientErrorException e) {
            resData = e.getLocalizedMessage();
            if (HttpStatus.NOT_FOUND.value() == e.getStatusCode().value()) {
                resData = "Permission Denied!";
            }
            LOGGER.error("***BPM-LOG***" + e.getLocalizedMessage(), (Throwable)e);
        }
        catch (Exception e) {
            resData = e.getMessage();
            LOGGER.error("***BPM-LOG***" + e.getLocalizedMessage(), (Throwable)e);
        }
        jo.put("resData", resData);
        return jo;
    }

    @SafeVarargs
    protected final JSONObject put(String template, Map<String, Object> urlParams, Object bodyObject, Map<String, String> ... headMap) {
        String callUrl = RestURI.build((String)this.bpmConfig.getKieServerUrl(), (String)template, urlParams);
        HttpHeaders headers = this.getHttpHeaders(headMap);
        return this.exchange(callUrl, HttpMethod.PUT, headers, this.getMarshaller().marshall(bodyObject), String.class);
    }

    @SafeVarargs
    protected final JSONObject get(String template, Map<String, Object> urlParams, Class<?> resultType, Map<String, String> ... headMap) {
        String callUrl = RestURI.build((String)this.bpmConfig.getKieServerUrl(), (String)template, urlParams);
        HttpHeaders headers = this.getHttpHeaders(headMap);
        return this.exchange(callUrl, HttpMethod.GET, headers, null, resultType);
    }

    @SafeVarargs
    protected final JSONObject delete(String template, Map<String, Object> urlParams, Class<?> resultType, Map<String, String> ... headMap) {
        String callUrl = RestURI.build((String)this.bpmConfig.getKieServerUrl(), (String)template, urlParams);
        HttpHeaders headers = this.getHttpHeaders(headMap);
        return this.exchange(callUrl, HttpMethod.DELETE, headers, null, resultType);
    }

    private JSONObject exchange(String callUrl, HttpMethod httpMethod, HttpHeaders headers, Object bodyObject, Class<?> resultType) {
        JSONObject jo = new JSONObject();
        jo.put("resCode", (Object)"1000");
        Object resData = null;
        try {
            String body;
            ResponseEntity responseEntity = this.restTemplate.exchange(callUrl, httpMethod, new HttpEntity(bodyObject, (MultiValueMap)headers), String.class, new Object[0]);
            HttpStatusCode statusCode = responseEntity.getStatusCode();
            if (HttpStatus.OK.equals((Object)statusCode) || HttpStatus.CREATED.equals((Object)statusCode) || HttpStatus.NO_CONTENT.equals((Object)statusCode)) {
                jo.put("resCode", (Object)"0000");
            }
            if (StringUtils.isNotBlank((CharSequence)(body = (String)responseEntity.getBody()))) {
                resData = this.getMarshaller().unmarshall((String)responseEntity.getBody(), resultType);
            }
        }
        catch (HttpClientErrorException e) {
            resData = e.getLocalizedMessage();
            if (HttpStatus.NOT_FOUND.value() == e.getStatusCode().value()) {
                resData = "Permission Denied!";
            }
            LOGGER.error("***BPM-LOG***" + e.getLocalizedMessage(), (Throwable)e);
        }
        catch (Exception e) {
            resData = e.getLocalizedMessage();
            LOGGER.error("***BPM-LOG***" + e.getLocalizedMessage(), (Throwable)e);
        }
        jo.put("resData", resData);
        return jo;
    }

    public void invokeDispatchDrools(Map<String, Object> params, BpmMainVo bpmMainVo) {
        Map<String, BpmNodeVariableVo> multiBranchMap = bpmMainVo.getMultiBranchMap();
        if (multiBranchMap.size() == 1 && "End".equals(multiBranchMap.entrySet().iterator().next().getKey())) {
            return;
        }
        List<Map<String, BpmNodeVariableVo>> multiInstanceList = bpmMainVo.getMultiInstanceList();
        String nextNodeCode = null;
        try {
            for (Map.Entry<String, BpmNodeVariableVo> next : multiBranchMap.entrySet()) {
                BpmNodeVariableVo nvo;
                int i;
                BpmNodeVariableVo nextNodeVo = next.getValue();
                nextNodeCode = nextNodeVo.getNodeCode();
                List<BpmNodeVariableVo> nodeMultiInstanceList = nextNodeVo.getMultiInstanceList();
                if (multiInstanceList != null) {
                    for (i = 0; i < multiInstanceList.size(); ++i) {
                        nvo = multiInstanceList.get(i).get(nextNodeCode);
                        this.nodeDispatchHandler(bpmMainVo, nvo);
                    }
                    continue;
                }
                if (nodeMultiInstanceList != null) {
                    for (i = 0; i < nodeMultiInstanceList.size(); ++i) {
                        nvo = nodeMultiInstanceList.get(i);
                        this.nodeDispatchHandler(bpmMainVo, nvo);
                    }
                    continue;
                }
                this.nodeDispatchHandler(bpmMainVo, nextNodeVo);
            }
        }
        catch (Exception e) {
            throw new BpmException("\u6d3e\u5de5\u5f02\u5e38\uff01", e);
        }
        Object dispatchSignal = bpmMainVo.getDispatchSignal();
        if (dispatchSignal != null) {
            if (multiInstanceList != null) {
                params.put("dispatchSignal", multiInstanceList);
            } else if (multiBranchMap.size() == 1) {
                params.put("dispatchSignal", multiBranchMap.get(nextNodeCode));
            } else if (multiBranchMap.size() > 1) {
                params.put("dispatchSignal", multiBranchMap);
            }
        } else if (multiInstanceList != null) {
            params.put("multiInstanceList", multiInstanceList);
        } else if (multiBranchMap.size() == 1) {
            BpmNodeVariableVo vo = multiBranchMap.get(nextNodeCode);
            if (StringUtils.isNotBlank((CharSequence)vo.getActors())) {
                params.put("actors", vo.getActors());
                bpmMainVo.setActors(vo.getActors());
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getGroups())) {
                params.put("groups", vo.getGroups());
                bpmMainVo.setGroups(vo.getGroups());
            }
        } else if (multiBranchMap.size() > 1) {
            params.put("multiBranchMap", multiBranchMap);
        }
    }

    public void nodeDispatchHandler(BpmMainVo bpmMainVo, BpmNodeVariableVo nvo) {
        if (!nvo.getCheckInd().booleanValue() || "End".equals(nvo.getNodeCode())) {
            return;
        }
        JSONObject dispatchVo = nvo.getDispatchVo();
        if (dispatchVo == null) {
            dispatchVo = bpmMainVo.getDispatchVo();
        }
        if (dispatchVo == null) {
            throw new BpmException("\u6d3e\u5de5\u56e0\u5b50\u5bf9\u8c61dispatchVo\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        dispatchVo.put("userCode", (Object)bpmMainVo.getUserCode());
        if (dispatchVo.getBoolean("isApprove") == null) {
            dispatchVo.put("isApprove", (Object)bpmMainVo.getNodeCode().equals(nvo.getNodeCode()));
        }
        dispatchVo.put("processId", (Object)nvo.getProcessId());
        dispatchVo.put("nodeCode", (Object)nvo.getNodeCode());
        dispatchVo.put("dispatchRuleCode", (Object)nvo.getDispatchRuleCode());
        dispatchVo.put("exclActors", (Object)nvo.getExclActors());
        dispatchVo.put("actors", (Object)nvo.getActors());
        if (StringUtils.isNotBlank((CharSequence)bpmMainVo.getInnerRefNo())) {
            dispatchVo.put("innerRefNo", (Object)bpmMainVo.getInnerRefNo());
        } else {
            dispatchVo.put("innerRefNo", (Object)this.bpmQueryDao.findInnerRefNoByProcessInstanceId(bpmMainVo.getProcessInstanceId()));
        }
        try {
            String assignUserCode;
            Boolean flag;
            String dispatchUrl = this.bpmConfig.getDispatchUrl();
            if (StringUtils.isBlank((CharSequence)dispatchUrl)) {
                throw new BpmException("\u672a\u914d\u7f6ebpm:dispatchUrl\u5c5e\u6027\uff01");
            }
            JSONObject resData = null;
            JSONObject res = (JSONObject)this.restTemplate.postForEntity(dispatchUrl, (Object)dispatchVo, JSONObject.class, new Object[0]).getBody();
            if (!"0000".equals(res.getString("resCode"))) {
                throw new BpmException("\u6d3e\u5de5\u5931\u8d25\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a" + res.getString("resMsg"));
            }
            resData = res.getJSONObject("resData");
            boolean actorValid = false;
            boolean groupValid = false;
            String userCode = resData.getString("users");
            String groups = resData.getString("groupNo");
            if (StringUtils.isNotBlank((CharSequence)nvo.getActors()) && StringUtils.isNotBlank((CharSequence)userCode) && userCode.equals(nvo.getActors())) {
                actorValid = true;
            }
            if (StringUtils.isNotBlank((CharSequence)nvo.getGroups()) && StringUtils.isNotBlank((CharSequence)groups) && groups.contains(nvo.getGroups())) {
                groupValid = true;
            }
            if (!actorValid) {
                if (!groupValid && StringUtils.isNotBlank((CharSequence)userCode)) {
                    nvo.setActors(userCode);
                } else {
                    nvo.setActors(null);
                }
            }
            if (!groupValid) {
                if (!actorValid && StringUtils.isNotBlank((CharSequence)groups)) {
                    nvo.setGroups(groups);
                } else {
                    nvo.setGroups(null);
                }
            }
            if (bpmMainVo.getProcessInstanceId() != null && (!nvo.getProcessId().equals(bpmMainVo.getProcessId()) || !nvo.getNodeCode().equals(bpmMainVo.getNodeCode())) && (flag = this.checkAssignConfig(dispatchVo.getString("innerProductCode"), nvo.getProcessId(), nvo.getNodeCode())).booleanValue() && StringUtils.isNotBlank((CharSequence)(assignUserCode = this.bpmAssignConfigDao.findLastAssignUserCode(bpmMainVo.getProcessInstanceId(), nvo.getNodeCode())))) {
                String oriUserCodes = nvo.getActors();
                if (StringUtils.isBlank((CharSequence)oriUserCodes)) {
                    nvo.setActors(assignUserCode);
                } else {
                    StringBuffer sf = new StringBuffer(",");
                    sf.append(oriUserCodes.trim()).append(",");
                    StringBuffer assignSf = new StringBuffer(",");
                    assignSf.append(assignUserCode).append(",");
                    if (sf.lastIndexOf(assignSf.toString()) == -1) {
                        sf.append(assignUserCode);
                        nvo.setActors(sf.substring(1));
                    }
                }
            }
        }
        catch (Exception e) {
            throw new BpmException(e);
        }
    }

    private Boolean checkAssignConfig(String innerProductCode, String processId, String nodeCode) {
        if (StringUtils.isBlank((CharSequence)innerProductCode)) {
            LOGGER.info("***BPM-LOG***innerProductCode\u4e3a\u7a7a\uff0c\u4e0d\u5c06\u6539\u6d3e/\u79fb\u4ea4\u6dfb\u52a0\u5230\u6d3e\u5de5\u7ed3\u679c\u4e2d");
            return false;
        }
        LOGGER.info("***BPM-LOG***\u53c2\u6570\u6253\u5370\uff1ainnerProductCode={1}\uff0cprocessId={2}, nodeCode={3}", new Object[]{innerProductCode, processId, nodeCode});
        int length = this.bpmAssignConfigDao.findResultByPk(innerProductCode, processId, nodeCode);
        if (length > 0) {
            return true;
        }
        return false;
    }

    @SafeVarargs
    private HttpHeaders getHttpHeaders(Map<String, String> ... headMap) {
        HttpHeaders headers = new HttpHeaders();
        String token = DatatypeConverter.printBase64Binary((byte[])(this.bpmConfig.getKieServerUsername() + ":" + this.bpmConfig.getKieServerPassword()).getBytes());
        MediaType mediaType = MediaType.parseMediaType((String)"application/json;charset=UTF-8");
        headers.setContentType(mediaType);
        headers.add("Authorization", "Basic " + token);
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        headers.add("X-KIE-ContentType", "JSON");
        if (headMap != null && headMap.length > 0) {
            for (Map.Entry<String, String> next : headMap[0].entrySet()) {
                headers.set(next.getKey(), next.getValue());
            }
        }
        return headers;
    }

    protected String getAdditionalParams(String inQueryString, String name, List<?> values) {
        StringBuilder queryString = new StringBuilder(inQueryString);
        if (values != null) {
            if (queryString.length() == 0) {
                queryString.append("?");
            } else {
                queryString.append("&");
            }
            for (Object value : values) {
                queryString.append(name).append("=").append(value).append("&");
            }
            queryString.deleteCharAt(queryString.length() - 1);
        }
        return queryString.toString();
    }

    protected String getPagingQueryString(String inQueryString, Integer page, Integer pageSize) {
        StringBuilder queryString = new StringBuilder(inQueryString);
        if (queryString.length() == 0) {
            queryString.append("?");
        } else {
            queryString.append("&");
        }
        queryString.append("page=").append(page).append("&pageSize=").append(pageSize);
        return queryString.toString();
    }

    static {
        System.setProperty("org.kie.server.bypass.auth.user", "true");
        System.setProperty("org.jbpm.ht.callback", "db");
        System.setProperty("org.jbpm.ht.userinfo", "db");
    }
}

