/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.bpm.service.impl;

import com.cntaiping.fsc.bpm.dao.BpmInterfaceLogDao;
import com.cntaiping.fsc.bpm.po.BpmInterfaceLog;
import com.cntaiping.fsc.bpm.service.BpmLogService;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bpmLogService")
public class BpmLogServiceImpl
implements BpmLogService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BpmLogServiceImpl.class);
    @Autowired
    private BpmInterfaceLogDao bpmInterfaceLogDao;

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void insertBpmInterfaceLog(BpmInterfaceLog bpmInterfaceLog, String invokeResult) {
        if (!"0".equals(invokeResult)) {
            LOGGER.info("***BPM-LOG***\u8c03\u7528\u63a5\u53e3" + bpmInterfaceLog.getInvokeMethod() + "\u6210\u529f\uff01");
        }
        try {
            this.bpmInterfaceLogDao.save(bpmInterfaceLog);
        }
        catch (Exception e) {
            LOGGER.error("***BPM-LOG***\u8c03\u7528\u63a5\u53e3" + bpmInterfaceLog.getInvokeMethod() + "\u65f6\u63d2\u5165\u65e5\u5fd7\u8868\u62a5\u9519\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
        }
    }

    @Override
    public void updateBpmInterfaceLogFlag(BpmInterfaceLog bpmInterfaceLog) {
        if (bpmInterfaceLog == null) {
            return;
        }
        try {
            BpmInterfaceLog updateLog = new BpmInterfaceLog();
            updateLog.setFlag(bpmInterfaceLog.getFlag());
            updateLog.setUpdateTime(new Date());
            updateLog.setUpdaterCode(bpmInterfaceLog.getUpdaterCode());
            updateLog.setId(bpmInterfaceLog.getId());
            if (bpmInterfaceLog.getProcessInstanceId() != null && bpmInterfaceLog.getProcessInstanceId() != -1L) {
                updateLog.setProcessInstanceId(bpmInterfaceLog.getProcessInstanceId());
            }
            this.bpmInterfaceLogDao.updateById(updateLog);
        }
        catch (Exception e) {
            LOGGER.error("***BPM-LOG***\u66f4\u65b0\u65e5\u5fd7\u8868\u5931\u8d25\uff0cBpmInterfaceLog\u7684id=" + bpmInterfaceLog.getId() + ",\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public List<BpmInterfaceLog> findInterfaceLog(BpmInterfaceLog bpmInterfaceLog) {
        List<BpmInterfaceLog> interfaceLog = null;
        try {
            interfaceLog = this.bpmInterfaceLogDao.findInterfaceLog(bpmInterfaceLog);
            System.out.println(bpmInterfaceLog);
        }
        catch (Exception e) {
            LOGGER.error("***BPM-LOG***\u67e5\u8be2\u8c03\u7528bpm\u63a5\u53e3\u65e5\u5fd7\u8868\u5931\u8d25\uff0c\u5165\u53c2:" + bpmInterfaceLog, (Throwable)e);
        }
        return interfaceLog;
    }

    @Override
    public List<BpmInterfaceLog> findActiveInterfaceLog(BpmInterfaceLog bpmInterfaceLog) {
        List<BpmInterfaceLog> interfaceLog = null;
        try {
            interfaceLog = this.bpmInterfaceLogDao.findActiveInterfaceLog(bpmInterfaceLog);
            System.out.println(bpmInterfaceLog);
        }
        catch (Exception e) {
            LOGGER.error("***BPM-LOG***\u67e5\u8be2\u5904\u4e8e\u6d3b\u52a8\u72b6\u6001\u7684\u6d41\u7a0b\u76f8\u5173\u8c03\u7528bpm\u63a5\u53e3\u65e5\u5fd7\u8868\u5931\u8d25\uff0c\u5165\u53c2:" + bpmInterfaceLog, (Throwable)e);
        }
        return interfaceLog;
    }
}

