/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.bpm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.cntaiping.fsc.bpm.dao.BpmMainDao;
import com.cntaiping.fsc.bpm.exception.BpmException;
import com.cntaiping.fsc.bpm.po.BpmInterfaceLog;
import com.cntaiping.fsc.bpm.po.BpmMain;
import com.cntaiping.fsc.bpm.po.BpmTask;
import com.cntaiping.fsc.bpm.service.BpmLogService;
import com.cntaiping.fsc.bpm.service.BpmProcessService;
import com.cntaiping.fsc.bpm.service.BpmQueryService;
import com.cntaiping.fsc.bpm.service.impl.BaseBpmService;
import com.cntaiping.fsc.bpm.vo.BpmMainVo;
import com.cntaiping.fsc.bpm.vo.BpmProcessInstanceVo;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.ReleaseId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bpmProcessService")
@Transactional
public class BpmProcessServiceImpl
extends BaseBpmService
implements BpmProcessService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BpmProcessServiceImpl.class);
    @Autowired
    private BpmMainDao bpmMainDao;
    @Autowired
    private BpmLogService bpmLogService;
    @Autowired
    private BpmQueryService bpmQueryService;

    @Override
    public String createContainer(String containerId, String groupId, String artifactId, String version) {
        JSONObject jo = new JSONObject();
        String resCode = "0000";
        Object resMsg = "\u6210\u529f";
        BpmInterfaceLog log = new BpmInterfaceLog();
        String bpmInvokeResult = "1";
        try {
            ReleaseId releaseId = new ReleaseId(groupId, artifactId, version);
            KieContainerResource resource = new KieContainerResource(releaseId);
            JSONObject paramJo = new JSONObject();
            paramJo.put("releaseId", (Object)releaseId);
            log.setContainerId(containerId);
            log.setInvokeMethod("createContainer");
            log.setParamJson(paramJo.toJSONString());
            String template = "/containers/" + containerId;
            JSONObject result = this.put(template, null, resource, new Map[0]);
            String resData = result.getString("resData");
            if (!"0000".equals(result.get((Object)"resCode"))) {
                throw new BpmException(resData);
            }
            log.setFlag("1");
        }
        catch (Exception e) {
            log.setFlag("0");
            bpmInvokeResult = "0";
            resCode = "1000";
            resMsg = "***BPM-LOG***\u521b\u5efa\u5bb9\u5668\u5931\u8d25\uff0c\u5f15\u64ce\u8fd4\u56de\u4fe1\u606f\u5982\u4e0b\uff1a" + e.getLocalizedMessage();
            LOGGER.error("***BPM-LOG***\u521b\u5efa\u5bb9\u5668\u5931\u8d25\uff0c\u5165\u53c2\uff1acontainerId=" + containerId + ",groupId=" + groupId + ",artifactId=" + artifactId + ",version=" + version + "\u5f15\u64ce\u8fd4\u56de\u4fe1\u606f\u5982\u4e0b\uff1a", (Throwable)e);
        }
        this.bpmLogService.insertBpmInterfaceLog(log, bpmInvokeResult);
        jo.put("resCode", (Object)resCode);
        jo.put("resMsg", resMsg);
        return jo.toJSONString();
    }

    @Override
    public String deleteContainer(String containerId) {
        JSONObject jo = new JSONObject();
        String resCode = "0000";
        Object resMsg = "\u6210\u529f";
        BpmInterfaceLog log = new BpmInterfaceLog();
        String bpmInvokeResult = "1";
        try {
            log.setContainerId(containerId);
            log.setInvokeMethod("deleteContainer");
            String template = "/containers/" + containerId;
            JSONObject result = this.delete(template, null, null, new Map[0]);
            String resData = result.getString("resData");
            if (!"0000".equals(result.get((Object)"resCode"))) {
                throw new BpmException(resData);
            }
            log.setFlag("1");
        }
        catch (Exception e) {
            log.setFlag("0");
            bpmInvokeResult = "0";
            resCode = "1000";
            resMsg = "***BPM-LOG***\u5220\u9664\u5bb9\u5668\u5931\u8d25\uff0c\u5f15\u64ce\u8fd4\u56de\u4fe1\u606f\u5982\u4e0b\uff1a" + e.getLocalizedMessage();
            LOGGER.error("***BPM-LOG***\u5220\u9664\u5bb9\u5668\u5931\u8d25\uff0c\u5165\u53c2\uff1acontainerId=" + containerId + "\u5f15\u64ce\u8fd4\u56de\u4fe1\u606f\u5982\u4e0b\uff1a", (Throwable)e);
        }
        this.bpmLogService.insertBpmInterfaceLog(log, bpmInvokeResult);
        jo.put("resCode", (Object)resCode);
        jo.put("resMsg", resMsg);
        return jo.toJSONString();
    }

    @Override
    public String startProcess(String containerId, String processId, Map<String, Object> params, BpmMainVo bpmMainVo) {
        JSONObject jo = new JSONObject();
        long processInstanceId = -1L;
        BpmInterfaceLog log = new BpmInterfaceLog();
        BpmInterfaceLog bpmInterfaceLog = null;
        String resCode = "0000";
        Object resMsg = "\u6210\u529f";
        String businessId = bpmMainVo.getBusinessId();
        BpmMain selectMain = new BpmMain();
        selectMain.setBusinessId(businessId);
        selectMain.setProcessId(processId);
        selectMain.setValidInd(true);
        List<BpmMain> bpmMainList = this.bpmMainDao.findBpmMain(selectMain);
        if (bpmMainList != null && bpmMainList.size() > 0) {
            LOGGER.info("***BPM-LOG***businessId=" + businessId + " \u9700\u542f\u52a8\u7684\u6d41\u7a0b\u5df2\u5b58\u5728\uff0c\u4e0d\u53ef\u91cd\u590d\u542f\u52a8\u3002");
            processInstanceId = bpmMainList.get(0).getProcessInstanceId();
            jo.put("resCode", (Object)resCode);
            jo.put("resMsg", resMsg);
            jo.put("processInstanceId", (Object)processInstanceId);
            return jo.toJSONString();
        }
        String bpmInvokeResult = "1";
        JSONObject paramJo = new JSONObject();
        try {
            if (StringUtils.isNotBlank((CharSequence)bpmMainVo.getDesc())) {
                params.put("desc", bpmMainVo.getDesc());
            }
            if (StringUtils.isNotBlank((CharSequence)bpmMainVo.getTransFlag())) {
                params.put("transFlag", bpmMainVo.getTransFlag());
            }
            LOGGER.info("***BPM-LOG***\u8c03\u5ea6\u6d3e\u5de5start******");
            this.invokeDispatchDrools(params, bpmMainVo);
            LOGGER.info("***BPM-LOG***\u8c03\u5ea6\u6d3e\u5de5end******");
            paramJo.put("businessId", (Object)businessId);
            paramJo.put("autoAcceptFlag", (Object)bpmMainVo.getAutoAcceptFlag());
            paramJo.putAll(params);
            log.setContainerId(containerId);
            log.setProcessId(processId);
            log.setInvokeMethod("startProcess");
            log.setUserCode(bpmMainVo.getUserCode());
            log.setParamJson(paramJo.toJSONString());
            log.setFlag("0");
            List<BpmInterfaceLog> interfaceLogList = this.bpmLogService.findInterfaceLog(log);
            if (interfaceLogList != null && interfaceLogList.size() > 0) {
                bpmInterfaceLog = interfaceLogList.get(0);
            }
            log.setCreatorCode(bpmMainVo.getUserCode());
            log.setCreateTime(new Date());
            params.put("userId", bpmMainVo.getUserCode());
            HashMap<String, Object> uriMap = new HashMap<String, Object>();
            uriMap.put("containerId", containerId);
            uriMap.put("processId", processId);
            String template = "containers/{containerId}/processes/{processId}/instances";
            JSONObject result = this.post(template, uriMap, params, new Map[0]);
            String resData = result.getString("resData");
            if (!"0000".equals(result.get((Object)"resCode"))) {
                throw new BpmException(resData);
            }
            processInstanceId = Long.parseLong(resData);
            bpmMainVo.setProcessInstanceId(processInstanceId);
            BpmMain bpmMain = new BpmMain();
            BeanUtils.copyProperties((Object)bpmMainVo, (Object)bpmMain);
            bpmMain.setContainerId(containerId);
            bpmMain.setInTime(new Date());
            bpmMain.setProcessDesc(processId);
            bpmMain.setCreateTime(new Date());
            this.bpmMainDao.save(bpmMain);
            log.setFlag("1");
        }
        catch (Exception e) {
            bpmInvokeResult = "0";
            log.setFlag("0");
            resCode = "1000";
            resMsg = "***BPM-LOG***\u542f\u52a8\u6d41\u7a0b\u5931\u8d25!\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getLocalizedMessage();
            LOGGER.error("***BPM-LOG***\u542f\u52a8\u6d41\u7a0b\u5931\u8d25!\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getLocalizedMessage(), (Throwable)e);
        }
        log.setProcessInstanceId(processInstanceId);
        if (bpmInterfaceLog != null) {
            log.setUpdaterCode(bpmMainVo.getUserCode());
            log.setId(bpmInterfaceLog.getId());
            this.bpmLogService.updateBpmInterfaceLogFlag(log);
        } else {
            this.bpmLogService.insertBpmInterfaceLog(log, bpmInvokeResult);
        }
        jo.put("resCode", (Object)resCode);
        jo.put("resMsg", resMsg);
        jo.put("processInstanceId", (Object)processInstanceId);
        jo.put("startLog", (Object)log);
        return jo.toJSONString();
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public String startProcess(String processId, Map<String, Object> params, BpmMainVo bpmMainVo) {
        return this.startProcess(processId, processId, params, bpmMainVo);
    }

    @Override
    public String abortProcessInstance(Long taskId, String userId) {
        List<BpmTask> taskList;
        BpmTask bpmTask;
        JSONObject jo = new JSONObject();
        String resCode = "0000";
        Object resMsg = "\u6210\u529f";
        BpmInterfaceLog log = new BpmInterfaceLog();
        log.setTaskId(taskId);
        log.setUserCode(userId);
        log.setInvokeMethod("abortProcessInstance");
        log.setFlag("0");
        BpmInterfaceLog bpmInterfaceLog = null;
        List<BpmInterfaceLog> interfaceLogList = this.bpmLogService.findInterfaceLog(log);
        if (interfaceLogList != null && interfaceLogList.size() > 0) {
            bpmInterfaceLog = interfaceLogList.get(0);
        }
        BpmTask bpmTask2 = bpmTask = (taskList = this.bpmQueryDao.findTaskById(taskId)) != null && taskList.size() > 0 ? taskList.get(0) : new BpmTask();
        if ("Exited".equals(bpmTask.getStatus())) {
            if (bpmInterfaceLog != null) {
                bpmInterfaceLog.setFlag("1");
                bpmInterfaceLog.setUpdaterCode(userId);
                this.bpmLogService.updateBpmInterfaceLogFlag(bpmInterfaceLog);
            }
            jo.put("resCode", (Object)resCode);
            jo.put("resMsg", (Object)"***BPM-LOG***\u7ec8\u6b62\u6d41\u7a0b\u64cd\u4f5c\u5df2\u6210\u529f\uff0c\u4e0d\u518d\u8c03\u7528api\u3002");
            return jo.toJSONString();
        }
        String bpmInvokeResult = "1";
        try {
            String containerId = bpmTask.getContainerId();
            Long processInstanceId = bpmTask.getProcessInstanceId();
            log.setInvokeMethod("abortProcessInstance");
            log.setProcessId(bpmTask.getProcessId());
            log.setContainerId(containerId);
            log.setProcessInstanceId(processInstanceId);
            log.setCreatorCode(userId);
            log.setCreateTime(new Date());
            HashMap<String, Object> urlParams = new HashMap<String, Object>();
            urlParams.put("containerId", containerId);
            urlParams.put("processInstanceId", processInstanceId);
            String template = "containers/{containerId}/processes/instances/{processInstanceId}";
            JSONObject result = this.delete(template, urlParams, String.class, new Map[0]);
            String resData = result.getString("resData");
            if (!"0000".equals(result.get((Object)"resCode"))) {
                throw new BpmException(resData);
            }
            log.setFlag("1");
        }
        catch (Exception e) {
            bpmInvokeResult = "0";
            log.setFlag("0");
            resCode = "1000";
            resMsg = "***BPM-LOG***\u7ec8\u6b62\u6d41\u7a0b\u5931\u8d25!\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getLocalizedMessage();
            LOGGER.error("***BPM-LOG***\u7ec8\u6b62\u6d41\u7a0b\u5931\u8d25!\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getLocalizedMessage(), (Throwable)e);
        }
        if (bpmInterfaceLog != null) {
            log.setUpdaterCode(userId);
            log.setId(bpmInterfaceLog.getId());
            this.bpmLogService.updateBpmInterfaceLogFlag(log);
        } else {
            this.bpmLogService.insertBpmInterfaceLog(log, bpmInvokeResult);
        }
        jo.put("resCode", (Object)resCode);
        jo.put("resMsg", resMsg);
        return jo.toJSONString();
    }

    @Override
    public String signalContainer(Long processInstanceId, String signalName, Object event) {
        BpmProcessInstanceVo pi = this.bpmQueryService.findProcessInstanceById(processInstanceId);
        return this.signalContainer(pi.getContainerId(), signalName, event);
    }

    @Override
    public String signalContainer(String containerId, String signalName, Object event) {
        JSONObject jo = new JSONObject();
        String resCode = "0000";
        Object resMsg = "\u6210\u529f";
        BpmInterfaceLog log = new BpmInterfaceLog();
        String bpmInvokeResult = "1";
        try {
            JSONObject paramJo = new JSONObject();
            paramJo.put("signalName", (Object)signalName);
            paramJo.put("signalValue", event);
            log.setContainerId(containerId);
            log.setInvokeMethod("signalContainer");
            log.setParamJson(paramJo.toJSONString());
            HashMap<String, Object> urlParams = new HashMap<String, Object>();
            urlParams.put("containerId", containerId);
            urlParams.put("signalName", signalName);
            String template = "containers/{containerId}/processes/instances/signal/{signalName}";
            JSONObject result = this.post(template, urlParams, event, new Map[0]);
            String resData = result.getString("resData");
            if (!"0000".equals(result.get((Object)"resCode"))) {
                throw new BpmException(resData);
            }
            log.setFlag("1");
        }
        catch (Exception e) {
            log.setFlag("0");
            bpmInvokeResult = "0";
            resCode = "1000";
            resMsg = "***BPM-LOG***\u5411\u5bb9\u5668\u53d1\u9001\u4fe1\u53f7\u5931\u8d25\uff0c\u5f15\u64ce\u8fd4\u56de\u4fe1\u606f\u5982\u4e0b\uff1a" + e.getLocalizedMessage();
            LOGGER.error("***BPM-LOG***\u5411\u5bb9\u5668\u53d1\u9001\u4fe1\u53f7\u5931\u8d25\uff0c\u5165\u53c2\uff1acontainerId=" + containerId + ",signalName=" + signalName + "\u5f15\u64ce\u8fd4\u56de\u4fe1\u606f\u5982\u4e0b\uff1a", (Throwable)e);
        }
        this.bpmLogService.insertBpmInterfaceLog(log, bpmInvokeResult);
        jo.put("resCode", (Object)resCode);
        jo.put("resMsg", resMsg);
        return jo.toJSONString();
    }

    @Override
    public String signalProcessInstance(Long processInstanceId, String signalName, Object signalValue) {
        BpmProcessInstanceVo pi = this.bpmQueryService.findProcessInstanceById(processInstanceId);
        return this.signalProcessInstance(pi.getContainerId(), processInstanceId, signalName, signalValue);
    }

    @Override
    public String signalProcessInstance(String containerId, Long processInstanceId, String signalName, Object event) {
        JSONObject jo = new JSONObject();
        String resCode = "0000";
        Object resMsg = "\u6210\u529f";
        BpmInterfaceLog log = new BpmInterfaceLog();
        String bpmInvokeResult = "1";
        try {
            JSONObject paramJo = new JSONObject();
            paramJo.put("signalName", (Object)signalName);
            paramJo.put("signalValue", event);
            log.setContainerId(containerId);
            log.setProcessInstanceId(processInstanceId);
            log.setInvokeMethod("signalProcessInstance");
            log.setParamJson(paramJo.toJSONString());
            HashMap<String, Object> urlParams = new HashMap<String, Object>();
            urlParams.put("containerId", containerId);
            urlParams.put("processInstanceId", processInstanceId);
            urlParams.put("signalName", signalName);
            String template = "containers/{containerId}/processes/instances/{processInstanceId}/signal/{signalName}";
            JSONObject result = this.post(template, urlParams, event, new Map[0]);
            String resData = result.getString("resData");
            if (!"0000".equals(result.get((Object)"resCode"))) {
                throw new BpmException(resData);
            }
            log.setFlag("1");
        }
        catch (Exception e) {
            resCode = "1000";
            log.setFlag("0");
            bpmInvokeResult = "0";
            resMsg = "***BPM-LOG***\u5411\u6d41\u7a0b\u5b9e\u4f8b\u53d1\u9001\u4fe1\u53f7\u5931\u8d25\uff0c\u5f15\u64ce\u8fd4\u56de\u4fe1\u606f\u5982\u4e0b\uff1a" + e.getLocalizedMessage();
            LOGGER.error("***BPM-LOG***\u5411\u6d41\u7a0b\u5b9e\u4f8b\u53d1\u9001\u4fe1\u53f7\u5931\u8d25\uff0c\u5165\u53c2\uff1acontainerId=" + containerId + ",processInstanceId=" + processInstanceId + ",signalName=" + signalName + "\u5f15\u64ce\u8fd4\u56de\u4fe1\u606f\u5982\u4e0b\uff1a", (Throwable)e);
        }
        this.bpmLogService.insertBpmInterfaceLog(log, bpmInvokeResult);
        jo.put("resCode", (Object)resCode);
        jo.put("resMsg", resMsg);
        return jo.toJSONString();
    }

    @Override
    public String setProcessVariable(Long processInstanceId, String variableId, Object value) {
        BpmProcessInstanceVo pi = this.bpmQueryService.findProcessInstanceById(processInstanceId);
        return this.setProcessVariable(pi.getContainerId(), processInstanceId, variableId, value);
    }

    @Override
    public String setProcessVariable(String containerId, Long processInstanceId, String variableId, Object value) {
        JSONObject jo = new JSONObject();
        String resCode = "0000";
        Object resMsg = "\u6210\u529f";
        BpmInterfaceLog log = new BpmInterfaceLog();
        String bpmInvokeResult = "1";
        try {
            JSONObject paramJo = new JSONObject();
            paramJo.put("variableId", (Object)variableId);
            paramJo.put("value", value);
            log.setContainerId(containerId);
            log.setProcessInstanceId(processInstanceId);
            log.setInvokeMethod("setProcessVariable");
            log.setParamJson(paramJo.toJSONString());
            HashMap<String, Object> urlParams = new HashMap<String, Object>();
            urlParams.put("containerId", containerId);
            urlParams.put("processInstanceId", processInstanceId);
            urlParams.put("varName", variableId);
            String template = "containers/{containerId}/processes/instances/{processInstanceId}/variable/{varName}";
            JSONObject result = this.put(template, urlParams, value, new Map[0]);
            String resData = result.getString("resData");
            if (!"0000".equals(result.get((Object)"resCode"))) {
                throw new BpmException(resData);
            }
            log.setFlag("1");
        }
        catch (Exception e) {
            resCode = "1000";
            resMsg = "***BPM-LOG***\u8bbe\u7f6e\u6d41\u7a0b\u53d8\u91cf\u503c\u5931\u8d25\uff0c\u5f15\u64ce\u8fd4\u56de\u4fe1\u606f\u5982\u4e0b\uff1a" + e.getLocalizedMessage();
            LOGGER.error("***BPM-LOG***\u8bbe\u7f6e\u6d41\u7a0b\u53d8\u91cf\u503c\u5931\u8d25\uff0c\u5165\u53c2\uff1acontainerId=" + containerId + ",processInstanceId=" + processInstanceId + ",variableId=" + variableId + "\u5f15\u64ce\u8fd4\u56de\u4fe1\u606f\u5982\u4e0b\uff1a", (Throwable)e);
        }
        this.bpmLogService.insertBpmInterfaceLog(log, bpmInvokeResult);
        jo.put("resCode", (Object)resCode);
        jo.put("resMsg", resMsg);
        return jo.toJSONString();
    }
}

