/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.bpm.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.cntaiping.fsc.bpm.dao.BpmMainDao;
import com.cntaiping.fsc.bpm.exception.BpmException;
import com.cntaiping.fsc.bpm.po.BpmMain;
import com.cntaiping.fsc.bpm.po.BpmTask;
import com.cntaiping.fsc.bpm.service.BpmQueryService;
import com.cntaiping.fsc.bpm.service.impl.BaseBpmService;
import com.cntaiping.fsc.bpm.vo.BpmMainVo;
import com.cntaiping.fsc.bpm.vo.BpmProcessInstanceVo;
import com.cntaiping.fsc.bpm.vo.BpmTaskReqVo;
import com.cntaiping.fsc.bpm.vo.BpmTaskResVo;
import com.cntaiping.fsc.bpm.vo.BpmTaskVo;
import com.cntaiping.fsc.bpm.vo.BpmTransferLogVo;
import com.cntaiping.fsc.common.util.Pages;
import com.cntaiping.fsc.core.model.Page;
import com.cntaiping.fsc.core.model.Pageable;
import com.cntaiping.sg.tpsgi.system.sysuser.vo.SysUserVo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kie.server.api.model.instance.ProcessInstance;
import org.kie.server.api.model.instance.ProcessInstanceList;
import org.kie.server.api.model.instance.TaskSummary;
import org.kie.server.api.model.instance.TaskSummaryList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service(value="bpmQueryService")
public class BpmQueryServiceImpl
extends BaseBpmService
implements BpmQueryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BpmQueryServiceImpl.class);
    @Autowired
    private BpmMainDao bpmMainDao;
    @Autowired
    protected RestTemplate restTemplate;

    @Override
    public BpmProcessInstanceVo findProcessInstanceById(Long processInstanceId) {
        BpmProcessInstanceVo pi = null;
        try {
            pi = this.bpmQueryDao.findProcessInstanceById(processInstanceId);
        }
        catch (Exception e) {
            LOGGER.error("***BPM-LOG***\u6839\u636e\u6d41\u7a0b\u5b9e\u4f8bid=" + processInstanceId + "\u67e5\u8be2\u6d41\u7a0b\u5b9e\u4f8b\u5bf9\u8c61\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
        }
        return pi;
    }

    @Override
    public String getProcessImage(String containerId, String processId) {
        String processImage = null;
        try {
            HashMap<String, Object> urlParams = new HashMap<String, Object>();
            urlParams.put("containerId", containerId);
            urlParams.put("processId", processId);
            String template = "containers/{containerId}/images/processes/{processId}";
            HashMap<String, String> headMap = new HashMap<String, String>();
            headMap.put("Accept", "application/svg+xml");
            JSONObject result = this.get(template, urlParams, String.class, headMap);
            String resData = result.getString("resData");
            if (!"0000".equals(result.get((Object)"resCode"))) {
                throw new BpmException(resData);
            }
            processImage = resData;
        }
        catch (Exception e) {
            LOGGER.error("***BPM-LOG***\u83b7\u53d6\u6d41\u7a0b\u56fe\u5931\u8d25\uff0c\u5165\u53c2\uff1acontainerId=" + containerId + ",processId=" + processId, (Throwable)e);
        }
        return processImage;
    }

    @Override
    public String getProcessInstanceImage(Long processInstanceId) {
        BpmProcessInstanceVo pi = this.findProcessInstanceById(processInstanceId);
        return this.getProcessInstanceImage(pi.getContainerId(), processInstanceId);
    }

    @Override
    public String getProcessInstanceImage(String containerId, Long processInstanceId) {
        String processInstanceImage = null;
        try {
            HashMap<String, Object> urlParams = new HashMap<String, Object>();
            urlParams.put("containerId", containerId);
            urlParams.put("processInstanceId", processInstanceId);
            String template = "containers/{containerId}/images/processes/instances/{processInstanceId}";
            HashMap<String, String> headMap = new HashMap<String, String>();
            headMap.put("Accept", "application/svg+xml");
            JSONObject result = this.get(template, urlParams, String.class, headMap);
            String resData = result.getString("resData");
            if (!"0000".equals(result.get((Object)"resCode"))) {
                throw new BpmException(resData);
            }
            processInstanceImage = resData;
        }
        catch (Exception e) {
            LOGGER.error("***BPM-LOG***\u83b7\u53d6\u6d41\u7a0b\u5b9e\u4f8b\u6d41\u8f6c\u56fe\u5931\u8d25\uff0c\u5165\u53c2\uff1acontainerId=" + containerId + ",processInstanceId=" + processInstanceId, (Throwable)e);
        }
        return processInstanceImage;
    }

    @Override
    public List<ProcessInstance> findProcessInstances(String containerId, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        ArrayList processInstances;
        block3: {
            processInstances = null;
            try {
                HashMap<String, Object> urlParams = new HashMap<String, Object>();
                urlParams.put("containerId", containerId);
                String queryString = this.getPagingQueryString("?sort=" + sort + "&sortOrder=" + sortOrder, page, pageSize);
                String template = "containers/{containerId}/processes/instances" + queryString;
                JSONObject result = this.get(template, urlParams, ProcessInstanceList.class, new Map[0]);
                Object resData = result.get((Object)"resData");
                if ("0000".equals(result.get((Object)"resCode"))) {
                    processInstances = resData != null ? ((ProcessInstanceList)resData).getItems() : new ArrayList();
                    break block3;
                }
                throw new BpmException("responseBody:" + resData);
            }
            catch (Exception e) {
                LOGGER.error("***BPM-LOG***\u83b7\u53d6\u5bb9\u5668\u5bf9\u5e94\u6240\u6709\u4efb\u52a1\u5b9e\u4f8b\u96c6\u5408\u5931\u8d25\uff0c\u5165\u53c2\uff1acontainerId=" + containerId + ",page=" + page + ",pageSize=" + pageSize + ",sort=" + sort + ",sortOrder" + sortOrder, (Throwable)e);
            }
        }
        return processInstances;
    }

    @Override
    public List<BpmMainVo> findActiveBpmMain(String processId, String innerRefNo) {
        List<BpmMainVo> bpmMainVos = null;
        try {
            if (StringUtils.isBlank((CharSequence)innerRefNo)) {
                throw new BpmException("The innerRefNo can't be null!");
            }
            bpmMainVos = this.bpmQueryDao.findActiveBpmMain(processId, innerRefNo);
        }
        catch (Exception e) {
            LOGGER.error("***BPM-LOG***\u67e5\u8be2\u6d3b\u52a8\u7684BpmMain\u6d41\u7a0b\u5b9e\u4f8b\u5931\u8d25\uff0c\u5165\u53c2\uff1aprocessId={},innerRefNo={}\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", new Object[]{processId, innerRefNo, e.getLocalizedMessage()});
        }
        return bpmMainVos;
    }

    @Override
    public List<BpmMainVo> findActiveBpmMainByCondition(String processId, String innerRefNo) {
        List<BpmMainVo> bpmMainVos = null;
        try {
            if (StringUtils.isBlank((CharSequence)innerRefNo)) {
                throw new BpmException("The innerRefNo can't be null!");
            }
            bpmMainVos = this.bpmQueryDao.findActiveBpmMainByCondition(processId, innerRefNo);
        }
        catch (Exception e) {
            LOGGER.error("***BPM-LOG***\u7528\u4e8e\u7ed3\u6848\u65f6\u67e5\u8be2\u7406\u8d54\u6d3b\u52a8\u7684bpmMain\u6d41\u7a0b\u5b9e\u4f8b\u5931\u8d25\uff0c\u5165\u53c2\uff1aprocessId={},innerRefNo={}\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", new Object[]{processId, innerRefNo, e.getLocalizedMessage()});
        }
        return bpmMainVos;
    }

    @Override
    public String findProcessInstanceStatus(String processId, String businessId) {
        String status = "";
        try {
            Integer processInstanceStatus;
            if (StringUtils.isBlank((CharSequence)processId) || StringUtils.isBlank((CharSequence)businessId)) {
                throw new BpmException("The processId|businessId can't be null!");
            }
            BpmProcessInstanceVo bpmProcessInstanceVo = this.bpmQueryDao.findProcessInstanceByProcessIdAndBusinessId(processId, businessId);
            status = bpmProcessInstanceVo == null ? "-1" : ((processInstanceStatus = bpmProcessInstanceVo.getStatus()) == 2 || processInstanceStatus == 3 ? "2" : "1");
        }
        catch (Exception e) {
            LOGGER.error("***BPM-LOG***\u67e5\u8be2\u6307\u5b9a\u6d41\u7a0b\u5b9e\u4f8b\u662f\u5426\u5b58\u5728\u53ca\u5176\u6d3b\u52a8\u72b6\u6001\u5931\u8d25\uff0c\u5165\u53c2\uff1aprocessId={},businessId={}\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", new Object[]{processId, businessId, e.getLocalizedMessage()});
        }
        return status;
    }

    @Override
    public BpmTaskVo findTaskById(Long taskId) {
        BpmTaskVo taskVo = null;
        try {
            Assert.notNull((Object)taskId, (String)"taskId must not be null");
            List<BpmTask> tasks = this.bpmQueryDao.findTaskById(taskId);
            if (tasks != null && tasks.size() > 0) {
                BpmTask bpmTask = tasks.get(0);
                taskVo = new BpmTaskVo();
                BeanUtils.copyProperties((Object)bpmTask, (Object)taskVo);
            }
        }
        catch (Exception e) {
            LOGGER.error("***BPM-LOG***\u83b7\u53d6\u4efb\u52a1\u5b9e\u4f8b\u5bf9\u8c61\u5931\u8d25\uff0c\u5165\u53c2\uff1ataskId=" + taskId, (Throwable)e);
        }
        return taskVo;
    }

    @Override
    public BpmTaskVo findCompensationTaskById(Long taskId) {
        BpmTaskVo taskVo = null;
        try {
            Assert.notNull((Object)taskId, (String)"taskId must not be null");
            List<BpmTask> tasks = this.bpmQueryDao.findCompensationTaskById(taskId);
            if (tasks != null && tasks.size() > 0) {
                BpmTask bpmTask = tasks.get(0);
                taskVo = new BpmTaskVo();
                BeanUtils.copyProperties((Object)bpmTask, (Object)taskVo);
            }
        }
        catch (Exception e) {
            LOGGER.error("***BPM-LOG***\u83b7\u53d6\u8865\u507f\u540e\u4efb\u52a1\u5b9e\u4f8b\u5bf9\u8c61\u5931\u8d25\uff0c\u5165\u53c2\uff1ataskId=" + taskId, (Throwable)e);
        }
        return taskVo;
    }

    @Override
    public List<TaskSummary> findTasksOwned(String userId, List<String> statusList, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        ArrayList taskSummaryList;
        block4: {
            taskSummaryList = null;
            if (statusList == null) {
                statusList = Arrays.asList("Created", "Ready", "Reserved", "InProgress", "Suspended", "Completed", "Failed", "Error", "Exited", "Obsolete");
            }
            try {
                String userQuery = "?user=" + userId;
                String statusQuery = this.getAdditionalParams(userQuery, "status", statusList);
                String queryString = this.getPagingQueryString(statusQuery, page, pageSize) + "&sort=" + sort + "&sortOrder=" + sortOrder;
                StringBuilder template = new StringBuilder();
                template.append("queries");
                template.append("/");
                template.append("tasks/instances/owners");
                template.append(queryString);
                JSONObject result = this.get(template.toString(), null, TaskSummaryList.class, new Map[0]);
                Object resData = result.get((Object)"resData");
                if ("0000".equals(result.getString("resCode"))) {
                    taskSummaryList = resData != null ? ((TaskSummaryList)resData).getItems() : new ArrayList();
                    break block4;
                }
                throw new BpmException("responseBody:" + resData);
            }
            catch (Exception e) {
                LOGGER.error("***BPM-LOG***\u6839\u636e\u7528\u6237id\u67e5\u8be2\u5176\u62e5\u6709\u7684\u4efb\u52a1\u96c6\u5408\u5931\u8d25\uff0c\u5165\u53c2\uff1auserId=" + userId + ",page=" + page + ",pageSize=" + pageSize + ",sort=" + sort + ",sortOrder" + sortOrder, (Throwable)e);
            }
        }
        return taskSummaryList;
    }

    @Override
    public Page<BpmTaskResVo> findTasksList(BpmTaskReqVo bpmTaskReqVo, Pageable pageParam) {
        List historyOpinions;
        if ("1".equals(bpmTaskReqVo.getModule()) && StringUtils.isNotEmpty((CharSequence)bpmTaskReqVo.getInnerRefNo())) {
            String claimApiUrl = this.bpmConfig.getClaimsApiUrl() + "claim/getExistingInnerRefNo";
            HttpHeaders headers = new HttpHeaders();
            MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
            headers.setContentType(type);
            headers.add("Accept", MediaType.APPLICATION_JSON.toString());
            ResponseEntity result = this.restTemplate.getForEntity(claimApiUrl + "/" + bpmTaskReqVo.getInnerRefNo(), String.class, new Object[0]);
            LOGGER.info("Http Response StatusCode: " + result.getStatusCode());
            if (!result.getStatusCode().equals(HttpStatus.OK)) {
                throw new RestClientException(String.format("Http Request Error, statusCode: %s", result.getStatusCode()));
            }
            Object resData = JSONObject.parseObject((String)((String)result.getBody())).get((Object)"resData");
            List innerRefNos = JSON.parseArray((String)resData.toString(), String.class);
            if (!CollectionUtils.isEmpty((Collection)innerRefNos)) {
                bpmTaskReqVo.setInnerRefNo(null);
                bpmTaskReqVo.setInnerRefNos(innerRefNos);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)bpmTaskReqVo.getProductCode())) {
            bpmTaskReqVo.setProductCodeList(Arrays.asList(bpmTaskReqVo.getProductCode().split(",")));
        }
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        if (!"4".equals(bpmTaskReqVo.getIncludeSubTaskStr())) {
            if (bpmTaskReqVo.getIsTaskAssign().booleanValue()) {
                if (bpmTaskReqVo.getIncludeSubTask().booleanValue()) {
                    bpmTaskReqVo.setIncludeSubTaskStr("2");
                } else {
                    bpmTaskReqVo.setIncludeSubTaskStr("3");
                }
            } else if (bpmTaskReqVo.getIncludeSubTask().booleanValue()) {
                bpmTaskReqVo.setIncludeSubTaskStr("1");
            } else {
                bpmTaskReqVo.setIncludeSubTaskStr("0");
            }
        }
        map.put("taskVo", bpmTaskReqVo);
        Page<BpmTaskVo> tasksList = this.bpmQueryDao.findTasksList(map, pageParam);
        List<Long> ids = tasksList.getContent().stream().map(e -> e.getTaskId()).collect(Collectors.toList());
        if (ids != null && ids.size() > 0 && (historyOpinions = this.bpmQueryDao.findHistoryOpinions(ids)) != null && historyOpinions.size() > 0) {
            tasksList.getContent().forEach(bpmTaskVo -> {
                List collect = historyOpinions.stream().filter(options -> options.get("taskid") != null && Long.valueOf(options.get("taskid").toString()).equals(bpmTaskVo.getTaskId())).collect(Collectors.toList());
                if (collect != null && collect.size() > 0) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (Map stringObjectMap : collect) {
                        stringBuilder.append((String)(stringObjectMap.get("opinions") != null ? stringObjectMap.get("opinions").toString().replaceAll("\n", ";") + ";" : ""));
                    }
                    if (stringBuilder.length() > 0) {
                        String string = stringBuilder.toString();
                        if (string.endsWith(";")) {
                            string = string.substring(0, string.length() - 1);
                        }
                        bpmTaskVo.setHistoryOpinions(string);
                    }
                }
            });
        }
        return Pages.convert(tasksList, BpmTaskResVo.class);
    }

    @Override
    public List<BpmTaskResVo> findTasksList(BpmTaskReqVo bpmTaskReqVo) {
        if ("1".equals(bpmTaskReqVo.getModule()) && StringUtils.isNotEmpty((CharSequence)bpmTaskReqVo.getInnerRefNo())) {
            String claimApiUrl = this.bpmConfig.getClaimsApiUrl() + "claim/getExistingInnerRefNo";
            HttpHeaders headers = new HttpHeaders();
            MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
            headers.setContentType(type);
            headers.add("Accept", MediaType.APPLICATION_JSON.toString());
            ResponseEntity result = this.restTemplate.getForEntity(claimApiUrl + "/" + bpmTaskReqVo.getInnerRefNo(), String.class, new Object[0]);
            LOGGER.info("Http Response StatusCode: " + result.getStatusCode());
            if (!result.getStatusCode().equals(HttpStatus.OK)) {
                throw new RestClientException(String.format("Http Request Error, statusCode: %s", result.getStatusCode().value()));
            }
            Object resData = JSONObject.parseObject((String)((String)result.getBody())).get((Object)"resData");
            List innerRefNos = JSON.parseArray((String)resData.toString(), String.class);
            if (!CollectionUtils.isEmpty((Collection)innerRefNos)) {
                bpmTaskReqVo.setInnerRefNo(null);
                bpmTaskReqVo.setInnerRefNos(innerRefNos);
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        if (bpmTaskReqVo.getIsTaskAssign().booleanValue()) {
            if (bpmTaskReqVo.getIncludeSubTask().booleanValue()) {
                bpmTaskReqVo.setIncludeSubTaskStr("2");
            } else {
                bpmTaskReqVo.setIncludeSubTaskStr("3");
            }
        } else if (bpmTaskReqVo.getIncludeSubTask().booleanValue()) {
            bpmTaskReqVo.setIncludeSubTaskStr("1");
        } else {
            bpmTaskReqVo.setIncludeSubTaskStr("0");
        }
        map.put("taskVo", bpmTaskReqVo);
        List<BpmTaskVo> tasksList = this.bpmQueryDao.findTasksList(map);
        if (tasksList != null && tasksList.size() > 0) {
            tasksList.forEach(e -> {
                switch (e.getPlatformCode()) {
                    case "EBOC": {
                        e.setPlatformCode("\u4e2d\u94f6\u94f6\u4fdd\u901a");
                        break;
                    }
                    case "ETPPC": {
                        e.setPlatformCode("e\u592a\u5e73PC\u7aef");
                        break;
                    }
                    case "ETPAPP": {
                        e.setPlatformCode("e\u592a\u5e73\u79fb\u52a8\u7aef");
                        break;
                    }
                    case "ESHARE": {
                        e.setPlatformCode("\u4e09\u5730\u8f66\u5e73\u53f0");
                        break;
                    }
                    case "EBANKS": {
                        e.setPlatformCode("\u5404\u94f6\u884c\u51fa\u5355\u5e73\u53f0");
                        break;
                    }
                    case "EKSMTH": {
                        e.setPlatformCode("\u5e7f\u661f\u4e1c\u505c\u8f66\u573a\u4fdd\u9669\u5e73\u53f0");
                        break;
                    }
                    case "TPIAPP": {
                        e.setPlatformCode("\u8de8\u5883\u8f66\u5fae\u4fe1\u5c0f\u7a0b\u5e8f");
                        break;
                    }
                    case "B2CAPP": {
                        e.setPlatformCode("B2C\u79fb\u52a8\u7aef");
                        break;
                    }
                    case "B2CPC": {
                        e.setPlatformCode("B2CPC\u7aef");
                        break;
                    }
                    default: {
                        e.setPlatformCode("Core System");
                    }
                }
            });
        }
        return Pages.convert(tasksList, BpmTaskResVo.class);
    }

    @Override
    public List<BpmTaskVo> findTaskListByProcessInstanceId(Long processInstanceId) {
        ArrayList<BpmTaskVo> taskVos = new ArrayList<BpmTaskVo>();
        try {
            Assert.notNull((Object)processInstanceId, (String)"processInstanceId must not be null!");
            List<BpmTask> tasks = this.bpmQueryDao.findTaskListByProcessInstanceId(processInstanceId);
            if (tasks != null) {
                for (int i = 0; i < tasks.size(); ++i) {
                    BpmTaskVo bpmTaskVo = new BpmTaskVo();
                    BeanUtils.copyProperties((Object)tasks.get(i), (Object)bpmTaskVo);
                    taskVos.add(bpmTaskVo);
                }
            }
        }
        catch (BeansException e) {
            LOGGER.error("\u6839\u636e\u6d41\u7a0b\u5b9e\u4f8bid\u67e5\u8be2\u4efb\u52a1\u96c6\u5408\u5931\u8d25\uff0c\u5165\u53c2processInstanceId=" + processInstanceId + "\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getLocalizedMessage(), (Throwable)e);
        }
        return taskVos;
    }

    @Override
    public List<Long> findErrorFlowTaskList(List<Long> taskList) {
        List<Long> newTaskList = new ArrayList<Long>();
        if (taskList != null && taskList.size() > 0) {
            newTaskList = this.bpmQueryDao.findErrorFlowTaskList(taskList);
        }
        return newTaskList;
    }

    @Override
    @Deprecated
    public List<TaskSummary> findTasksByStatusByProcessInstanceId(Long processInstanceId, List<String> statusList, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        ArrayList taskSummaryList;
        block4: {
            taskSummaryList = null;
            if (statusList == null) {
                statusList = Arrays.asList("Created", "Ready", "Reserved", "InProgress", "Suspended", "Completed", "Failed", "Error", "Exited", "Obsolete");
            }
            try {
                HashMap<String, Object> urlParams = new HashMap<String, Object>();
                urlParams.put("processInstanceId", processInstanceId);
                String statusQuery = this.getAdditionalParams("", "status", statusList);
                String queryString = this.getPagingQueryString(statusQuery, page, pageSize) + "&sort=" + sort + "&sortOrder=" + sortOrder;
                StringBuilder template = new StringBuilder();
                template.append("queries");
                template.append("/");
                template.append("tasks/instances/process/{processInstanceId}");
                template.append(queryString);
                JSONObject result = this.get(template.toString(), urlParams, TaskSummaryList.class, new Map[0]);
                Object resData = result.get((Object)"resData");
                if ("0000".equals(result.getString("resCode"))) {
                    taskSummaryList = resData != null ? ((TaskSummaryList)resData).getItems() : new ArrayList();
                    break block4;
                }
                throw new BpmException("responseBody:" + resData);
            }
            catch (Exception e) {
                LOGGER.error("\u6839\u636e\u6d41\u7a0b\u5b9e\u4f8bid\u548c\u4efb\u52a1\u72b6\u6001\u67e5\u8be2\u5bf9\u5e94\u4efb\u52a1\u96c6\u5408\u5931\u8d25\uff0c\u5165\u53c2\uff1aprocessInstanceId=" + processInstanceId + ",page=" + page + ",pageSize=" + pageSize + ",sort=" + sort + ",sortOrder" + sortOrder, (Throwable)e);
            }
        }
        return taskSummaryList;
    }

    @Override
    public String findLeastTasksActor(List<String> actors) {
        String actor = null;
        if (actors != null && actors.size() > 0) {
            actor = this.bpmQueryDao.findLeastTasksActor(actors);
        }
        return actor;
    }

    @Override
    public List<Long> findNextTaskIdByNodeInstanceLog(Long taskId) {
        Map<String, Object> map = this.bpmQueryDao.findNodeInstanceLogByTaskId(taskId);
        ArrayList<Long> nextTasKIdList = new ArrayList<Long>();
        if (map != null && map.size() > 0) {
            List<Map<String, Object>> nextHumanTaskLog = this.findNodeInstanceLogByRecursive(map);
            for (Map<String, Object> ele : nextHumanTaskLog) {
                Long nextTaskId = this.bpmQueryDao.findNextTaskIdByNodeInstanceLog((Long)ele.get("processinstanceid"), (Long)ele.get("workitemid"));
                nextTasKIdList.add(nextTaskId);
            }
        }
        return nextTasKIdList;
    }

    private List<Map<String, Object>> findNodeInstanceLogByRecursive(Map<String, Object> map) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        String connection = (String)map.get("connection");
        Long processInstanceId = (Long)map.get("processinstanceid");
        List<Map<String, Object>> nextList = this.bpmQueryDao.findNextNodeInstanceLog(connection, processInstanceId);
        for (Map<String, Object> ele : nextList) {
            if (ele.get("nodetype").equals("HumanTaskNode")) {
                list.add(ele);
                continue;
            }
            Map<String, Object> outLog = this.bpmQueryDao.findOutflowNodeInstanceLog(ele);
            list.addAll(this.findNodeInstanceLogByRecursive(outLog));
        }
        return list;
    }

    @Override
    public List<Long> findNextTaskId(Long taskId) {
        List<Long> nextTaskIds = null;
        try {
            if (taskId == null) {
                throw new BpmException("taskId not be null!");
            }
            nextTaskIds = this.bpmQueryDao.findNextTaskId(taskId);
        }
        catch (BpmException e) {
            LOGGER.error("***BPM-LOG***\u67e5\u8be2\u540e\u7eed\u4efb\u52a1id\u5931\u8d25\uff0c\u5165\u53c2\uff1ataskId=" + taskId, (Throwable)e);
        }
        return nextTaskIds;
    }

    @Override
    public Long findPreviousTaskId(Long taskId) {
        Long previousTaskId = null;
        try {
            if (taskId == null) {
                throw new BpmException("taskId not be null!");
            }
            previousTaskId = this.bpmQueryDao.findPreviousTaskId(taskId);
        }
        catch (BpmException e) {
            LOGGER.error("***BPM-LOG***\u67e5\u8be2\u4e0a\u4e00\u4efb\u52a1id\u5931\u8d25\uff0c\u5165\u53c2\uff1ataskId=" + taskId, (Throwable)e);
        }
        return previousTaskId;
    }

    @Override
    public List<SysUserVo> findPotentialOwnerByTaskId(Long taskId) {
        List<SysUserVo> potOwners = null;
        try {
            if (taskId == null) {
                throw new BpmException("taskId not be null!");
            }
            potOwners = this.bpmQueryDao.findPotentialOwnerByTaskId(taskId);
        }
        catch (BpmException e) {
            LOGGER.error("***BPM-LOG***\u6839\u636e\u4efb\u52a1id\u67e5\u8be2\u5176\u6240\u6709\u7684\u6f5c\u5728\u62e5\u6709\u8005\u5931\u8d25\uff0c\u5165\u53c2\uff1ataskId=" + taskId, (Throwable)e);
        }
        return potOwners;
    }

    @Override
    public Page<SysUserVo> findPotentialOwnerOnlyByTaskId(Long taskId, Pageable pageParam) {
        Page<SysUserVo> potOwners = null;
        try {
            if (taskId == null) {
                throw new BpmException("taskId not be null!");
            }
            potOwners = this.bpmQueryDao.findPotentialOwnerOnlyByTaskId(taskId, pageParam);
        }
        catch (BpmException e) {
            LOGGER.error("***BPM-LOG***\u6839\u636e\u4efb\u52a1id\u67e5\u8be2\u5176\u6f5c\u5728\u62e5\u6709\u8005\uff08\u4e0d\u5305\u542bAdministrators\u89d2\u8272\u4eba\u5458\uff09\u5931\u8d25\uff0c\u5165\u53c2\uff1ataskId=" + taskId, (Throwable)e);
        }
        return potOwners;
    }

    @Override
    public Page<BpmTaskResVo> findTaskHistory(Long processInstanceId, Pageable pageParam) {
        if (processInstanceId == null) {
            return new Page(new ArrayList(), pageParam, 0L);
        }
        Page<BpmTaskResVo> tasksList = this.bpmQueryDao.findTaskHistory(processInstanceId, pageParam);
        return tasksList;
    }

    @Override
    public Page<BpmTaskResVo> findTaskHistory(String processId, String businessId, Pageable pageParam) {
        Long processInstanceId;
        BpmMain bpmMain = new BpmMain();
        bpmMain.setBusinessId(businessId);
        bpmMain.setProcessId(processId);
        bpmMain.setValidInd(true);
        List<BpmMain> bpmMainList = this.bpmMainDao.findBpmMain(bpmMain);
        if (!CollectionUtils.isEmpty(bpmMainList)) {
            bpmMain = bpmMainList.get(0);
        }
        if ((processInstanceId = bpmMain.getProcessInstanceId()) == null) {
            return new Page(new ArrayList(), pageParam, 0L);
        }
        Page<BpmTaskResVo> tasksList = this.bpmQueryDao.findTaskHistory(processInstanceId, pageParam);
        return Pages.convert(tasksList, BpmTaskResVo.class);
    }

    @Override
    public List<BpmTaskVo> findTaskListByCondition(BpmTaskVo bpmTaskVo) {
        ArrayList<BpmTaskVo> taskVos = null;
        try {
            List<BpmTask> tasks = this.bpmQueryDao.findTaskListByCondition(bpmTaskVo);
            if (tasks != null && tasks.size() > 0) {
                taskVos = new ArrayList<BpmTaskVo>();
                for (int i = 0; i < tasks.size(); ++i) {
                    BpmTaskVo vo = new BpmTaskVo();
                    BeanUtils.copyProperties((Object)tasks.get(i), (Object)vo);
                    taskVos.add(vo);
                }
            }
        }
        catch (BpmException e) {
            LOGGER.error("***BPM-LOG***\u6839\u636e\u6307\u5b9a\u6761\u4ef6\u67e5\u8be2\u5bf9\u5e94\u7684\u4efb\u52a1\u5217\u8868\u5931\u8d25", (Throwable)e);
        }
        return taskVos;
    }

    @Override
    public List<BpmTaskVo> findTaskEventListByProcessInstanceId(Long processInstanceId) {
        ArrayList<BpmTaskVo> taskVos = null;
        try {
            List<BpmTask> tasks = this.bpmQueryDao.findTaskEventListByProcessInstanceId(processInstanceId);
            if (tasks != null && tasks.size() > 0) {
                taskVos = new ArrayList<BpmTaskVo>();
                for (int i = 0; i < tasks.size(); ++i) {
                    BpmTaskVo vo = new BpmTaskVo();
                    BeanUtils.copyProperties((Object)tasks.get(i), (Object)vo);
                    taskVos.add(vo);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("***BPM-LOG***\u6839\u636e\u6d41\u7a0b\u5b9e\u4f8bid=" + processInstanceId + "\u67e5\u8be2\u4efb\u52a1\u4e8b\u4ef6\u5217\u8868\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
        }
        return taskVos;
    }

    @Override
    public Page<BpmTransferLogVo> findTaskTransferHistory(BpmTransferLogVo transferLogVo, Pageable pageParam) {
        if (transferLogVo.getTaskId() == null && StringUtils.isBlank((CharSequence)transferLogVo.getUserId()) && StringUtils.isBlank((CharSequence)transferLogVo.getCreatorCode()) && transferLogVo.getsCreateTime() == null && transferLogVo.geteCreateTime() == null) {
            LOGGER.info("***BPM-LOG***\u4efb\u52a1\u79fb\u4ea4\u67e5\u8be2\u6761\u4ef6\u90fd\u4e3a\u7a7a\uff01");
            return new Page(new ArrayList(), pageParam, 0L);
        }
        Page<BpmTransferLogVo> taskTransferList = this.bpmQueryDao.findTaskTransferHistory(transferLogVo, pageParam);
        return Pages.convert(taskTransferList, BpmTransferLogVo.class);
    }

    @Override
    public Page<BpmTaskResVo> findTastByInnerRefNo(String innerRefNo, Pageable pageParam) {
        if (StringUtils.isBlank((CharSequence)innerRefNo)) {
            return new Page(new ArrayList(), pageParam, 0L);
        }
        Page<BpmTask> tasksList = this.bpmQueryDao.findTastByInnerRefNo(innerRefNo, pageParam);
        return Pages.convert(tasksList, BpmTaskResVo.class);
    }

    @Override
    public List<BpmTaskResVo> findTastByInnerRefNo(String innerRefNo) {
        List<BpmTask> tasksList = this.bpmQueryDao.findTastByInnerRefNo(innerRefNo);
        return Pages.convert(tasksList, BpmTaskResVo.class);
    }

    @Override
    public Page<BpmTaskResVo> findTastByInnerRefNos(BpmTaskReqVo bpmTaskReqVo, Pageable pageParam) {
        List<String> innerRefNos = bpmTaskReqVo.getInnerRefNos();
        ArrayList<String> innerRefNoList = new ArrayList<String>(innerRefNos);
        if (innerRefNoList == null || innerRefNoList.isEmpty()) {
            return new Page(new ArrayList(), pageParam, 0L);
        }
        Page<BpmTask> tasksList = this.bpmQueryDao.findTastByInnerRefNos(bpmTaskReqVo, pageParam);
        return Pages.convert(tasksList, BpmTaskResVo.class);
    }

    @Override
    public List<BpmTaskResVo> findInitiatorByProcessInstanceId(Long processInstanceId) {
        ArrayList<BpmTaskVo> taskVos = new ArrayList<BpmTaskVo>();
        try {
            Assert.notNull((Object)processInstanceId, (String)"processInstanceId must not be null!");
            List<BpmTask> tasks = this.bpmQueryDao.findInitiatorByProcessInstanceId(processInstanceId);
            if (tasks != null) {
                for (int i = 0; i < tasks.size(); ++i) {
                    BpmTaskVo bpmTaskVo = new BpmTaskVo();
                    BeanUtils.copyProperties((Object)tasks.get(i), (Object)bpmTaskVo);
                    taskVos.add(bpmTaskVo);
                }
            }
        }
        catch (BeansException e) {
            LOGGER.error("\u6839\u636eprocessInstanceId\u67e5\u8be2\u53d1\u8d77\u4eba\u5931\u8d25\uff0c\u5165\u53c2processInstanceId=" + processInstanceId + "\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getLocalizedMessage(), (Throwable)e);
        }
        return Pages.convert(taskVos, BpmTaskResVo.class);
    }

    @Override
    public List<BpmTaskVo> findTastByInnerRefNosNoPage(BpmTaskReqVo bpmTaskReqVo) {
        List<String> innerRefNos = bpmTaskReqVo.getInnerRefNos();
        ArrayList<String> innerRefNoList = new ArrayList<String>(innerRefNos);
        if (innerRefNoList.isEmpty()) {
            return new ArrayList<BpmTaskVo>();
        }
        List<BpmTaskVo> tasksList = this.bpmQueryDao.findTastByInnerRefNosNoPage(bpmTaskReqVo);
        ArrayList<BpmTaskVo> returnTaskVoList = new ArrayList<BpmTaskVo>();
        if (tasksList != null && tasksList.size() > 0) {
            for (BpmTaskVo bpmTaskVo : tasksList) {
                if ("Processed".equals(bpmTaskVo.getStatus()) || Objects.equals(bpmTaskReqVo.getTaskId(), bpmTaskVo.getTaskId()) || "reminder".equals(bpmTaskVo.getProcessDesc())) continue;
                returnTaskVoList.add(bpmTaskVo);
            }
        }
        return returnTaskVoList;
    }
}

