/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.bpm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.cntaiping.fsc.bpm.dao.BpmTransferFactoryDao;
import com.cntaiping.fsc.bpm.dao.BpmTransferLogDao;
import com.cntaiping.fsc.bpm.exception.BpmException;
import com.cntaiping.fsc.bpm.po.BpmInterfaceLog;
import com.cntaiping.fsc.bpm.po.BpmTask;
import com.cntaiping.fsc.bpm.po.BpmTransferFactory;
import com.cntaiping.fsc.bpm.po.BpmTransferLog;
import com.cntaiping.fsc.bpm.service.BpmLogService;
import com.cntaiping.fsc.bpm.service.BpmTaskService;
import com.cntaiping.fsc.bpm.service.impl.BaseBpmService;
import com.cntaiping.fsc.bpm.vo.BpmMainVo;
import com.cntaiping.fsc.bpm.vo.BpmNodeVariableVo;
import com.cntaiping.fsc.bpm.vo.BpmTaskReqVo;
import com.cntaiping.fsc.common.util.Commons;
import com.cntaiping.fsc.core.model.Page;
import com.cntaiping.fsc.core.model.Pageable;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kie.server.api.model.admin.OrgEntities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="bpmTaskService")
public class BpmTaskServiceImpl
extends BaseBpmService
implements BpmTaskService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BpmTaskServiceImpl.class);
    @Autowired
    private BpmLogService bpmLogService;
    @Autowired
    private BpmTransferFactoryDao bpmTransferFactoryDao;
    @Autowired
    protected BpmTransferLogDao bpmTransferLogDao;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String acceptTask(Long taskId, String userId) {
        List<BpmTask> taskList;
        BpmTask bpmTask;
        String status;
        JSONObject jo = new JSONObject();
        String resCode = "0000";
        Object resMsg = "\u6210\u529f";
        BpmInterfaceLog log = new BpmInterfaceLog();
        String containerId = "";
        String bpmInvokeResult = "1";
        log.setTaskId(taskId);
        log.setUserCode(userId);
        log.setInvokeMethod("acceptTask");
        BpmInterfaceLog bpmInterfaceLog = null;
        log.setFlag("0");
        List<BpmInterfaceLog> interfaceLogList = this.bpmLogService.findInterfaceLog(log);
        if (interfaceLogList != null && interfaceLogList.size() > 0) {
            bpmInterfaceLog = interfaceLogList.get(0);
        }
        if ("InProgress".equals(status = (bpmTask = (taskList = this.bpmQueryDao.findTaskById(taskId)) != null && taskList.size() > 0 ? taskList.get(0) : new BpmTask()).getStatus()) || "Completed".equals(status)) {
            if (bpmInterfaceLog != null) {
                bpmInterfaceLog.setFlag("1");
                bpmInterfaceLog.setUpdaterCode(userId);
                this.bpmLogService.updateBpmInterfaceLogFlag(bpmInterfaceLog);
            }
            jo.put("resCode", (Object)resCode);
            jo.put("resMsg", (Object)"***BPM-LOG***\u8ba4\u9886\u4efb\u52a1\u64cd\u4f5c\u5df2\u6210\u529f\uff0c\u4e0d\u518d\u8c03\u7528api\u3002");
            return jo.toJSONString();
        }
        try {
            containerId = bpmTask.getContainerId();
            log.setProcessId(bpmTask.getProcessId());
            log.setContainerId(containerId);
            log.setProcessInstanceId(bpmTask.getProcessInstanceId());
            log.setCreatorCode(userId);
            log.setCreateTime(new Date());
            if ("Ready".equals(status) || "Reserved".equals(status)) {
                HashMap<String, Object> urlParams = new HashMap<String, Object>();
                urlParams.put("containerId", containerId);
                urlParams.put("taskInstanceId", taskId);
                String template = "containers/{containerId}/tasks/{taskInstanceId}/states/started?user=" + userId;
                JSONObject result = this.put(template, urlParams, null, new Map[0]);
                if (!"0000".equals(result.getString("resCode"))) throw new BpmException(result.getString("resData"));
                log.setFlag("1");
            } else {
                resCode = "1000";
                resMsg = "***BPM-LOG***\u8ba4\u9886\u4efb\u52a1\u5931\u8d25\uff0c\u4e0d\u53ef\u6267\u884c\u8be5\u64cd\u4f5c\uff0c\u5165\u53c2\uff1acontainerId=" + containerId + ",taskId=" + taskId + ",\u72b6\u6001\u4e3a" + status;
                LOGGER.error((String)resMsg);
            }
        }
        catch (Exception e) {
            bpmInvokeResult = "0";
            log.setFlag("0");
            resCode = "10000";
            resMsg = "***BPM-LOG***\u8ba4\u9886\u4efb\u52a1\u5931\u8d25\uff0c\u5165\u53c2\uff1acontainerId=" + containerId + ",taskId=" + taskId + "\u5f15\u64ce\u8fd4\u56de\u4fe1\u606f\u5982\u4e0b\uff1a" + e.getLocalizedMessage();
            LOGGER.error((String)resMsg + "\u5f15\u64ce\u8fd4\u56de\u4fe1\u606f\u5982\u4e0b\uff1a", (Throwable)e);
        }
        if (bpmInterfaceLog != null) {
            log.setUpdaterCode(userId);
            log.setId(bpmInterfaceLog.getId());
            this.bpmLogService.updateBpmInterfaceLogFlag(log);
        } else {
            this.bpmLogService.insertBpmInterfaceLog(log, bpmInvokeResult);
        }
        jo.put("resCode", (Object)resCode);
        jo.put("resMsg", resMsg);
        jo.put("acceptLog", (Object)log);
        return jo.toJSONString();
    }

    @Override
    public String delegateTask(Long taskId, String userId, String targetUserId, String handlerCode) {
        JSONObject jo = new JSONObject();
        String resCode = "0000";
        Object resMsg = "\u6210\u529f";
        String containerId = "";
        try {
            List<BpmTask> taskList = this.bpmQueryDao.findTaskById(taskId);
            BpmTask bpmTask = taskList != null && taskList.size() > 0 ? taskList.get(0) : new BpmTask();
            containerId = bpmTask.getContainerId();
            BpmTransferLog transferLog = new BpmTransferLog();
            transferLog.setTaskId(taskId);
            transferLog.setProcessInstanceId(bpmTask.getProcessInstanceId());
            transferLog.setUserId(targetUserId);
            if (Commons.isEmpty((Object)handlerCode)) {
                if (Commons.isNotEmpty((Object)bpmTask.getHandlerCode())) {
                    handlerCode = bpmTask.getHandlerCode();
                } else {
                    Pageable pageParam = new Pageable(0, 10);
                    BpmTaskReqVo bpmTaskReqVo = new BpmTaskReqVo();
                    bpmTaskReqVo.setTaskId(taskId);
                    Page<BpmTask> tasksList = this.bpmQueryDao.findTastByInnerRefNos(bpmTaskReqVo, pageParam);
                    if (tasksList != null && tasksList.getSize() > 0 && tasksList.getContent() != null && tasksList.getContent().size() > 0) {
                        handlerCode = ((BpmTask)tasksList.getContent().get(0)).getHandlerCode();
                    }
                    for (BpmTask bpmTask1 : tasksList) {
                        bpmTask1.getHandlerCode();
                    }
                }
            }
            transferLog.setPreHandlerCode(handlerCode);
            transferLog.setCreateTime(new Date());
            transferLog.setCreatorCode(userId);
            this.bpmTransferLogDao.save(transferLog);
            HashMap<String, Object> urlParams = new HashMap<String, Object>();
            urlParams.put("containerId", containerId);
            urlParams.put("taskInstanceId", taskId);
            StringBuilder template = new StringBuilder();
            template.append("containers/{containerId}/tasks");
            template.append("/");
            template.append("{taskInstanceId}/states/delegated");
            template.append("?user=");
            template.append(userId);
            template.append("&targetUser=");
            template.append(targetUserId);
            JSONObject result = this.put(template.toString(), urlParams, null, new Map[0]);
            if (!"0000".equals(result.getString("resCode"))) {
                throw new BpmException(result.getString("resData"));
            }
        }
        catch (Exception e) {
            resCode = "1000";
            resMsg = "***BPM-LOG***\u59d4\u6d3e\u4efb\u52a1\u5931\u8d25\uff0c\u5f15\u64ce\u8fd4\u56de\u4fe1\u606f\u5982\u4e0b\uff1a" + e.getLocalizedMessage();
            LOGGER.error("***BPM-LOG***\u59d4\u6d3e\u4efb\u52a1\u5931\u8d25\uff0c\u5165\u53c2\uff1acontainerId=" + containerId + ",taskId=" + taskId + ",userId=" + userId + ",targetUserId=" + targetUserId + "\u5f15\u64ce\u8fd4\u56de\u4fe1\u606f\u5982\u4e0b\uff1a", (Throwable)e);
        }
        jo.put("resCode", (Object)resCode);
        jo.put("resMsg", resMsg);
        return jo.toJSONString();
    }

    @Override
    public String forwardTask(Long taskId, String userId, String targetUserId) {
        JSONObject jo = new JSONObject();
        String resCode = "0000";
        Object resMsg = "\u6210\u529f";
        String containerId = "";
        try {
            List<BpmTask> taskList = this.bpmQueryDao.findTaskById(taskId);
            BpmTask bpmTask = taskList != null && taskList.size() > 0 ? taskList.get(0) : new BpmTask();
            containerId = bpmTask.getContainerId();
            HashMap<String, Object> urlParams = new HashMap<String, Object>();
            urlParams.put("taskInstanceId", taskId);
            urlParams.put("containerId", containerId);
            StringBuilder template = new StringBuilder();
            template.append("containers/{containerId}/tasks");
            template.append("/");
            template.append("{taskInstanceId}/states/forwarded");
            template.append("?user=");
            template.append(userId);
            template.append("&targetUser=");
            template.append(targetUserId);
            JSONObject result = this.put(template.toString(), urlParams, null, new Map[0]);
            if (!"0000".equals(result.getString("resCode"))) {
                throw new BpmException(result.getString("resData"));
            }
        }
        catch (Exception e) {
            resCode = "1000";
            resMsg = "***BPM-LOG***\u8f6c\u4ea4\u4efb\u52a1\u5931\u8d25\uff0c\u5f15\u64ce\u8fd4\u56de\u4fe1\u606f\u5982\u4e0b\uff1a" + e.getLocalizedMessage();
            LOGGER.error("***BPM-LOG***\u8f6c\u4ea4\u4efb\u52a1\u5931\u8d25\uff0c\u5165\u53c2\uff1acontainerId=" + containerId + ",taskId=" + taskId + ",userId=" + userId + ",targetUserId=" + targetUserId + "\u5f15\u64ce\u8fd4\u56de\u4fe1\u606f\u5982\u4e0b\uff1a", (Throwable)e);
        }
        jo.put("resCode", (Object)resCode);
        jo.put("resMsg", resMsg);
        return jo.toJSONString();
    }

    @Override
    public String completeTask(Long taskId, String userId, Map<String, Object> params, BpmMainVo bpmMainVo) {
        JSONObject jo = new JSONObject();
        String resCode = "0000";
        Object resMsg = "\u6210\u529f";
        String containerId = "";
        BpmInterfaceLog log = new BpmInterfaceLog();
        BpmInterfaceLog bpmInterfaceLog = null;
        String bpmInvokeResult = "1";
        try {
            List<BpmTask> taskList;
            if (StringUtils.isNotBlank((CharSequence)bpmMainVo.getDesc())) {
                params.put("desc", bpmMainVo.getDesc());
            }
            if (StringUtils.isNotBlank((CharSequence)bpmMainVo.getTransFlag())) {
                params.put("transFlag", bpmMainVo.getTransFlag());
            }
            params.put("taskId", taskId);
            log.setTaskId(taskId);
            log.setInvokeMethod("completeTask");
            log.setFlag("0");
            List<BpmInterfaceLog> interfaceLogList = this.bpmLogService.findInterfaceLog(log);
            if (interfaceLogList != null && interfaceLogList.size() > 0) {
                bpmInterfaceLog = interfaceLogList.get(0);
            }
            BpmTask bpmTask = (taskList = this.bpmQueryDao.findTaskById(taskId)) != null && taskList.size() > 0 ? taskList.get(0) : new BpmTask();
            log.setProcessId(bpmTask.getProcessId());
            log.setContainerId(bpmTask.getContainerId());
            log.setProcessInstanceId(bpmTask.getProcessInstanceId());
            log.setCreatorCode(userId);
            log.setCreateTime(new Date());
            log.setUserCode(userId);
            if ("Completed".equals(bpmTask.getStatus())) {
                log.setParamJson(JSONObject.toJSONString(params));
                if (bpmInterfaceLog == null) {
                    log.setRemark("Repeat call.");
                }
                log.setFlag("1");
                jo.put("resCode", (Object)resCode);
                jo.put("resMsg", (Object)"***BPM-LOG***\u7ed3\u675f\u4efb\u52a1\u64cd\u4f5c\u5df2\u6210\u529f\uff0c\u4e0d\u518d\u8c03\u7528api\u3002");
                jo.put("completeLog", (Object)log);
                jo.put("oldLog", (Object)bpmInterfaceLog);
                jo.put("bpmInvokeResult", (Object)bpmInvokeResult);
                return jo.toJSONString();
            }
            bpmMainVo.setProcessInstanceId(bpmTask.getProcessInstanceId());
            this.invokeDispatchDrools(params, bpmMainVo);
            log.setParamJson(JSONObject.toJSONString(params));
            containerId = bpmTask.getContainerId();
            HashMap<String, Object> urlParams = new HashMap<String, Object>();
            urlParams.put("containerId", containerId);
            urlParams.put("taskInstanceId", taskId);
            StringBuilder template = new StringBuilder();
            template.append("containers/{containerId}/tasks");
            template.append("/");
            template.append("{taskInstanceId}/states/completed");
            template.append("?user=");
            template.append(userId);
            template.append("&auto-progress=");
            template.append(bpmMainVo.getAutoProgress());
            params.put("userId", userId);
            JSONObject result = this.put(template.toString(), urlParams, params, new Map[0]);
            if (!"0000".equals(result.getString("resCode"))) {
                throw new BpmException(result.getString("resData"));
            }
            log.setFlag("1");
        }
        catch (Exception e) {
            bpmInvokeResult = "0";
            log.setFlag("0");
            resCode = "1000";
            resMsg = "***BPM-LOG***\u7ed3\u675f\u4efb\u52a1\u5931\u8d25\uff0c\u5f15\u64ce\u8fd4\u56de\u4fe1\u606f\u5982\u4e0b\uff1a" + e.getLocalizedMessage();
            LOGGER.error("***BPM-LOG***\u7ed3\u675f\u4efb\u52a1\u5931\u8d25\uff0c\u5165\u53c2\uff1acontainerId=" + containerId + ",taskId=" + taskId + "\u5f15\u64ce\u8fd4\u56de\u4fe1\u606f\u5982\u4e0b\uff1a", (Throwable)e);
        }
        jo.put("resCode", (Object)resCode);
        jo.put("resMsg", resMsg);
        jo.put("completeLog", (Object)log);
        jo.put("oldLog", (Object)bpmInterfaceLog);
        jo.put("bpmInvokeResult", (Object)bpmInvokeResult);
        return jo.toJSONString();
    }

    @Override
    public String releaseTask(Long taskId, String userId) {
        JSONObject jo = new JSONObject();
        String resCode = "0000";
        Object resMsg = "\u6210\u529f";
        String containerId = "";
        try {
            List<BpmTask> taskList = this.bpmQueryDao.findTaskById(taskId);
            BpmTask bpmTask = taskList != null && taskList.size() > 0 ? taskList.get(0) : new BpmTask();
            containerId = bpmTask.getContainerId();
            HashMap<String, Object> urlParams = new HashMap<String, Object>();
            urlParams.put("containerId", containerId);
            urlParams.put("taskInstanceId", taskId);
            StringBuilder template = new StringBuilder();
            template.append("containers/{containerId}/tasks");
            template.append("/");
            template.append("{taskInstanceId}/states/released");
            template.append("?user=");
            template.append(userId);
            JSONObject result = this.put(template.toString(), urlParams, null, new Map[0]);
            if (!"0000".equals(result.getString("resCode"))) {
                throw new BpmException(result.getString("resData"));
            }
        }
        catch (Exception e) {
            resCode = "1000";
            resMsg = "***BPM-LOG***\u653e\u5f03\u4efb\u52a1\u5931\u8d25\uff0c\u5f15\u64ce\u8fd4\u56de\u4fe1\u606f\u5982\u4e0b\uff1a" + e.getLocalizedMessage();
            LOGGER.error("***BPM-LOG***\u653e\u5f03\u4efb\u52a1\u5931\u8d25\uff0c\u5165\u53c2\uff1acontainerId=" + containerId + ",taskId=" + taskId + ",userId=" + userId + "\u5f15\u64ce\u8fd4\u56de\u4fe1\u606f\u5982\u4e0b\uff1a", (Throwable)e);
        }
        jo.put("resCode", (Object)resCode);
        jo.put("resMsg", resMsg);
        return jo.toJSONString();
    }

    @Override
    public String addPotentialOwners(Long taskId, boolean removeExisting, OrgEntities orgEntities) {
        JSONObject jo = new JSONObject();
        String resCode = "0000";
        Object resMsg = "\u6210\u529f";
        String containerId = "";
        try {
            List<BpmTask> taskList = this.bpmQueryDao.findTaskById(taskId);
            BpmTask bpmTask = taskList != null && taskList.size() > 0 ? taskList.get(0) : new BpmTask();
            containerId = bpmTask.getContainerId();
            HashMap<String, Object> urlParams = new HashMap<String, Object>();
            urlParams.put("containerId", containerId);
            urlParams.put("taskInstanceId", taskId);
            StringBuilder template = new StringBuilder();
            template.append("admin/containers/{containerId}/tasks");
            template.append("/");
            template.append("{taskInstanceId}/pot-owners");
            template.append("?remove=");
            template.append(removeExisting);
            JSONObject result = this.put(template.toString(), urlParams, orgEntities, new Map[0]);
            if (!"0000".equals(result.getString("resCode"))) {
                throw new BpmException(result.getString("resData"));
            }
        }
        catch (Exception e) {
            resCode = "1000";
            resMsg = "***BPM-LOG***\u7ba1\u7406\u5458\u4fee\u6539\u4efb\u52a1\u7684\u6f5c\u5728\u62e5\u6709\u8005\u5931\u8d25\uff0c\u5f15\u64ce\u8fd4\u56de\u4fe1\u606f\u5982\u4e0b\uff1a" + e.getLocalizedMessage();
            LOGGER.error("***BPM-LOG***\u7ba1\u7406\u5458\u4fee\u6539\u4efb\u52a1\u7684\u6f5c\u5728\u62e5\u6709\u8005\u5931\u8d25\uff0c\u5165\u53c2\uff1acontainerId=" + containerId + ",taskId=" + taskId + ",removeExisting=" + removeExisting + "\u5f15\u64ce\u8fd4\u56de\u4fe1\u606f\u5982\u4e0b\uff1a", (Throwable)e);
        }
        jo.put("resCode", (Object)resCode);
        jo.put("resMsg", resMsg);
        return jo.toJSONString();
    }

    @Override
    public String suspendTask(Long taskId, String userId) {
        JSONObject jo = new JSONObject();
        String resCode = "0000";
        Object resMsg = "\u6210\u529f";
        String containerId = "";
        try {
            List<BpmTask> taskList = this.bpmQueryDao.findTaskById(taskId);
            BpmTask bpmTask = taskList != null && taskList.size() > 0 ? taskList.get(0) : new BpmTask();
            containerId = bpmTask.getContainerId();
            HashMap<String, Object> urlParams = new HashMap<String, Object>();
            urlParams.put("taskInstanceId", taskId);
            urlParams.put("containerId", containerId);
            StringBuilder template = new StringBuilder();
            template.append("containers/{containerId}/tasks");
            template.append("/");
            template.append("{taskInstanceId}/states/suspended");
            template.append("?user=");
            template.append(userId);
            JSONObject result = this.put(template.toString(), urlParams, null, new Map[0]);
            if (!"0000".equals(result.getString("resCode"))) {
                throw new BpmException(result.getString("resData"));
            }
        }
        catch (Exception e) {
            resCode = "1000";
            resMsg = "***BPM-LOG***\u6302\u8d77\u4efb\u52a1\u5931\u8d25\uff0c\u5f15\u64ce\u8fd4\u56de\u4fe1\u606f\u5982\u4e0b\uff1a" + e.getLocalizedMessage();
            LOGGER.error("***BPM-LOG***\u6302\u8d77\u4efb\u52a1\u5931\u8d25\uff0c\u5165\u53c2\uff1acontainerId=" + containerId + ",taskId=" + taskId + ",userId=" + userId + "\u5f15\u64ce\u8fd4\u56de\u4fe1\u606f\u5982\u4e0b\uff1a", (Throwable)e);
        }
        jo.put("resCode", (Object)resCode);
        jo.put("resMsg", resMsg);
        return jo.toJSONString();
    }

    @Override
    public String resumeTask(Long taskId, String userId) {
        JSONObject jo = new JSONObject();
        String resCode = "0000";
        Object resMsg = "\u6210\u529f";
        String containerId = "";
        try {
            List<BpmTask> taskList = this.bpmQueryDao.findTaskById(taskId);
            BpmTask bpmTask = taskList != null && taskList.size() > 0 ? taskList.get(0) : new BpmTask();
            containerId = bpmTask.getContainerId();
            HashMap<String, Object> urlParams = new HashMap<String, Object>();
            urlParams.put("containerId", containerId);
            urlParams.put("taskInstanceId", taskId);
            StringBuilder template = new StringBuilder();
            template.append("containers/{containerId}/tasks");
            template.append("/");
            template.append("{taskInstanceId}/states/resumed");
            template.append("?user=");
            template.append(userId);
            JSONObject result = this.put(template.toString(), urlParams, userId, new Map[0]);
            if (!"0000".equals(result.getString("resCode"))) {
                throw new BpmException(result.getString("resData"));
            }
        }
        catch (Exception e) {
            resCode = "1000";
            resMsg = "***BPM-LOG***\u6062\u590d\u4efb\u52a1\u5931\u8d25\uff0c\u5f15\u64ce\u8fd4\u56de\u4fe1\u606f\u5982\u4e0b\uff1a" + e.getLocalizedMessage();
            LOGGER.error("***BPM-LOG***\u6062\u590d\u4efb\u52a1\u5931\u8d25\uff0c\u5165\u53c2\uff1acontainerId=" + containerId + ",taskId=" + taskId + ",userId=" + userId + "\u5f15\u64ce\u8fd4\u56de\u4fe1\u606f\u5982\u4e0b\uff1a", (Throwable)e);
        }
        jo.put("resCode", (Object)resCode);
        jo.put("resMsg", resMsg);
        return jo.toJSONString();
    }

    @Override
    public String nominateTask(Long taskId, String userId, List<String> potentialOwners) {
        JSONObject jo = new JSONObject();
        String resCode = "0000";
        Object resMsg = "\u6210\u529f";
        String containerId = "";
        try {
            List<BpmTask> taskList = this.bpmQueryDao.findTaskById(taskId);
            BpmTask bpmTask = taskList != null && taskList.size() > 0 ? taskList.get(0) : new BpmTask();
            containerId = bpmTask.getContainerId();
            HashMap<String, Object> urlParams = new HashMap<String, Object>();
            urlParams.put("containerId", containerId);
            urlParams.put("taskInstanceId", taskId);
            StringBuilder template = new StringBuilder();
            template.append("containers/{containerId}/tasks");
            template.append("/");
            template.append("{taskInstanceId}/states/nominated");
            template.append("?user=");
            template.append(userId);
            JSONObject result = this.put(template.toString(), urlParams, potentialOwners, new Map[0]);
            if (!"0000".equals(result.getString("resCode"))) {
                throw new BpmException(result.getString("resData"));
            }
        }
        catch (Exception e) {
            resCode = "1000";
            resMsg = "***BPM-LOG***\u91cd\u65b0\u5206\u914d\u4efb\u52a1\u6f5c\u5728\u62e5\u6709\u8005\u5931\u8d25\uff0c\u5f15\u64ce\u8fd4\u56de\u4fe1\u606f\u5982\u4e0b\uff1a" + e.getLocalizedMessage();
            LOGGER.error("***BPM-LOG***\u91cd\u65b0\u5206\u914d\u4efb\u52a1\u6f5c\u5728\u62e5\u6709\u8005\u5931\u8d25\uff0c\u5165\u53c2\uff1acontainerId=" + containerId + ",taskId=" + taskId + ",userId=" + userId + "\u5f15\u64ce\u8fd4\u56de\u4fe1\u606f\u5982\u4e0b\uff1a", (Throwable)e);
        }
        jo.put("resCode", (Object)resCode);
        jo.put("resMsg", resMsg);
        return jo.toJSONString();
    }

    @Override
    public Map<String, Object> dispatch(BpmMainVo bpmMainVo) {
        HashMap<String, Object> params = new HashMap<String, Object>(10);
        this.bpmTransferValidation(bpmMainVo);
        this.invokeDispatchDrools(params, bpmMainVo);
        return params;
    }

    @Override
    public String setTaskPriority(Long taskId, Integer priority) {
        JSONObject jo = new JSONObject();
        String resCode = "0000";
        Object resMsg = "\u6210\u529f";
        String containerId = "";
        try {
            List<BpmTask> taskList = this.bpmQueryDao.findTaskById(taskId);
            BpmTask bpmTask = taskList != null && taskList.size() > 0 ? taskList.get(0) : new BpmTask();
            containerId = bpmTask.getContainerId();
            HashMap<String, Object> urlParams = new HashMap<String, Object>();
            urlParams.put("containerId", containerId);
            urlParams.put("taskInstanceId", taskId);
            StringBuilder template = new StringBuilder();
            template.append("containers/{containerId}/tasks");
            template.append("/");
            template.append("{taskInstanceId}/priority");
            JSONObject result = this.put(template.toString(), urlParams, priority, new Map[0]);
            if (!"0000".equals(result.getString("resCode"))) {
                throw new BpmException(result.getString("resData"));
            }
        }
        catch (Exception e) {
            resCode = "1000";
            resMsg = "***BPM-LOG***\u4fee\u6539\u4efb\u52a1\u4f18\u5148\u7ea7\u5931\u8d25\uff0c\u5f15\u64ce\u8fd4\u56de\u4fe1\u606f\u5982\u4e0b\uff1a" + e.getLocalizedMessage();
            LOGGER.error("***BPM-LOG***\u4fee\u6539\u4efb\u52a1\u4f18\u5148\u7ea7\u5931\u8d25\uff0c\u5165\u53c2\uff1ataskId=" + taskId + ",priority=" + priority + "\uff0c\u5f15\u64ce\u8fd4\u56de\u4fe1\u606f\u5982\u4e0b\uff1a", (Throwable)e);
        }
        jo.put("resCode", (Object)resCode);
        jo.put("resMsg", resMsg);
        return jo.toJSONString();
    }

    @Override
    public String updateTaskDescription(Long taskId, String description) {
        JSONObject jo = new JSONObject();
        String resCode = "0000";
        Object resMsg = "\u6210\u529f";
        try {
            List<BpmTask> taskList = this.bpmQueryDao.findTaskById(taskId);
            BpmTask bpmTask = taskList != null && taskList.size() > 0 ? taskList.get(0) : new BpmTask();
            String containerId = bpmTask.getContainerId();
            HashMap<String, Object> urlParams = new HashMap<String, Object>();
            urlParams.put("containerId", containerId);
            urlParams.put("taskInstanceId", taskId);
            StringBuilder template = new StringBuilder();
            template.append("containers/{containerId}/tasks");
            template.append("/");
            template.append("{taskInstanceId}/description");
            JSONObject result = this.put(template.toString(), urlParams, description, new Map[0]);
            if (!"0000".equals(result.getString("resCode"))) {
                throw new BpmException(result.getString("resData"));
            }
        }
        catch (Exception e) {
            resCode = "1000";
            resMsg = "***BPM-LOG***\u4fee\u6539\u4efb\u52a1\u63cf\u8ff0\u5931\u8d25\uff0c\u5f15\u64ce\u8fd4\u56de\u4fe1\u606f\u5982\u4e0b\uff1a" + e.getLocalizedMessage();
            LOGGER.error("***BPM-LOG***\u4fee\u6539\u4efb\u52a1\u63cf\u8ff0\u5931\u8d25\uff0c\u5165\u53c2\uff1ataskId=" + taskId + ",description=" + description + "\uff0c\u5f15\u64ce\u8fd4\u56de\u4fe1\u606f\u5982\u4e0b\uff1a", (Throwable)e);
        }
        jo.put("resCode", (Object)resCode);
        jo.put("resMsg", resMsg);
        return jo.toJSONString();
    }

    @Override
    public void bpmTransferValidation(BpmMainVo bpmMainVo) {
        List<Map<String, BpmNodeVariableVo>> multiInstanceList;
        String processId = bpmMainVo.getProcessId();
        String nodeCode = bpmMainVo.getNodeCode();
        Object nextNodeCodes = "";
        String transFlag = bpmMainVo.getTransFlag();
        Map<String, BpmNodeVariableVo> multiBranchMap = null;
        Object dispatchSignal = bpmMainVo.getDispatchSignal();
        if (dispatchSignal != null) {
            if (dispatchSignal instanceof BpmNodeVariableVo) {
                BpmNodeVariableVo vo = (BpmNodeVariableVo)dispatchSignal;
                bpmMainVo.getMultiBranchMap().put(vo.getNodeCode(), vo);
            } else if (dispatchSignal instanceof Map) {
                Map map = (Map)dispatchSignal;
                bpmMainVo.setMultiBranchMap(map);
            } else if (dispatchSignal instanceof List) {
                List instanceList = (List)dispatchSignal;
                bpmMainVo.setMultiInstanceList(instanceList);
            }
        }
        if ((multiInstanceList = bpmMainVo.getMultiInstanceList()) != null && multiInstanceList.size() > 0) {
            multiBranchMap = multiInstanceList.get(0);
            bpmMainVo.setMultiBranchMap(multiBranchMap);
        } else {
            multiBranchMap = bpmMainVo.getMultiBranchMap();
        }
        BpmTransferFactory transFactory = new BpmTransferFactory();
        transFactory.setProcessId(processId);
        transFactory.setFactorCode("transFlag");
        if (StringUtils.isNotBlank((CharSequence)transFlag)) {
            transFactory.setFactorValue(transFlag);
        } else {
            transFactory.setFactorValue("00");
        }
        transFactory.setNodeCode(nodeCode);
        List transferFactories = this.bpmTransferFactoryDao.findList(transFactory);
        if (transferFactories != null && transferFactories.size() > 0) {
            for (int i = 0; i < transferFactories.size(); ++i) {
                transFactory = (BpmTransferFactory)transferFactories.get(i);
                String nextProcessId = transFactory.getNextProcessId();
                String nextNodeCode = transFactory.getNextNodeCode();
                BpmNodeVariableVo nodeVariableVo = multiBranchMap.get(nextNodeCode);
                if (nodeVariableVo == null) {
                    nodeVariableVo = new BpmNodeVariableVo();
                    nodeVariableVo.setActors(bpmMainVo.getActors());
                    nodeVariableVo.setGroups(bpmMainVo.getGroups());
                    nodeVariableVo.setCheckInd(bpmMainVo.getCheckInd());
                    nodeVariableVo.setExclActors(bpmMainVo.getExclActors());
                    multiBranchMap.put(nextNodeCode, nodeVariableVo);
                } else {
                    List<BpmNodeVariableVo> nodeMultiInstanceList = nodeVariableVo.getMultiInstanceList();
                    if (nodeMultiInstanceList != null) {
                        for (int j = 0; j < nodeMultiInstanceList.size(); ++j) {
                            BpmNodeVariableVo vo = nodeMultiInstanceList.get(j);
                            vo.setProcessId(nextProcessId);
                            vo.setNodeCode(nextNodeCode);
                        }
                    }
                }
                nodeVariableVo.setProcessId(nextProcessId);
                nodeVariableVo.setNodeCode(nextNodeCode);
                nodeVariableVo.setDispatchRuleCode(transFactory.getDispatchRuleCode());
                if (multiInstanceList != null) {
                    for (int j = 0; j < multiInstanceList.size(); ++j) {
                        BpmNodeVariableVo vo = multiInstanceList.get(j).get(nextNodeCode);
                        if (vo == null) {
                            multiInstanceList.get(j).put(nextNodeCode, nodeVariableVo);
                            continue;
                        }
                        vo.setProcessId(nextProcessId);
                        vo.setNodeCode(nextNodeCode);
                    }
                }
                nextNodeCodes = (String)nextNodeCodes + nextNodeCode;
                if (i == transferFactories.size() - 1) continue;
                nextNodeCodes = (String)nextNodeCodes + ",";
            }
        } else {
            throw new BpmException(MessageFormat.format("***BPM-LOG***bpmTransferFactory\u914d\u7f6e\u5f02\u5e38\uff0cprocessId={0}, nodeCode={1}, transFlag={2}", processId, nodeCode, transFlag));
        }
        bpmMainVo.setNextNodeCode((String)nextNodeCodes);
    }

    @Override
    public String setTaskExpirationDate(Long taskId, Date expirationDate) {
        JSONObject jo = new JSONObject();
        String resCode = "0000";
        Object resMsg = "\u6210\u529f";
        String containerId = "";
        try {
            List<BpmTask> taskList = this.bpmQueryDao.findTaskById(taskId);
            BpmTask bpmTask = taskList != null && taskList.size() > 0 ? taskList.get(0) : new BpmTask();
            containerId = bpmTask.getContainerId();
            HashMap<String, Object> urlParams = new HashMap<String, Object>();
            urlParams.put("containerId", containerId);
            urlParams.put("taskInstanceId", taskId);
            StringBuilder template = new StringBuilder();
            template.append("containers/{containerId}/tasks");
            template.append("/");
            template.append("{taskInstanceId}/expiration");
            JSONObject result = this.put(template.toString(), urlParams, expirationDate, new Map[0]);
            if (!"0000".equals(result.getString("resCode"))) {
                throw new BpmException(result.getString("resData"));
            }
        }
        catch (Exception e) {
            resCode = "1000";
            resMsg = "***BPM-LOG***\u4fee\u6539\u4efb\u52a1\u8fc7\u671f\u65f6\u95f4\u5931\u8d25\uff0c\u5f15\u64ce\u8fd4\u56de\u4fe1\u606f\u5982\u4e0b\uff1a" + e.getLocalizedMessage();
            LOGGER.error("***BPM-LOG***\u4fee\u6539\u4efb\u52a1\u8fc7\u671f\u65f6\u95f4\u5931\u8d25\uff0c\u5165\u53c2\uff1ataskId=" + taskId + ",expirationDate=" + expirationDate + "\uff0c\u5f15\u64ce\u8fd4\u56de\u4fe1\u606f\u5982\u4e0b\uff1a", (Throwable)e);
        }
        jo.put("resCode", (Object)resCode);
        jo.put("resMsg", resMsg);
        return jo.toJSONString();
    }
}

