/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.sg.tpsgi.annotation;

import com.cntaiping.sg.tpsgi.annotation.ValidNull;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ValidNullAnnotation {
    private static final Logger LOG = LoggerFactory.getLogger(ValidNullAnnotation.class);

    public static String validate(Object obj) {
        return ValidNullAnnotation.validate(obj, ";");
    }

    public static String validate(Object obj, String delimiter) {
        return ValidNullAnnotation.validate(obj, StringUtils.isEmpty((CharSequence)delimiter) ? ";" : delimiter, null);
    }

    public static String validate(Object obj, String delimiter, List<String> ignoreFields) {
        if (StringUtils.isEmpty((CharSequence)delimiter)) {
            delimiter = ";";
        }
        if (ignoreFields == null) {
            ignoreFields = new ArrayList<String>();
        }
        ArrayList<String> msgList = new ArrayList<String>();
        HashSet<String> ignoreFieldSet = new HashSet<String>(ignoreFields);
        ValidNullAnnotation.validateObject(obj, "", "", delimiter, ignoreFieldSet, msgList);
        return CollectionUtils.isEmpty(msgList) ? null : String.join((CharSequence)delimiter, msgList);
    }

    private static void validateObject(Object obj, String prefix, String namePrefix, String delimiter, Set<String> ignoreFieldSet, List<String> msgList) {
        Field[] fields;
        if (obj == null) {
            return;
        }
        Class<?> clazz = obj.getClass();
        for (Field field : fields = clazz.getDeclaredFields()) {
            String fieldPath;
            field.setAccessible(true);
            String string = fieldPath = prefix.isEmpty() ? field.getName() : prefix + "." + field.getName();
            if (ValidNullAnnotation.isIgnoredField(fieldPath, ignoreFieldSet) || !field.isAnnotationPresent(ValidNull.class)) continue;
            ValidNullAnnotation.processField(obj, field, fieldPath, namePrefix, delimiter, ignoreFieldSet, msgList);
        }
    }

    private static boolean isIgnoredField(String fieldPath, Set<String> ignoreFieldSet) {
        for (String ignoreField : ignoreFieldSet) {
            if (!fieldPath.equals(ignoreField) && !fieldPath.startsWith(ignoreField + ".")) continue;
            return true;
        }
        return false;
    }

    private static void processField(Object obj, Field field, String fieldPath, String namePrefix, String delimiter, Set<String> ignoreFieldSet, List<String> msgList) {
        try {
            Object fieldValue = field.get(obj);
            ValidNull annotation = field.getAnnotation(ValidNull.class);
            if (annotation.enabled()) {
                Object name;
                Object object = name = annotation.name().isEmpty() ? field.getName() : annotation.name();
                if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{namePrefix})) {
                    name = namePrefix + "\u7684" + (String)name;
                }
                String message = annotation.errorMsg();
                if (ObjectUtils.isEmpty((Object)fieldValue)) {
                    msgList.add(ValidNullAnnotation.formatMessage((String)name, message));
                    return;
                }
                if (annotation.allowedValues().length > 0) {
                    ValidNullAnnotation.validateAllowedValues(fieldValue, annotation.allowedValues(), (String)name, msgList);
                    return;
                }
                if (fieldValue instanceof Collection) {
                    Collection collection = (Collection)fieldValue;
                    if (annotation.childScan()) {
                        int index = 0;
                        for (Object item : collection) {
                            String itemPrefix = fieldPath + "[" + index + "]";
                            String nPrefix = namePrefix + "[" + index + "]";
                            ValidNullAnnotation.validateObject(item, itemPrefix, nPrefix, delimiter, ignoreFieldSet, msgList);
                            ++index;
                        }
                    }
                    return;
                }
                if (fieldValue.getClass().isArray()) {
                    Object[] array = (Object[])fieldValue;
                    if (annotation.childScan()) {
                        for (int index = 0; index < array.length; ++index) {
                            String itemPrefix = fieldPath + "[" + index + "]";
                            String nPrefix = namePrefix + "[" + index + "]";
                            ValidNullAnnotation.validateObject(array[index], itemPrefix, nPrefix, delimiter, ignoreFieldSet, msgList);
                        }
                    }
                    return;
                }
                if (annotation.childScan() && !ValidNullAnnotation.isSimpleType(field.getType())) {
                    ValidNullAnnotation.validateObject(fieldValue, fieldPath, (String)name, delimiter, ignoreFieldSet, msgList);
                    return;
                }
                ValidNullAnnotation.validateWithRegex(fieldValue, annotation.regex(), annotation.matchesErrMsg(), (String)name, msgList);
            }
        }
        catch (IllegalAccessException e) {
            LOG.error("\u5b57\u6bb5\u8bbf\u95ee\u5f02\u5e38", (Throwable)e);
        }
    }

    private static boolean isSimpleType(Class<?> type) {
        return type.isPrimitive() || type.equals(String.class);
    }

    private static void validateAllowedValues(Object fieldValue, String[] allowedValues, String fieldName, List<String> msgList) {
        if (fieldValue == null) {
            return;
        }
        String fieldValueStr = fieldValue.toString();
        if (!Arrays.asList(allowedValues).contains(fieldValueStr)) {
            msgList.add(ValidNullAnnotation.formatMessage(fieldName, "\u503c\u4e0d\u5728\u5141\u8bb8\u7684\u8303\u56f4\u5185"));
        }
    }

    private static void validateWithRegex(Object fieldValue, String regex, String errorMessage, String fieldName, List<String> msgList) {
        Pattern pattern;
        Matcher matcher;
        if (!regex.isEmpty() && !(matcher = (pattern = Pattern.compile(regex)).matcher(String.valueOf(fieldValue))).matches()) {
            msgList.add(ValidNullAnnotation.formatMessage(fieldName, errorMessage));
        }
    }

    private static String formatMessage(String name, String message) {
        return String.format("%s: %s", name, message);
    }
}

