/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.sg.tpsgi.client.sumcomm.converter;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeConverter
implements Converter<Date> {
    private static final Logger LOG = LoggerFactory.getLogger(DateTimeConverter.class);
    private static final SimpleDateFormat DATE_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final Function<Date, String> DATE_TIME_STRING = DATE_TIME_FORMAT::format;

    public Class<?> supportJavaTypeKey() {
        return Date.class;
    }

    public WriteCellData<?> convertToExcelData(Date value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        if (value == null) {
            return new WriteCellData("");
        }
        return new WriteCellData(DATE_TIME_STRING.apply(value));
    }

    public Date convertToJavaData(ReadCellData<?> cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        if (cellData == null || cellData.getStringValue() == null) {
            return null;
        }
        String dateStr = cellData.getStringValue();
        try {
            return DATE_TIME_FORMAT.parse(dateStr);
        }
        catch (ParseException e) {
            LOG.error("\u6642\u9593\u8f49\u63db\u5931\u6557", (Throwable)e);
            return null;
        }
    }
}

