/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.hw.support;

import java.lang.ref.Cleaner;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class Cleanable<T> {
    private static final Cleaner CLEANER = Cleaner.create();
    private final T value;

    private Cleanable(T value, Consumer<T> cleanUp) {
        this.value = value;
        CLEANER.register(this, new Stage<T>(value, cleanUp));
    }

    public T getValue() {
        return this.value;
    }

    public static <T> Cleanable<T> withCleanUp(Supplier<T> supplier, Consumer<T> cleanUp) {
        T value = supplier.get();
        return new Cleanable<T>(value, cleanUp);
    }

    private record Stage<T>(T value, Consumer<T> cleanUp) implements Runnable
    {
        @Override
        public void run() {
            this.cleanUp.accept(this.value);
        }
    }
}

