/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.hw.support.concurrent;

import java.util.function.Supplier;

public class ClosableThreadLocal<T> {
    private final ThreadLocal<T> threadLocal;

    public ClosableThreadLocal(Supplier<? extends T> supplier) {
        this.threadLocal = ThreadLocal.withInitial(supplier);
    }

    public ClosableThreadLocal() {
        this.threadLocal = new ThreadLocal();
    }

    public T getValue() {
        return this.threadLocal.get();
    }

    public void setValue(T value) {
        this.threadLocal.set(value);
    }

    public void run(Runnable runnable) {
        try (ToClose start = this.start();){
            runnable.run();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ToClose startWith(T value) {
        this.setValue(value);
        return new ToClose();
    }

    public ToClose start() {
        return new ToClose();
    }

    public class ToClose
    implements AutoCloseable {
        @Override
        public void close() throws Exception {
            ClosableThreadLocal.this.threadLocal.remove();
        }
    }
}

