/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.hw.support.data;

import com.cntaiping.hw.support.Cleanable;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.mapdb.Atomic;
import org.mapdb.BTreeMap;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;
import org.mapdb.IndexTreeList;
import org.mapdb.Serializer;

public class LargeData {
    public static <K, V> Cleanable<? extends Map<K, V>> newHTreeMap() {
        DB db = LargeData.createDB();
        HTreeMap map = db.hashMap("hashMap", (Serializer)Serializer.ELSA, (Serializer)Serializer.ELSA).createOrOpen();
        return Cleanable.withCleanUp(() -> map, HTreeMap::close);
    }

    public static <K, V> Cleanable<? extends Map<K, V>> newBTreeMap() {
        DB db = LargeData.createDB();
        BTreeMap map = db.treeMap("treeMap", Serializer.ELSA, Serializer.ELSA).createOrOpen();
        return Cleanable.withCleanUp(() -> map, BTreeMap::close);
    }

    public static <V> Cleanable<? extends Set<V>> newHashSet() {
        DB db = LargeData.createDB();
        HTreeMap.KeySet set = (HTreeMap.KeySet)db.hashSet("hashSet", (Serializer)Serializer.ELSA).createOrOpen();
        return Cleanable.withCleanUp(() -> set, vs -> vs.getMap().close());
    }

    public static <V> Cleanable<? extends Set<V>> newTreeSet() {
        DB db = LargeData.createDB();
        NavigableSet set = (NavigableSet)db.treeSet("hashSet", Serializer.ELSA).createOrOpen();
        return Cleanable.withCleanUp(() -> set, vs -> db.close());
    }

    public static <V> Cleanable<? extends List<V>> indexTreeList() {
        DB db = LargeData.createDB();
        IndexTreeList list = (IndexTreeList)db.indexTreeList("indexTreeList", (Serializer)Serializer.ELSA).createOrOpen();
        return Cleanable.withCleanUp(() -> list, vs -> db.close());
    }

    public static <V> Cleanable<Atomic.Var<V>> newObject() {
        DB db = LargeData.createDB();
        Atomic.Var atomicVar = (Atomic.Var)db.atomicVar("atomicVar", (Serializer)Serializer.ELSA).createOrOpen();
        return Cleanable.withCleanUp(() -> atomicVar, vs -> db.close());
    }

    public static <V> Cleanable<V> buildWithDb(Function<DB, V> function) {
        DB db = LargeData.createDB();
        Object v = function.apply(db);
        return Cleanable.withCleanUp(() -> v, v1 -> db.close());
    }

    @NotNull
    private static DB createDB() {
        return DBMaker.tempFileDB().allocateStartSize(0x800000L).allocateIncrement(0x400000L).fileChannelEnable().make();
    }
}

