/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.hw.support.http;

import com.cntaiping.hw.support.http.RequestProxy;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.DefaultAddressResolverGroup;
import java.net.Proxy;
import java.time.Duration;
import java.util.Objects;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ReactorNettyClientRequestFactory;
import reactor.netty.http.client.HttpClient;
import reactor.netty.tcp.DefaultSslContextSpec;
import reactor.netty.tcp.SslProvider;
import reactor.netty.transport.ProxyProvider;

public class HttpRequestFactoryBuilder {
    private boolean skipSslCheck = false;
    private RequestProxy requestProxy;
    private Duration exchangeTimeout = Duration.ofSeconds(60L);

    public static HttpRequestFactoryBuilder newBuilder() {
        return new HttpRequestFactoryBuilder();
    }

    public ClientHttpRequestFactory build() {
        HttpClient httpClient = (HttpClient)HttpClient.create().resolver((AddressResolverGroup)DefaultAddressResolverGroup.INSTANCE);
        if (this.requestProxy != null && !Objects.equals((Object)Proxy.Type.DIRECT, (Object)this.requestProxy.getType())) {
            httpClient = (HttpClient)httpClient.proxy(typeSpec -> {
                if (Objects.equals((Object)Proxy.Type.SOCKS, (Object)this.requestProxy.getType())) {
                    typeSpec.type(ProxyProvider.Proxy.SOCKS5).host(this.requestProxy.getHost()).port(this.requestProxy.getPort().intValue());
                } else if (Objects.equals((Object)Proxy.Type.HTTP, (Object)this.requestProxy.getType())) {
                    typeSpec.type(ProxyProvider.Proxy.HTTP).host(this.requestProxy.getHost()).port(this.requestProxy.getPort().intValue());
                }
            });
        }
        if (this.skipSslCheck) {
            httpClient = httpClient.secure(sslContextSpec -> sslContextSpec.sslContext((SslProvider.ProtocolSslContextSpec)DefaultSslContextSpec.forClient().configure(sslContextBuilder -> sslContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE))));
        }
        ReactorNettyClientRequestFactory requestFactory = new ReactorNettyClientRequestFactory(httpClient);
        requestFactory.setExchangeTimeout(this.exchangeTimeout);
        return requestFactory;
    }

    public boolean isSkipSslCheck() {
        return this.skipSslCheck;
    }

    public HttpRequestFactoryBuilder setSkipSslCheck(boolean skipSslCheck) {
        this.skipSslCheck = skipSslCheck;
        return this;
    }

    public RequestProxy getRequestProxy() {
        return this.requestProxy;
    }

    public HttpRequestFactoryBuilder setRequestProxy(RequestProxy requestProxy) {
        this.requestProxy = requestProxy;
        return this;
    }

    public Duration getExchangeTimeout() {
        return this.exchangeTimeout;
    }

    public HttpRequestFactoryBuilder setExchangeTimeout(Duration exchangeTimeout) {
        this.exchangeTimeout = exchangeTimeout;
        return this;
    }
}

