/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.hw.support.http.observe;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;

public class HttpEncodingDetector {
    public static Optional<Charset> detectCharset(HttpHeaders headers) {
        MediaType mediaType = headers.getContentType();
        if (mediaType == null) {
            return Optional.empty();
        }
        if (mediaType.getCharset() != null) {
            return Optional.ofNullable(mediaType.getCharset());
        }
        if (mediaType.isCompatibleWith(MediaType.APPLICATION_JSON)) {
            return Optional.of(StandardCharsets.UTF_8);
        }
        return Optional.empty();
    }
}

