/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.hw.support.http.observe;

import com.cntaiping.fsc.common.util.Commons;
import com.cntaiping.hw.support.http.observe.HttpEncodingDetector;
import com.cntaiping.hw.support.http.observe.LogConsumer;
import com.cntaiping.sg.tpsgi.system.servicelog.po.ClientServiceLog;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.io.IOUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.Assert;

public class LogHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    private final Charset defaultCharset;
    private final LogConsumer logConsumer;
    private final String platformCode;

    public LogHttpRequestInterceptor(LogConsumer logConsumer, String platformCode) {
        this(logConsumer, platformCode, StandardCharsets.UTF_8);
    }

    public LogHttpRequestInterceptor(LogConsumer logConsumer, String platformCode, Charset defaultCharset) {
        this.defaultCharset = defaultCharset;
        this.logConsumer = logConsumer;
        this.platformCode = platformCode;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        byte[] responseBody;
        ClientHttpResponse response;
        Charset requestcharset = HttpEncodingDetector.detectCharset(request.getHeaders()).orElse(this.defaultCharset);
        String requestBody = new String(body, requestcharset);
        List list = request.getHeaders().get((Object)"updateFlag");
        ClientServiceLog clientServiceLog = new ClientServiceLog();
        clientServiceLog.setRequestData(requestBody);
        clientServiceLog.setRequestTime(new Date());
        clientServiceLog.setRequestUrl(request.getURI().toString());
        clientServiceLog.setPlatformCode(this.platformCode);
        try {
            response = execution.execute(request, body);
            if (HttpStatus.OK.equals((Object)response.getStatusCode())) {
                clientServiceLog.setStatus("1");
            } else {
                clientServiceLog.setStatus("0");
            }
            Charset responseCharset = HttpEncodingDetector.detectCharset(response.getHeaders()).orElse(this.defaultCharset);
            responseBody = IOUtils.toByteArray((InputStream)response.getBody());
            String responseStr = new String(responseBody, responseCharset);
            clientServiceLog.setResponseData(responseStr);
        }
        catch (Exception e) {
            clientServiceLog.setStatus("0");
            StringWriter out = new StringWriter();
            e.printStackTrace(new PrintWriter(out));
            clientServiceLog.setErrorData(e.getLocalizedMessage());
            clientServiceLog.setErrorDetail(out.toString());
            throw e;
        }
        finally {
            clientServiceLog.setFailedTimes(Integer.valueOf(0));
            clientServiceLog.setResponseTime(new Date());
            long start = clientServiceLog.getRequestTime().getTime();
            long end = clientServiceLog.getResponseTime().getTime();
            clientServiceLog.setCostTime(Long.valueOf(end - start));
            if (Commons.isEmpty((Object)list)) {
                CompletableFuture.runAsync(() -> this.logConsumer.doLog(clientServiceLog));
            }
        }
        return new CacheResponseInputStream(response, responseBody);
    }

    private static class CacheResponseInputStream
    implements ClientHttpResponse {
        private final ClientHttpResponse delegate;
        private final byte[] body;

        public CacheResponseInputStream(ClientHttpResponse delegate, byte[] body) {
            Assert.notNull((Object)delegate, (String)"ClientHttpResponse delegate is required");
            this.delegate = delegate;
            this.body = body;
        }

        public ClientHttpResponse getDelegate() {
            return this.delegate;
        }

        public HttpStatusCode getStatusCode() throws IOException {
            return this.delegate.getStatusCode();
        }

        public int getRawStatusCode() throws IOException {
            return this.delegate.getRawStatusCode();
        }

        public String getStatusText() throws IOException {
            return this.delegate.getStatusText();
        }

        public HttpHeaders getHeaders() {
            return this.delegate.getHeaders();
        }

        public InputStream getBody() throws IOException {
            return new ByteArrayInputStream(this.body);
        }

        public void close() {
            this.delegate.close();
        }
    }
}

