/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.hw.support.jeepay;

import com.cntaiping.hw.support.jeepay.Jeepay;
import com.cntaiping.hw.support.jeepay.exception.JeepayException;
import com.cntaiping.hw.support.jeepay.net.APIResource;
import com.cntaiping.hw.support.jeepay.net.RequestOptions;
import com.cntaiping.hw.support.jeepay.request.JeepayRequest;
import com.cntaiping.hw.support.jeepay.response.JeepayResponse;
import org.springframework.web.client.RestTemplate;

public class JeepayClient
extends APIResource {
    private String signType = "MD5";
    private String apiKey = Jeepay.apiKey;
    private String apiBase = Jeepay.getApiBase();

    public String getSignType() {
        return this.signType;
    }

    public void setSignType(String signType) {
        this.signType = signType;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public JeepayClient(RestTemplate restTemplate, String apiBase, String signType, String apiKey) {
        super(restTemplate);
        this.apiBase = apiBase;
        this.signType = signType;
        this.apiKey = apiKey;
    }

    public JeepayClient(RestTemplate restTemplate, String apiBase, String apiKey) {
        super(restTemplate);
        this.apiBase = apiBase;
        this.apiKey = apiKey;
    }

    public JeepayClient(RestTemplate restTemplate, String apiKey) {
        super(restTemplate);
        this.apiKey = apiKey;
    }

    public JeepayClient(RestTemplate restTemplate) {
        super(restTemplate);
    }

    public String getApiBase() {
        return this.apiBase;
    }

    public void setApiBase(String apiBase) {
        this.apiBase = apiBase;
    }

    public <T extends JeepayResponse> T execute(JeepayRequest<T> request) throws JeepayException {
        if (request.getRequestOptions() == null) {
            RequestOptions options = RequestOptions.builder().setVersion(request.getApiVersion()).setUri(request.getApiUri()).setApiKey(this.apiKey).build();
            request.setRequestOptions(options);
        }
        return this.execute(request, APIResource.RequestMethod.POST, this.apiBase);
    }
}

