/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.hw.support.jeepay.net;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.cntaiping.hw.support.jeepay.exception.APIConnectionException;
import com.cntaiping.hw.support.jeepay.exception.APIException;
import com.cntaiping.hw.support.jeepay.exception.InvalidRequestException;
import com.cntaiping.hw.support.jeepay.exception.JeepayException;
import com.cntaiping.hw.support.jeepay.net.APIJeepayRequest;
import com.cntaiping.hw.support.jeepay.net.APIJeepayResponse;
import com.cntaiping.hw.support.jeepay.net.HttpHeaders;
import com.cntaiping.hw.support.jeepay.request.JeepayRequest;
import com.cntaiping.hw.support.jeepay.response.JeepayResponse;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public abstract class APIResource {
    private final RestTemplate restTemplate;
    private static final Logger _log = LoggerFactory.getLogger(APIResource.class);
    public static final Charset CHARSET = StandardCharsets.UTF_8;

    protected APIResource(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public static Class<?> getSelfClass() {
        return APIResource.class;
    }

    protected static String urlEncode(String str) {
        if (str == null) {
            return null;
        }
        try {
            return URLEncoder.encode(str, CHARSET.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 is unknown");
        }
    }

    public <T extends JeepayResponse> T execute(JeepayRequest<T> request, RequestMethod method, String url) throws JeepayException {
        String jsonParam = JSONObject.toJSONString((Object)request.getBizModel());
        JSONObject params = JSONObject.parseObject((String)jsonParam);
        APIJeepayRequest apiJeepayRequest = new APIJeepayRequest(method, url, (Map<String, Object>)params, request.getRequestOptions());
        if (_log.isDebugEnabled()) {
            _log.debug("Jeepay_SDK_REQ\uff1aurl={}, data={}", (Object)apiJeepayRequest.getUrl(), (Object)JSONObject.toJSONString(apiJeepayRequest.getParams()));
        }
        APIJeepayResponse response = this.executeInner(apiJeepayRequest);
        int responseCode = response.getResponseCode();
        String responseBody = response.getResponseBody();
        if (_log.isDebugEnabled()) {
            _log.debug("Jeepay_SDK_RES\uff1acode={}, body={}", (Object)responseCode, (Object)responseBody);
        }
        if (responseCode != 200) {
            APIResource.handleAPIError(response);
        }
        JeepayResponse resource = null;
        try {
            resource = (JeepayResponse)JSONObject.parseObject((String)responseBody, request.getResponseClass());
        }
        catch (JSONException e) {
            APIResource.raiseMalformedJsonError(responseBody, responseCode);
        }
        return (T)resource;
    }

    private APIJeepayResponse executeInner(APIJeepayRequest request) throws APIConnectionException {
        try {
            URI uri = request.getUrl().toURI();
            HttpMethod httpMethod = HttpMethod.valueOf((String)request.getMethod().toString());
            org.springframework.http.HttpHeaders headers = new org.springframework.http.HttpHeaders();
            headers.setContentType(MediaType.parseMediaType((String)request.content.contentType));
            headers.add("User-Agent", APIResource.buildUserAgentString(request.getOptions().getVersion()));
            headers.add("X-Jeepay-Client-User-Agent", APIResource.buildXJeepayClientUserAgentString(request.getOptions().getVersion()));
            headers.putAll(request.getHeaders().map());
            RequestEntity requestEntity = new RequestEntity((Object)request.content.byteArrayContent, (MultiValueMap)headers, httpMethod, uri);
            ResponseEntity response = this.restTemplate.exchange(requestEntity, String.class);
            return new APIJeepayResponse(response.getStatusCode().value(), (String)response.getBody(), HttpHeaders.of((Map<String, List<String>>)response.getHeaders()));
        }
        catch (URISyntaxException e) {
            throw new APIConnectionException(e.getMessage(), e);
        }
    }

    private static void handleAPIError(APIJeepayResponse response) throws JeepayException {
        String rBody = response.getResponseBody();
        int rCode = response.getResponseCode();
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject = JSONObject.parseObject((String)rBody);
        }
        catch (JSONException e) {
            APIResource.raiseMalformedJsonError(rBody, rCode);
        }
        if (rCode == 404) {
            throw new InvalidRequestException(jsonObject.getString("status") + ", " + jsonObject.getString("error") + ", " + jsonObject.getString("path"), rCode, null);
        }
    }

    private static void raiseMalformedJsonError(String responseBody, int responseCode) throws APIException {
        throw new APIException(String.format("Invalid response object from API: %s. (HTTP response code was %d)", responseBody, responseCode), null, null, responseCode, null);
    }

    protected static String buildUserAgentString(String version) {
        return String.format("Jeepay/v1 JavaBindings/%s", version);
    }

    protected static String buildXJeepayClientUserAgentString(String version) {
        String[] propertyNames = new String[]{"os.name", "os.version", "os.arch", "java.version", "java.vendor", "java.vm.version", "java.vm.vendor"};
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        for (String propertyName : propertyNames) {
            propertyMap.put(propertyName, System.getProperty(propertyName));
        }
        propertyMap.put("bindings.version", version);
        propertyMap.put("lang", "Java");
        propertyMap.put("publisher", "Jeepay");
        return JSON.toJSONString(propertyMap);
    }

    protected static enum RequestMethod {
        GET,
        POST,
        DELETE,
        PUT;

    }
}

