/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.hw.support.jeepay.util;

import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JeepayKit {
    private static String encodingCharset = "UTF-8";
    private static final Logger _log = LoggerFactory.getLogger(JeepayKit.class);

    public static String getStrSort(Map<String, Object> map) {
        ArrayList<CallSite> list = new ArrayList<CallSite>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (null == entry.getValue() || "".equals(entry.getValue())) continue;
            list.add((CallSite)((Object)(entry.getKey() + "=" + entry.getValue() + "&")));
        }
        int size = list.size();
        String[] arrayToSort = list.toArray(new String[size]);
        Arrays.sort(arrayToSort, String.CASE_INSENSITIVE_ORDER);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            sb.append(arrayToSort[i]);
        }
        return sb.toString();
    }

    public static String getSign(Map<String, Object> map, String key) {
        Object result = JeepayKit.getStrSort(map);
        result = (String)result + "key=" + key;
        if (_log.isDebugEnabled()) {
            _log.debug("signStr:{}", result);
        }
        result = JeepayKit.md5((String)result, encodingCharset).toUpperCase();
        if (_log.isDebugEnabled()) {
            _log.debug("signValue:{}", result);
        }
        return result;
    }

    public static String getSign(String signStr, String key) {
        signStr = (String)signStr + "key=" + key;
        String result = JeepayKit.md5((String)signStr, encodingCharset).toUpperCase();
        return result;
    }

    public static String getSign(String signStr) {
        return JeepayKit.md5(signStr, encodingCharset).toUpperCase();
    }

    public static String md5(String value, String charset) {
        MessageDigest md = null;
        try {
            byte[] data = value.getBytes(charset);
            md = MessageDigest.getInstance("MD5");
            byte[] digestData = md.digest(data);
            return JeepayKit.toHex(digestData);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String toHex(byte[] input) {
        if (input == null) {
            return null;
        }
        StringBuffer output = new StringBuffer(input.length * 2);
        for (int i = 0; i < input.length; ++i) {
            int current = input[i] & 0xFF;
            if (current < 16) {
                output.append("0");
            }
            output.append(Integer.toString(current, 16));
        }
        return output.toString();
    }
}

