/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.hw.support.oss;

import com.cntaiping.hw.support.oss.NoSuchFileException;
import com.cntaiping.hw.support.oss.S3Repository;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.WritableResource;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;

public class S3ObjectResource
extends AbstractResource
implements WritableResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(S3ObjectResource.class);
    private final S3Repository s3Repository;
    private final S3Client s3Client;
    private final String filePath;
    private final String filename;
    private volatile boolean headed = false;
    private volatile HeadObjectResponse headObjectResponse;

    public S3ObjectResource(S3Repository s3Repository, S3Client s3Client, String filePath, String fileName) {
        this.s3Repository = s3Repository;
        this.s3Client = s3Client;
        this.filePath = filePath;
        this.filename = fileName;
    }

    @NotNull
    public String getDescription() {
        return "s3 [" + this.filePath + "]";
    }

    public InputStream getInputStream() throws IOException {
        try {
            return this.s3Repository.getFile(this.filePath);
        }
        catch (NoSuchFileException e) {
            return InputStream.nullInputStream();
        }
    }

    public boolean exists() {
        if (this.headed) {
            return this.headObjectResponse != null;
        }
        this.headObject();
        return this.exists();
    }

    public boolean isReadable() {
        return super.isReadable();
    }

    public boolean isOpen() {
        return super.isOpen();
    }

    public boolean isFile() {
        return super.isFile();
    }

    @NotNull
    public URL getURL() throws IOException {
        return super.getURL();
    }

    @NotNull
    public URI getURI() throws IOException {
        return super.getURI();
    }

    @NotNull
    public File getFile() throws IOException {
        return super.getFile();
    }

    @NotNull
    public ReadableByteChannel readableChannel() throws IOException {
        return super.readableChannel();
    }

    public long contentLength() {
        if (this.headed) {
            if (this.headObjectResponse == null) {
                return 0L;
            }
            return this.headObjectResponse.contentLength();
        }
        this.headObject();
        return this.contentLength();
    }

    public long lastModified() throws IOException {
        if (this.headed) {
            if (this.headObjectResponse == null) {
                return -1L;
            }
            return this.headObjectResponse.lastModified().toEpochMilli();
        }
        this.headObject();
        return this.lastModified();
    }

    @NotNull
    protected File getFileForLastModifiedCheck() throws IOException {
        return super.getFileForLastModifiedCheck();
    }

    @NotNull
    public Resource createRelative(String relativePath) throws IOException {
        return super.createRelative(relativePath);
    }

    public String getFilename() {
        return this.filename;
    }

    private synchronized void headObject() {
        if (this.headed) {
            return;
        }
        try {
            this.headObjectResponse = this.s3Repository.headFile(this.filePath);
            this.headed = !this.headed;
        }
        catch (NoSuchFileException e) {
            try {
                LOGGER.info("object [{}] not exists.", (Object)this.filePath);
                this.headed = !this.headed;
            }
            catch (Throwable throwable) {
                this.headed = !this.headed;
                throw throwable;
            }
        }
    }

    public String getFilePath() {
        return this.filePath;
    }

    @NotNull
    public OutputStream getOutputStream() throws IOException {
        return new S3OutputStream();
    }

    private class S3OutputStream
    extends OutputStream {
        private Path tempFile = Files.createTempFile("s3-resource-", ".tmp", new FileAttribute[0]);
        private OutputStream tempOutputStream = Files.newOutputStream(this.tempFile, new OpenOption[0]);

        S3OutputStream() throws IOException {
        }

        @Override
        public void write(int b) throws IOException {
            this.tempOutputStream.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.tempOutputStream.write(b, off, len);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            this.tempOutputStream.close();
            try (InputStream is = Files.newInputStream(this.tempFile, new OpenOption[0]);){
                S3ObjectResource.this.s3Repository.saveFile(S3ObjectResource.this.filePath + "/" + S3ObjectResource.this.filename, is);
            }
            finally {
                Files.delete(this.tempFile);
            }
        }
    }
}

