/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.hw.support.oss;

import com.cntaiping.hw.support.oss.NoSuchFileException;
import com.cntaiping.hw.support.oss.S3ObjectResource;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;

public class S3Repository {
    private static final Logger LOGGER = LoggerFactory.getLogger(S3Repository.class);
    private final S3Client s3Client;
    private final S3AsyncClient s3AsyncClient;
    private final String bucketName;
    private final String basePath;

    public S3Repository(S3Client s3Client, S3AsyncClient s3AsyncClient, String bucketName) {
        this(s3Client, s3AsyncClient, bucketName, "");
    }

    public S3Repository(S3Client s3Client, S3AsyncClient s3AsyncClient, String bucketName, String basePath) {
        this.s3Client = s3Client;
        this.s3AsyncClient = s3AsyncClient;
        this.bucketName = bucketName;
        this.basePath = basePath;
    }

    public HeadObjectResponse headFile(String filePath) throws NoSuchFileException {
        if (filePath == null) {
            throw new NoSuchFileException("file path is null");
        }
        String bucket = this.getBucket();
        String fileKey = this.getFileKey(filePath);
        HeadObjectRequest request = (HeadObjectRequest)HeadObjectRequest.builder().bucket(bucket).key(fileKey).build();
        try {
            return this.s3Client.headObject(request);
        }
        catch (NoSuchKeyException e) {
            if (e.statusCode() == 404) {
                LOGGER.info("\"{}\" not exists in bucket [{}]", (Object)fileKey, (Object)bucket);
                String msg = "no such file, filePath = " + fileKey;
                throw new NoSuchFileException(msg, e);
            }
            throw e;
        }
    }

    public void deleteFile(String filePath) {
        if (filePath == null) {
            return;
        }
        if (!this.fileExists(filePath)) {
            return;
        }
        String fileKey = this.getFileKey(filePath);
        DeleteObjectRequest deleteObjectRequest = (DeleteObjectRequest)DeleteObjectRequest.builder().bucket(this.getBucket()).key(fileKey).build();
        this.s3Client.deleteObject(deleteObjectRequest);
    }

    public void saveFile(String filePath, InputStream inputStream) throws IOException {
        if (filePath == null || inputStream == null) {
            return;
        }
        String fileKey = this.getFileKey(filePath);
        PutObjectRequest request = (PutObjectRequest)PutObjectRequest.builder().bucket(this.getBucket()).key(fileKey).build();
        this.s3Client.putObject(request, RequestBody.fromInputStream((InputStream)inputStream, (long)inputStream.available()));
    }

    public S3ObjectResource getFileResource(String filePath, String filename) throws NoSuchFileException {
        return new S3ObjectResource(this, this.s3Client, filePath, filename);
    }

    public InputStream getFile(String filePath) throws NoSuchFileException {
        if (filePath == null) {
            return InputStream.nullInputStream();
        }
        String fileKey = this.getFileKey(filePath);
        String bucket = this.getBucket();
        GetObjectRequest request = (GetObjectRequest)GetObjectRequest.builder().bucket(bucket).key(fileKey).build();
        try {
            return this.s3Client.getObject(request);
        }
        catch (NoSuchKeyException e) {
            if (e.statusCode() == 404) {
                LOGGER.info("\"{}\" not exists in bucket [{}]", (Object)fileKey, (Object)bucket);
                String msg = "no such file, filePath = " + filePath;
                throw new NoSuchFileException(msg, e);
            }
            throw e;
        }
    }

    public String getBucket() {
        return this.bucketName;
    }

    @NotNull
    public String getFileKey(String filePath) {
        return this.basePath + filePath;
    }

    public boolean fileExists(String filePath) {
        if (filePath == null) {
            return false;
        }
        String fileKey = this.getFileKey(filePath);
        String bucket = this.getBucket();
        try {
            HeadObjectRequest request = (HeadObjectRequest)HeadObjectRequest.builder().bucket(bucket).key(fileKey).build();
            this.s3Client.headObject(request);
            return true;
        }
        catch (NoSuchKeyException e) {
            if (e.statusCode() == 404) {
                return false;
            }
            throw e;
        }
    }
}

