/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.hw.support.oss;

import java.io.Closeable;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Cleaner;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;

public class TempFileSystemResource
extends FileSystemResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(TempFileSystemResource.class);
    private static final Cleaner CLEANER = Cleaner.create();

    public TempFileSystemResource(File file) {
        super(file);
        State state = new State(file);
        CLEANER.register((Object)this, state);
    }

    @NotNull
    public ReadableByteChannel readableChannel() throws IOException {
        final ReadableByteChannel readableChannel = super.readableChannel();
        return new ReadableByteChannel(){

            @Override
            public boolean isOpen() {
                return readableChannel.isOpen();
            }

            @Override
            public void close() throws IOException {
                TempFileSystemResource.this.closeThenDeleteFile(readableChannel);
            }

            @Override
            public int read(ByteBuffer dst) throws IOException {
                return readableChannel.read(dst);
            }
        };
    }

    @NotNull
    public InputStream getInputStream() throws IOException {
        return new FilterInputStream(super.getInputStream()){

            @Override
            public void close() throws IOException {
                TempFileSystemResource.this.closeThenDeleteFile(this.in);
            }
        };
    }

    private void closeThenDeleteFile(Closeable closeable) throws IOException {
        try {
            closeable.close();
        }
        finally {
            this.deleteFile();
        }
    }

    private void deleteFile() {
        try {
            Files.delete(this.getFile().toPath());
        }
        catch (IOException ex) {
            LOGGER.warn("Failed to delete temporary file '" + this.getFile() + "'", (Throwable)ex);
        }
    }

    public boolean isFile() {
        return false;
    }

    static class State
    implements Runnable {
        private final File file;

        State(File file) {
            this.file = file;
        }

        @Override
        public void run() {
            LOGGER.info("[TempFileSystemResource.State] deleting file {}", (Object)this.file);
            if (this.file != null && this.file.exists()) {
                this.file.delete();
            }
        }
    }
}

