/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.hw.support.util;

import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.core.ResolvableType;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public class BeanCopyUtils {
    public static <Source, Target> void copyBigObject(Source sourceObject, Target targetObject) {
        try {
            BeanCopyUtils.copyBigObject(sourceObject, targetObject, null, null, null, null, new String[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <Source, Target> void copyBigObject(Source sourceObject, Target targetObject, String replaceFrom, String replaceTo, List<Class<?>> ignoreFromClass, Map<String, Object> toFieldDefaultValueMap, String ... ignoresProperties) {
        try {
            BeanCopyUtils.copyProperties(sourceObject, targetObject, toFieldDefaultValueMap, ignoreFromClass, ignoresProperties);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static <Source, Target> void copyProperties(Source sourceObject, Target targetObject, Map<String, Object> toFieldDefaultValueMap, List<Class<?>> ignoreFromClass, String ... ignoresProperties) throws Exception {
        List<PropertyDescriptor> sourceFieldDescriptors = Arrays.asList(BeanUtils.getPropertyDescriptors(sourceObject.getClass()));
        List<PropertyDescriptor> targetFieldDescriptors = Arrays.asList(BeanUtils.getPropertyDescriptors(targetObject.getClass()));
        if (ignoresProperties != null && ignoresProperties.length != 0) {
            List<String> ignoresPropertyList = Arrays.asList(ignoresProperties);
            sourceFieldDescriptors = sourceFieldDescriptors.stream().filter(e -> !ignoresPropertyList.contains(e.getName())).toList();
        }
        if (!CollectionUtils.isEmpty(ignoreFromClass)) {
            sourceFieldDescriptors = sourceFieldDescriptors.stream().filter(e -> !ignoreFromClass.contains(e.getPropertyType())).toList();
        }
        Set sourceFiledNameSet = sourceFieldDescriptors.stream().map(FeatureDescriptor::getName).collect(Collectors.toSet());
        Set targetFiledNameSet = targetFieldDescriptors.stream().map(FeatureDescriptor::getName).collect(Collectors.toSet());
        HashSet intersectionSet = new HashSet(sourceFiledNameSet);
        intersectionSet.retainAll(targetFiledNameSet);
        List<PropertyDescriptor> ignoreProperties = targetFieldDescriptors.stream().filter(e -> !intersectionSet.contains(e.getName()) || intersectionSet.contains(e.getName()) && !BeanUtils.isSimpleProperty(e.getPropertyType())).toList();
        Set<String> ignorePropertiesFiledNameSet = ignoreProperties.stream().map(FeatureDescriptor::getName).collect(Collectors.toSet());
        String[] ignoreFields = new String[ignorePropertiesFiledNameSet.size()];
        ignorePropertiesFiledNameSet.toArray(ignoreFields);
        BeanUtils.copyProperties(sourceObject, targetObject, (String[])ignoreFields);
        BeanCopyUtils.fillDefaultValue(targetObject, toFieldDefaultValueMap);
        List<PropertyDescriptor> nonSimpleProperties = targetFieldDescriptors.stream().filter(e -> intersectionSet.contains(e.getName()) && !BeanUtils.isSimpleProperty(e.getPropertyType())).toList();
        Map<String, Method> sourceNonSimplePropertyMap = sourceFieldDescriptors.stream().filter(e -> intersectionSet.contains(e.getName()) && !BeanUtils.isSimpleProperty(e.getPropertyType())).collect(Collectors.toMap(FeatureDescriptor::getName, PropertyDescriptor::getReadMethod));
        for (PropertyDescriptor nonSimpleProperty : nonSimpleProperties) {
            Object sourceField;
            if (!Modifier.isPublic(sourceNonSimplePropertyMap.get(nonSimpleProperty.getName()).getDeclaringClass().getModifiers())) {
                sourceNonSimplePropertyMap.get(nonSimpleProperty.getName()).setAccessible(true);
            }
            if ((sourceField = sourceNonSimplePropertyMap.get(nonSimpleProperty.getName()).invoke(sourceObject, new Object[0])) == null) continue;
            Collection<?> targetField = null;
            if (Collection.class.isAssignableFrom(nonSimpleProperty.getPropertyType())) {
                ParameterizedType type = (ParameterizedType)nonSimpleProperty.getWriteMethod().getGenericParameterTypes()[0];
                Type c = type.getActualTypeArguments()[0];
                if (c instanceof ParameterizedType) {
                    System.out.println("\u672a\u77e5\u7684\u7c7b\u578b\u8f6c\u6362\uff1a" + c.getTypeName());
                    continue;
                }
                targetField = BeanCopyUtils.copyCollection((Collection)sourceField, Class.forName(c.getTypeName()), toFieldDefaultValueMap, ignoreFromClass, ignoresProperties);
            } else {
                targetField = (Collection<?>)nonSimpleProperty.getPropertyType().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                BeanCopyUtils.copyProperties(sourceField, targetField, toFieldDefaultValueMap, ignoreFromClass, ignoresProperties);
            }
            nonSimpleProperty.getWriteMethod().invoke(targetObject, targetField);
        }
    }

    private static void fillDefaultValue(Object targetObject, Map<String, Object> toFieldDefaultValueMap) throws Exception {
        if (targetObject == null || toFieldDefaultValueMap == null) {
            return;
        }
        List<PropertyDescriptor> targetFieldDescriptors = Arrays.asList(BeanUtils.getPropertyDescriptors(targetObject.getClass()));
        Object defaultValue = null;
        for (PropertyDescriptor targetFieldDescriptor : targetFieldDescriptors) {
            if (!toFieldDefaultValueMap.containsKey(targetFieldDescriptor.getName())) continue;
            defaultValue = toFieldDefaultValueMap.get(targetFieldDescriptor.getName());
            if (defaultValue != null) {
                ResolvableType defaultValueResolvableType = ResolvableType.forClass(defaultValue.getClass());
                ResolvableType targetWriteResolvableType = ResolvableType.forMethodParameter((Method)targetFieldDescriptor.getWriteMethod(), (int)0);
                boolean isAssignable = !defaultValueResolvableType.hasUnresolvableGenerics() && !targetWriteResolvableType.hasUnresolvableGenerics() ? targetWriteResolvableType.isAssignableFrom(defaultValueResolvableType) : ClassUtils.isAssignable(targetFieldDescriptor.getWriteMethod().getParameterTypes()[0], defaultValue.getClass());
                if (!isAssignable) continue;
            }
            if (!Modifier.isPublic(targetFieldDescriptor.getWriteMethod().getClass().getModifiers())) {
                targetFieldDescriptor.getWriteMethod().setAccessible(true);
            }
            targetFieldDescriptor.getWriteMethod().invoke(targetObject, defaultValue);
        }
    }

    private static <Source, Target> Collection<Target> copyCollection(Collection<Source> sourceCollection, Class<Target> targetClass, Map<String, Object> toFieldDefaultValueMap, List<Class<?>> ignoreFromClass, String ... ignoresProperties) throws Exception {
        Collection tc = (Collection)sourceCollection.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Object target = null;
        for (Source source : sourceCollection) {
            target = targetClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            BeanCopyUtils.copyProperties(source, target, toFieldDefaultValueMap, ignoreFromClass, ignoresProperties);
            tc.add(target);
        }
        return tc;
    }
}

