/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.hw.support.util;

import com.cntaiping.hw.support.util.DateUtils;
import com.cntaiping.sg.tpsgi.annotation.DateTransQueryField;
import com.cntaiping.sg.tpsgi.annotation.FuzzyQueryField;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CommonUtils.class);

    public static <T> void transitionSearch(Object obj, Class<T> clazz, Set<String> dealFields) {
        if (obj != null) {
            try {
                Field[] fields;
                for (Field field : fields = clazz.getDeclaredFields()) {
                    String fieldName;
                    Annotation[] annotations = field.getAnnotations();
                    if (annotations == null || annotations.length == 0) continue;
                    field.setAccessible(true);
                    Object value = field.get(obj);
                    if (value == null || dealFields.contains(fieldName = field.getName())) continue;
                    dealFields.add(fieldName);
                    String filedTypeName = field.getType().getSimpleName();
                    for (Annotation annotation : annotations) {
                        DateTransQueryField dateTransQueryField;
                        if (FuzzyQueryField.class.equals(annotation.annotationType())) {
                            FuzzyQueryField fuzzyQueryField = field.getAnnotation(FuzzyQueryField.class);
                            if (fuzzyQueryField == null || !"String".equals(filedTypeName)) continue;
                            boolean preFuzzy = fuzzyQueryField.preFuzzy();
                            String transValue = CommonUtils.transitionSearch((String)value, preFuzzy);
                            field.set(obj, transValue);
                            continue;
                        }
                        if (!DateTransQueryField.class.equals(annotation.annotationType()) || (dateTransQueryField = field.getAnnotation(DateTransQueryField.class)) == null || !"Date".equals(filedTypeName)) continue;
                        Date date = (Date)value;
                        Date newDate = DateUtils.trunc(date);
                        boolean lastSecond = dateTransQueryField.toDateEnd();
                        if (lastSecond) {
                            newDate = DateUtils.toDateEnd(date);
                        }
                        field.set(obj, newDate);
                    }
                }
                Class<T> supperClass = clazz.getSuperclass();
                if (supperClass != null && !"Object".equals(supperClass.getSimpleName())) {
                    CommonUtils.transitionSearch(obj, supperClass, dealFields);
                }
            }
            catch (Exception e) {
                LOG.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public static void transitionSearch(Object obj) {
        if (obj != null) {
            CommonUtils.transitionSearch(obj, obj.getClass(), new HashSet<String>());
        }
    }

    public static String transitionSearch(String conditions, boolean fuzzyQuery) {
        if (StringUtils.isNotEmpty((CharSequence)conditions)) {
            String conditionsTail;
            conditions = conditions.trim();
            String conditionsHead = conditions.substring(0, 1);
            if (fuzzyQuery && "*".equals(conditionsHead)) {
                conditionsHead = "%";
            }
            if ((conditionsTail = conditions.substring(1, conditions.length())).contains("*")) {
                conditionsTail = conditionsTail.replace("*", "%");
            }
            return conditionsHead + conditionsTail;
        }
        return conditions;
    }

    public static String transitionSearchNoTrim(String conditions, boolean fuzzyQuery) {
        if (StringUtils.isNotEmpty((CharSequence)conditions)) {
            String conditionsTail;
            conditions = conditions.replace("%", "\\%");
            String conditionsHead = conditions.substring(0, 1);
            if (fuzzyQuery && "*".equals(conditionsHead)) {
                conditionsHead = "%";
            }
            if ((conditionsTail = conditions.substring(1, conditions.length())).contains("*")) {
                conditionsTail = conditionsTail.replace("*", "%");
            }
            return conditionsHead + conditionsTail;
        }
        return conditions;
    }

    public static String transitionSearch(String conditions) {
        return CommonUtils.transitionSearch(conditions, false);
    }

    public static boolean checkIdNo(String inHKID) {
        if (StringUtils.isEmpty((CharSequence)inHKID)) {
            return false;
        }
        String regex = "^[A-Z]{1}[0-9]{6}[A0-9]{1}$";
        if (!inHKID.matches(regex)) {
            return false;
        }
        String lastCheckCharacter = CommonUtils.getLastCharacter(inHKID.substring(0, 7));
        String hkid_x8 = inHKID.substring(7, 8);
        return Objects.equals(lastCheckCharacter, hkid_x8);
    }

    private static String getLastCharacter(String inHKIDPrefix) {
        int hkid_x2_num;
        if (StringUtils.isEmpty((CharSequence)inHKIDPrefix)) {
            return null;
        }
        String regex = "^[A-Z]{1}[0-9]{6}$";
        if (!inHKIDPrefix.matches(regex)) {
            return null;
        }
        String hkid_x1 = " ";
        String hkid_x2 = inHKIDPrefix.substring(0, 1);
        int hkid_digit1 = Integer.parseInt(inHKIDPrefix.substring(1, 2));
        int hkid_digit2 = Integer.parseInt(inHKIDPrefix.substring(2, 3));
        int hkid_digit3 = Integer.parseInt(inHKIDPrefix.substring(3, 4));
        int hkid_digit4 = Integer.parseInt(inHKIDPrefix.substring(4, 5));
        int hkid_digit5 = Integer.parseInt(inHKIDPrefix.substring(5, 6));
        int hkid_digit6 = Integer.parseInt(inHKIDPrefix.substring(6, 7));
        int hkid_x1_num = CommonUtils.trans2Number(hkid_x1);
        int hkid_sum = hkid_x1_num * 9 + (hkid_x2_num = CommonUtils.trans2Number(hkid_x2)) * 8 + hkid_digit1 * 7 + hkid_digit2 * 6 + hkid_digit3 * 5 + hkid_digit4 * 4 + hkid_digit5 * 3 + hkid_digit6 * 2;
        int hkid_mod = hkid_sum % 11;
        int hkid_checked_digit = 11 - hkid_mod;
        if (hkid_checked_digit == 11) {
            hkid_checked_digit = 0;
        }
        if (hkid_checked_digit == 10) {
            return "A";
        }
        return "" + hkid_checked_digit;
    }

    private static int trans2Number(String hkid_x1) {
        return switch (hkid_x1) {
            case "A" -> 10;
            case "B" -> 11;
            case "C" -> 12;
            case "D" -> 13;
            case "E" -> 14;
            case "F" -> 15;
            case "G" -> 16;
            case "H" -> 17;
            case "I" -> 18;
            case "J" -> 19;
            case "K" -> 20;
            case "L" -> 21;
            case "M" -> 22;
            case "N" -> 23;
            case "O" -> 24;
            case "P" -> 25;
            case "Q" -> 26;
            case "R" -> 27;
            case "S" -> 28;
            case "T" -> 29;
            case "U" -> 30;
            case "V" -> 31;
            case "W" -> 32;
            case "X" -> 33;
            case "Y" -> 34;
            case "Z" -> 35;
            case " " -> 36;
            default -> 0;
        };
    }

    private static boolean checkReturnCertificate(String identifyNumber) {
        if (StringUtils.isEmpty((CharSequence)identifyNumber)) {
            return false;
        }
        String regex = "^[HM]{1}[0-9]{8}|[HM]{1}[0-9]{10}$";
        return identifyNumber.matches(regex);
    }

    private static boolean checkBusinessReg(String identifyNumber) {
        if (StringUtils.isEmpty((CharSequence)identifyNumber)) {
            return false;
        }
        String regex = "^([0-9]{8}){1}(-[0-9]{3})?";
        return identifyNumber.matches(regex);
    }

    public static boolean checkIdentifyNo(String partyType, String identifyType, String identifyNumber) {
        if ("I".equals(partyType)) {
            if ("00".equals(identifyType)) {
                return CommonUtils.checkIdNo(identifyNumber);
            }
            if ("06".equals(identifyType)) {
                return CommonUtils.checkReturnCertificate(identifyNumber);
            }
        } else if ("00".equals(identifyType)) {
            return CommonUtils.checkBusinessReg(identifyNumber);
        }
        return true;
    }

    private static List<String> generateIDNo(int count) {
        int a = 65;
        int z = 90;
        ArrayList<Character> list = new ArrayList<Character>();
        for (int i = a; i < z; ++i) {
            list.add(Character.valueOf((char)i));
        }
        ArrayList<String> idNos = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            int random = new Random().nextInt(list.size());
            char first = ((Character)list.get(random)).charValue();
            String s = CommonUtils.getRandomNum(6);
            String prefix = first + s;
            idNos.add(prefix + CommonUtils.getLastCharacter(prefix));
        }
        return idNos;
    }

    private static String getRandomNum(int size) {
        String source = "0123456789";
        Random random = new Random();
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            s.append(source.charAt(random.nextInt(9)));
        }
        return s.toString();
    }

    public static Object nullToDefault(Object obj1, Object obj2) {
        return obj1 == null ? obj2 : obj1;
    }

    public static String nullToDefault(String str1, String str2) {
        return str1 == null ? str2 : str1;
    }

    public static String nullToEmpty(String str) {
        return CommonUtils.nullToDefault(str, "");
    }

    public static boolean noId(String identifyType) {
        return "88".equals(identifyType);
    }

    public static String constantReplace(String modelContent, Object ... params) {
        if (StringUtils.isEmpty((CharSequence)modelContent) || params == null || params.length == 0) {
            return modelContent;
        }
        return String.format(modelContent, params);
    }

    public static void main(String[] args) {
        List<String> idNos = CommonUtils.generateIDNo(50);
        String s = null;
        String b = "1";
        System.err.println(CommonUtils.nullToDefault(s, b));
    }
}

