/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.hw.support.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.Period;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class DateUtils {
    public static final String Y_TO_MON = "yyyy-MM";
    public static final String Y_TO_DAY = "yyyy-MM-dd";
    public static final String Y_TO_HOUR = "yyyy-MM-dd HH";
    public static final String Y_TO_MIN = "yyyy-MM-dd HH:mm";
    public static final String Y_TO_SEC = "yyyy-MM-dd HH:mm:ss";
    public static final String DMY = "dd-MM-yyyy";
    public static final String YMD = "yyyyMMdd";
    public static final String YMD_TO_SEC = "yyyyMMddHHmmss";
    public static final String YM = "yyyy\u5e74MM\u6708";
    public static final String NUM_YEAR_TO_MILLS = "yyyyMMddHHmmssSSS";
    public static final String NUM_SIMPLE_YEAR_TO_DAY = "yyMMdd";
    public static final int YEAR = 1;
    public static final int MONTH = 2;
    public static final int DAY = 5;
    public static final int HOUR = 11;
    public static final int MINUTE = 12;
    public static final int SECOND = 13;
    public static final String DATE_UNIT_DAY = "D";
    public static final String DATE_UNIT_MONTH = "M";
    public static final String DATE_UNIT_YEAR = "Y";
    private static final String[] PARSE_PATTERNS = new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH", "yyyy-MM-dd HH:mm", "yyyyMMdd", "yyyy-MM-dd HH:mm:ss.SSS"};
    public static String specialDate = "03-01,05-01,07-01,10-01,12-01";

    public static Date now() {
        return new Date();
    }

    @Deprecated
    public static Date now(String format) throws ParseException {
        String nowStr = DateUtils.dateToStr(new Date(), format);
        return DateUtils.strToDate(nowStr, format);
    }

    public static Date now(int field) {
        return DateUtils.trunc(new Date(), field);
    }

    public static Date trunc(Date date) {
        return DateUtils.trunc(date, 5);
    }

    public static Date trunc(Date date, int field) {
        return org.apache.commons.lang3.time.DateUtils.truncate((Date)date, (int)field);
    }

    public static String nowStr() {
        return DateUtils.dateToStr(new Date(), Y_TO_SEC);
    }

    public static String nowStr(String format) {
        return DateUtils.dateToStr(new Date(), format);
    }

    public static Date strToDate(String dateStr) throws ParseException {
        if (dateStr == null || "".equals(dateStr.trim())) {
            return null;
        }
        return org.apache.commons.lang3.time.DateUtils.parseDate((String)dateStr, (String[])PARSE_PATTERNS);
    }

    public static Date strToDate(String dateStr, String format) throws ParseException {
        if (dateStr == null || "".equals(dateStr.trim())) {
            return null;
        }
        SimpleDateFormat myFormat = new SimpleDateFormat(format);
        return myFormat.parse(dateStr.trim());
    }

    public static String dateToStr(Date date, String format) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat myFormat = new SimpleDateFormat(format);
        return myFormat.format(date);
    }

    public static String dateToStr(Date date, String format, Locale locale) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat myFormat = new SimpleDateFormat(format, locale);
        return myFormat.format(date);
    }

    public static Date addYears(Date date, int amount) {
        return DateUtils.add(date, 1, amount);
    }

    public static Date addMonths(Date date, int amount) {
        return DateUtils.add(date, 2, amount);
    }

    public static Date addWeeks(Date date, int amount) {
        return DateUtils.add(date, 3, amount);
    }

    public static Date addDays(Date date, int amount) {
        return DateUtils.add(date, 5, amount);
    }

    public static Date addHours(Date date, int amount) {
        return DateUtils.add(date, 11, amount);
    }

    public static Date addMinutes(Date date, int amount) {
        return DateUtils.add(date, 12, amount);
    }

    public static Date addSecond(Date date, int amount) {
        return DateUtils.add(date, 13, amount);
    }

    public static Date add(Date date, int calendarField, int amount) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(calendarField, amount);
        return c.getTime();
    }

    public static int compareDays(Date end, Date start) {
        long disSes = end.getTime() - start.getTime();
        return (int)(disSes / 86400000L);
    }

    public static int compareMonths(Date date1, Date date2) {
        int year1 = DateUtils.getFieldValue(date1, 1);
        int month1 = DateUtils.getFieldValue(date1, 2);
        int day1 = DateUtils.getFieldValue(date1, 5);
        int hour1 = DateUtils.getFieldValue(date1, 11);
        int year2 = DateUtils.getFieldValue(date2, 1);
        int month2 = DateUtils.getFieldValue(date2, 2);
        int day2 = DateUtils.getFieldValue(date2, 5);
        int hour2 = DateUtils.getFieldValue(date2, 11);
        int monthValues = (year1 - year2) * 12 + (month1 - month2);
        if (day1 - day2 < 0 || day1 == day2 && hour1 < hour2) {
            --monthValues;
        }
        return monthValues;
    }

    public static int newCompareMonths(Date startDate, Date endDate) {
        int monthValues = 0;
        if (startDate != null && endDate != null) {
            int startYear = DateUtils.getFieldValue(startDate, 1);
            int startMonth = DateUtils.getFieldValue(startDate, 2) + 1;
            int startDay = DateUtils.getFieldValue(startDate, 5);
            int endYear = DateUtils.getFieldValue(endDate, 1);
            int endMonth = DateUtils.getFieldValue(endDate, 2) + 1;
            int endDay = DateUtils.getFieldValue(endDate, 5);
            LocalDate oldDate = LocalDate.of(startYear, startMonth, startDay);
            LocalDate today = LocalDate.of(endYear, endMonth, endDay);
            Period p = Period.between(oldDate, today);
            int yearValues = p.getYears();
            monthValues = yearValues * 12 + p.getMonths();
            int dayValues = p.getDays();
            if (p.getDays() == 1 && endDay == 1 && today.minusDays(1L).getDayOfMonth() != startDay) {
                dayValues = 0;
            }
            if (dayValues > 0) {
                ++monthValues;
            }
        }
        return monthValues;
    }

    public static int diffMonths(Date start, Date end) {
        int result = 0;
        int startYear = DateUtils.getFieldValue(start, 1);
        int startMonth = DateUtils.getFieldValue(start, 2);
        int startDay = DateUtils.getFieldValue(start, 5);
        int endYear = DateUtils.getFieldValue(end, 1);
        int endMonth = DateUtils.getFieldValue(end, 2);
        int endDay = DateUtils.getFieldValue(end, 5);
        result = startDay > endDay ? (startMonth == 1 && startDay == 29 && endMonth == 1 && endDay == 28 ? (endYear - startYear) * 12 + endMonth - startMonth : (endYear - startYear) * 12 + endMonth - startMonth - 1) : (endYear - startYear) * 12 + endMonth - startMonth;
        return result;
    }

    public static int diffMonthsIgnoreDays(Date start, Date end) {
        int result = 0;
        int startYear = DateUtils.getFieldValue(start, 1);
        int startMonth = DateUtils.getFieldValue(start, 2);
        int endYear = DateUtils.getFieldValue(end, 1);
        int endMonth = DateUtils.getFieldValue(end, 2);
        result = (endYear - startYear) * 12 + endMonth - startMonth;
        return result;
    }

    public static int getDaysOfMonth(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, 1);
        return calendar.getActualMaximum(5);
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    public static int dateCompare(Date date1, Date date2) {
        int dateLastIntVal;
        SimpleDateFormat dateFormat = new SimpleDateFormat(YMD);
        String dateFirst = dateFormat.format(date1);
        String dateLast = dateFormat.format(date2);
        int dateFirstIntVal = Integer.parseInt(dateFirst);
        if (dateFirstIntVal > (dateLastIntVal = Integer.parseInt(dateLast))) {
            return 1;
        }
        if (dateFirstIntVal < dateLastIntVal) {
            return -1;
        }
        return 0;
    }

    public static int diffYears(Date start, Date end) {
        int years = 0;
        int endYear = DateUtils.getFieldValue(end, 1);
        int startYear = DateUtils.getFieldValue(start, 1);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(start);
        calendar.add(1, endYear - startYear);
        Date startThisYear = calendar.getTime();
        years = end.compareTo(startThisYear) >= 0 ? endYear - startYear : endYear - startYear - 1;
        return years;
    }

    public static Date toDateStart(Date endDate) {
        if (endDate == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(endDate);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        return c.getTime();
    }

    public static Date toDateEnd(Date endDate) {
        if (endDate == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(endDate);
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        return c.getTime();
    }

    public static Date getCurrYearLast(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        calendar.roll(6, -1);
        Date currYearLast = calendar.getTime();
        return currYearLast;
    }

    public static Date getDateByDay(Date date, Integer day) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, day);
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        return c.getTime();
    }

    public static Date getDateByValue(Date date, Integer hour) {
        return DateUtils.getDateByValue(date, hour, 0);
    }

    public static Date getDateByValue(Date date, Integer hour, Integer minute) {
        if (hour == null) {
            hour = 0;
        }
        if (minute == null) {
            minute = 0;
        }
        Date newDate = new Date();
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(10, hour);
        c.set(12, minute);
        newDate.setTime(c.getTimeInMillis());
        return newDate;
    }

    public static int getFieldValue(Date date, int field) {
        int fieldValue = 0;
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        fieldValue = c.get(field);
        return fieldValue;
    }

    public static String getDateUnitYear(Date date) {
        if (null != date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            String year = String.valueOf(calendar.get(1));
            return year;
        }
        return null;
    }

    public static Date getMonthLastDays(int month) {
        Calendar a = Calendar.getInstance();
        a.setTime(new Date());
        a.add(2, month);
        a.set(5, 1);
        a.roll(5, -1);
        return a.getTime();
    }

    public static void main(String[] args) throws ParseException {
        String dateStr = "2021-02-28 00:00:00";
        Date date = DateUtils.strToDate(dateStr);
        Date expiredManualDate = DateUtils.getExpiredManualDate(date);
        System.out.println("expiredManualDate = " + DateUtils.dateToStr(expiredManualDate, Y_TO_SEC));
    }

    public static Integer[] diffMonthsAndDays(Date startDate, Date endDate) {
        int monthValues = 0;
        int dayValues = 0;
        if (startDate != null && endDate != null) {
            int startYear = DateUtils.getFieldValue(startDate, 1);
            int startMonth = DateUtils.getFieldValue(startDate, 2) + 1;
            int startDay = DateUtils.getFieldValue(startDate, 5);
            int endYear = DateUtils.getFieldValue(endDate, 1);
            int endMonth = DateUtils.getFieldValue(endDate, 2) + 1;
            int endDay = DateUtils.getFieldValue(endDate, 5);
            LocalDate oldDate = LocalDate.of(startYear, startMonth, startDay);
            LocalDate today = LocalDate.of(endYear, endMonth, endDay);
            Period p = Period.between(oldDate, today);
            int yearValues = p.getYears();
            monthValues = yearValues * 12 + p.getMonths();
            dayValues = p.getDays();
            if (dayValues == 1 && endDay == 1 && today.minusDays(1L).getDayOfMonth() != startDay) {
                dayValues = 0;
            }
        }
        return new Integer[]{monthValues, dayValues};
    }

    public static Date transformExpiryDay(Date expiryDate) {
        int expiryHour = DateUtils.getFieldValue(expiryDate, 11);
        int expiryMinute = DateUtils.getFieldValue(expiryDate, 12);
        int expirySecond = DateUtils.getFieldValue(expiryDate, 13);
        if (expiryHour == 23 && expiryMinute == 59 && expirySecond == 59) {
            expiryDate = DateUtils.addSecond(expiryDate, 1);
        }
        return expiryDate;
    }

    public static Integer getCoverPeriods(Date expiryDate, Date commDate, String unit) {
        if (commDate == null || expiryDate == null || StringUtils.isBlank((CharSequence)unit)) {
            return null;
        }
        int expiryHour = DateUtils.getFieldValue(expiryDate, 11);
        int expiryMinute = DateUtils.getFieldValue(expiryDate, 12);
        int expirySecond = DateUtils.getFieldValue(expiryDate, 13);
        if (expiryHour == 23 && expiryMinute == 59 && expirySecond == 59) {
            expiryDate = DateUtils.addSecond(expiryDate, 1);
        }
        return switch (unit) {
            case DATE_UNIT_DAY -> DateUtils.compareDays(expiryDate, commDate);
            case DATE_UNIT_MONTH -> DateUtils.diffMonths(commDate, expiryDate);
            case DATE_UNIT_YEAR -> DateUtils.diffYears(commDate, expiryDate);
            default -> null;
        };
    }

    public static Date getExpiredManualDate(Date manualDate) {
        if (null == manualDate) {
            return null;
        }
        String str = DateUtils.dateToStr(manualDate, Y_TO_DAY);
        String substring = str.substring(5);
        if (specialDate.contains(substring)) {
            Date date = DateUtils.addMonths(manualDate, 1);
            return DateUtils.addDays(date, -1);
        }
        Date date = DateUtils.addDays(manualDate, -1);
        return DateUtils.addMonths(date, 1);
    }

    public static Date getLatestDate(Date ... dates) {
        if (dates == null || dates.length == 0) {
            return null;
        }
        Date orgDate = dates[0];
        if (orgDate == null) {
            return null;
        }
        for (int i = 1; i < dates.length; ++i) {
            Date date = dates[i];
            if (date == null) {
                return null;
            }
            if (!date.after(orgDate)) continue;
            orgDate = date;
        }
        return orgDate;
    }

    public static Date getEarliestDate(Date ... dates) {
        if (dates == null || dates.length == 0) {
            return null;
        }
        Date orgDate = dates[0];
        if (orgDate == null) {
            return null;
        }
        for (int i = 1; i < dates.length; ++i) {
            Date date = dates[i];
            if (date == null) {
                return null;
            }
            if (!date.before(orgDate)) continue;
            orgDate = date;
        }
        return orgDate;
    }

    public static Date getNonNullDate(Date ... dates) {
        if (dates == null || dates.length == 0) {
            return null;
        }
        for (Date date : dates) {
            if (date == null) continue;
            return date;
        }
        return null;
    }

    public static Date toYearEnd(int year) {
        return DateUtils.toDateEnd(DateUtils.getCurrYearLast(year));
    }
}

