/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.hw.support.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Arrays;

public class DecimalUtils {
    public static final BigDecimal ZERO = BigDecimal.ZERO;
    public static final BigDecimal ONE_HUNDRED = new BigDecimal("100.00");
    public static final BigDecimal NIL = new BigDecimal("101");
    public static final String ADD_SUB_FLAG_BY_PLUS = "+";
    public static final String ADD_SUB_FLAG_BY_MINUS = "-";
    public static final int NORMAL_SCALE = 2;

    public static BigDecimal changePercentage(BigDecimal percent) {
        return DecimalUtils.multiply(percent, ONE_HUNDRED);
    }

    public static BigDecimal changePercentPoint(BigDecimal percent) {
        if (DecimalUtils.isNullOrZero(percent)) {
            return BigDecimal.ZERO;
        }
        return DecimalUtils.divide(percent, ONE_HUNDRED, 4);
    }

    public static BigDecimal getMaxNumber(BigDecimal ... numList) {
        Arrays.sort(numList);
        return numList[numList.length - 1];
    }

    public static BigDecimal getMinNumber(BigDecimal ... numList) {
        Arrays.sort(numList);
        return numList[0];
    }

    public static BigDecimal nullToZero(Object obj) {
        if (obj == null) {
            obj = ZERO;
        }
        return new BigDecimal(obj.toString());
    }

    public static BigDecimal nullToZero(Number obj) {
        if (obj == null) {
            obj = ZERO;
        }
        return new BigDecimal(obj.toString());
    }

    public static BigDecimal nullToZero(BigDecimal obj) {
        if (obj == null) {
            obj = ZERO;
        }
        return obj;
    }

    public static BigDecimal nullToDefault(Object obj, BigDecimal defaultValue) {
        if (obj == null) {
            obj = defaultValue;
        }
        return new BigDecimal(obj.toString());
    }

    public static BigDecimal nullToDefault(BigDecimal obj, BigDecimal defaultValue) {
        if (obj == null) {
            obj = defaultValue;
        }
        return obj;
    }

    public static BigDecimal round(BigDecimal obj, int scale) {
        if (obj == null) {
            return null;
        }
        return obj.setScale(scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal round(BigDecimal obj) {
        return DecimalUtils.round(obj, 2);
    }

    public static BigDecimal subtract(BigDecimal b1, BigDecimal b2) {
        if (b1 == null || b2 == null) {
            return null;
        }
        return new BigDecimal("" + b1.doubleValue()).subtract(new BigDecimal("" + b2.doubleValue()));
    }

    public static BigDecimal subtract(BigDecimal ... bigDecimals) {
        if (bigDecimals == null || bigDecimals.length == 0) {
            return null;
        }
        BigDecimal balance = bigDecimals[0];
        if (bigDecimals.length == 1) {
            return balance;
        }
        for (int i = 1; i < bigDecimals.length; ++i) {
            BigDecimal bigDecimal = bigDecimals[i];
            if (bigDecimal == null) {
                return null;
            }
            balance = DecimalUtils.subtract(balance, bigDecimal);
        }
        return balance;
    }

    public static BigDecimal add(BigDecimal ... bigDecimals) {
        if (bigDecimals == null || bigDecimals.length == 0) {
            return null;
        }
        BigDecimal sum = BigDecimal.ZERO;
        for (BigDecimal b : bigDecimals) {
            if (b == null) {
                return null;
            }
            sum = sum.add(new BigDecimal("" + b.doubleValue()));
        }
        return sum;
    }

    public static BigDecimal multiply(BigDecimal ... bigDecimals) {
        if (bigDecimals == null || bigDecimals.length == 0) {
            return null;
        }
        BigDecimal multiple = BigDecimal.ONE;
        for (BigDecimal b : bigDecimals) {
            if (b == null) {
                return null;
            }
            multiple = multiple.multiply(new BigDecimal("" + b.doubleValue()));
        }
        return multiple;
    }

    public static BigDecimal multiplyAndRound(BigDecimal ... bigDecimals) {
        if (bigDecimals == null || bigDecimals.length == 0) {
            return null;
        }
        BigDecimal multiple = BigDecimal.ONE;
        for (BigDecimal b : bigDecimals) {
            if (b == null) {
                return null;
            }
            multiple = multiple.multiply(new BigDecimal("" + b.doubleValue()));
        }
        return DecimalUtils.round(multiple);
    }

    public static BigDecimal divide(BigDecimal b1, BigDecimal b2) {
        if (b1 == null || b2 == null) {
            return null;
        }
        if (b2.equals(BigDecimal.ZERO)) {
            throw new ArithmeticException("Division undefined");
        }
        return new BigDecimal("" + b1.doubleValue()).divide(new BigDecimal("" + b2.doubleValue()));
    }

    public static BigDecimal divide(BigDecimal b1, BigDecimal b2, int scale) {
        if (b1 == null || b2 == null) {
            return null;
        }
        if (BigDecimal.ZERO.equals(b2)) {
            throw new ArithmeticException("Division undefined");
        }
        return new BigDecimal("" + b1.doubleValue()).divide(new BigDecimal("" + b2.doubleValue()), scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal divideAndRound(BigDecimal b1, BigDecimal b2) {
        return DecimalUtils.divide(b1, b2, 2);
    }

    public static BigDecimal divide(int scale, BigDecimal ... bigDecimals) {
        if (bigDecimals == null || bigDecimals.length == 0) {
            return null;
        }
        BigDecimal divisor = bigDecimals[0];
        if (bigDecimals.length == 1) {
            return divisor;
        }
        BigDecimal dividend = DecimalUtils.multiply(Arrays.copyOfRange(bigDecimals, 1, bigDecimals.length));
        if (dividend == null) {
            return null;
        }
        if (BigDecimal.ZERO.equals(dividend)) {
            throw new ArithmeticException("Division undefined");
        }
        return DecimalUtils.divide(divisor, dividend, scale);
    }

    public static BigDecimal toDecimal(Number number) {
        if (number == null) {
            return null;
        }
        return new BigDecimal(number.toString());
    }

    public static boolean isNullOrZero(BigDecimal b) {
        return ZERO.compareTo(DecimalUtils.nullToZero(b)) == 0;
    }

    public static void main(String[] args) {
        BigDecimal a = new BigDecimal(87.5);
        BigDecimal b = new BigDecimal(0.15);
        BigDecimal c = new BigDecimal(87.5);
        a.add(b);
        System.err.println(b);
        System.err.println(a.subtract(b));
        System.err.println(DecimalUtils.subtract(a, b));
        System.err.println(a.multiply(b));
        System.err.println(DecimalUtils.multiply(a, b));
        System.err.println(DecimalUtils.getMaxNumber(a, b, c));
    }

    public static int getAddSubFlagToCoefficByInt(String subFlag) {
        if (ADD_SUB_FLAG_BY_PLUS.equals(subFlag)) {
            return 1;
        }
        return -1;
    }

    public static BigDecimal getAddSubFlagToCoefficByBigDe(String subFlag) {
        if (ADD_SUB_FLAG_BY_PLUS.equals(subFlag)) {
            return BigDecimal.ONE;
        }
        return BigDecimal.ONE.negate();
    }

    public static String formatNumber(BigDecimal bigDecimal) {
        DecimalFormat decimalFormat = new DecimalFormat("#,##0.00");
        return decimalFormat.format(bigDecimal);
    }
}

