/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.hw.support.util.excel.utils;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaError;
import org.apache.poi.ss.usermodel.FormulaEvaluator;

public class ExcelUtil {
    public static Object getCellValue(Cell cell, Class targetClass) {
        if (cell == null) {
            return null;
        }
        switch (cell.getCellType()) {
            case STRING: {
                return cell.getStringCellValue();
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    return cell.getDateCellValue();
                }
                if (targetClass != null && CharSequence.class.isAssignableFrom(targetClass)) {
                    return Double.valueOf(cell.getNumericCellValue()).intValue();
                }
                return cell.getNumericCellValue();
            }
            case BOOLEAN: {
                return cell.getBooleanCellValue();
            }
            case FORMULA: {
                return ExcelUtil.evaluateFormulaCell(cell);
            }
            case BLANK: {
                return "";
            }
            case ERROR: {
                return FormulaError.forInt((byte)cell.getErrorCellValue()).getString();
            }
        }
        return null;
    }

    private static Object evaluateFormulaCell(Cell cell) {
        FormulaEvaluator evaluator = cell.getSheet().getWorkbook().getCreationHelper().createFormulaEvaluator();
        CellValue cellValue = evaluator.evaluate(cell);
        switch (cellValue.getCellType()) {
            case STRING: {
                return cellValue.getStringValue();
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    return cell.getDateCellValue();
                }
                return cellValue.getNumberValue();
            }
            case BOOLEAN: {
                return cellValue.getBooleanValue();
            }
            case ERROR: {
                return FormulaError.forInt((byte)cellValue.getErrorValue()).getString();
            }
        }
        return null;
    }

    public static String getColumnLabel(int columnNumber) {
        StringBuilder sb = new StringBuilder();
        while (columnNumber > 0) {
            int remainder = (columnNumber - 1) % 26;
            char ch = (char)(65 + remainder);
            sb.insert(0, ch);
            columnNumber = (columnNumber - 1) / 26;
        }
        return sb.toString();
    }
}

