/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.hw.support.util.excel.utils;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class StringToTypeConverterUtils {
    public static Object convert(String str, Class<?> clazz) throws Exception {
        if (clazz == String.class || clazz == CharSequence.class) {
            return str;
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return StringToTypeConverterUtils.toInt(str);
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return StringToTypeConverterUtils.toDouble(str);
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return StringToTypeConverterUtils.toBoolean(str);
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return StringToTypeConverterUtils.toLong(str);
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return Float.valueOf(StringToTypeConverterUtils.toFloat(str));
        }
        if (clazz == Short.class || clazz == Short.TYPE) {
            return StringToTypeConverterUtils.toShort(str);
        }
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            return StringToTypeConverterUtils.toByte(str);
        }
        if (clazz == Character.class || clazz == Character.TYPE) {
            return Character.valueOf(StringToTypeConverterUtils.toChar(str));
        }
        if (clazz == BigDecimal.class) {
            return StringToTypeConverterUtils.toBigDecimal(str);
        }
        if (clazz == Date.class) {
            return StringToTypeConverterUtils.parseDate(str);
        }
        if (clazz == List.class) {
            return StringToTypeConverterUtils.toList(str);
        }
        if (clazz.isArray()) {
            Class<?> componentType = clazz.getComponentType();
            if (componentType == Integer.TYPE) {
                return StringToTypeConverterUtils.toIntArray(str);
            }
            if (componentType == Double.TYPE) {
                return StringToTypeConverterUtils.toDoubleArray(str);
            }
            if (componentType == Boolean.TYPE) {
                return StringToTypeConverterUtils.toBooleanArray(str);
            }
        }
        throw new IllegalArgumentException("Unsupported class type: " + clazz.getName());
    }

    public static Integer toInt(String str) throws NumberFormatException {
        if (str == null || str.trim().isEmpty()) {
            return null;
        }
        return Double.valueOf(str).intValue();
    }

    public static double toDouble(String str) throws NumberFormatException {
        if (str == null || str.trim().isEmpty()) {
            throw new NumberFormatException("Null or empty string");
        }
        return Double.parseDouble(str.trim());
    }

    public static boolean toBoolean(String str) {
        if (str == null || str.trim().isEmpty()) {
            return false;
        }
        return Boolean.parseBoolean(str.trim());
    }

    public static long toLong(String str) throws NumberFormatException {
        if (str == null || str.trim().isEmpty()) {
            throw new NumberFormatException("Null or empty string");
        }
        return Long.parseLong(str.trim());
    }

    public static float toFloat(String str) throws NumberFormatException {
        if (str == null || str.trim().isEmpty()) {
            throw new NumberFormatException("Null or empty string");
        }
        return Float.parseFloat(str.trim());
    }

    public static short toShort(String str) throws NumberFormatException {
        if (str == null || str.trim().isEmpty()) {
            throw new NumberFormatException("Null or empty string");
        }
        return Short.parseShort(str.trim());
    }

    public static byte toByte(String str) throws NumberFormatException {
        if (str == null || str.trim().isEmpty()) {
            throw new NumberFormatException("Null or empty string");
        }
        return Byte.parseByte(str.trim());
    }

    public static char toChar(String str) throws IllegalArgumentException {
        if (str == null || str.trim().isEmpty()) {
            throw new IllegalArgumentException("Null or empty string");
        }
        if (str.trim().length() != 1) {
            throw new IllegalArgumentException("String length is not 1");
        }
        return str.trim().charAt(0);
    }

    public static <T extends Enum<T>> T toEnum(String str, Class<T> enumType) {
        if (str == null || str.trim().isEmpty()) {
            throw new IllegalArgumentException("Null or empty string");
        }
        return Enum.valueOf(enumType, str.trim());
    }

    public static Date toDate(String str, String dateFormat) throws ParseException {
        if (str == null || str.trim().isEmpty()) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        return sdf.parse(str.trim());
    }

    public static BigDecimal toBigDecimal(String str) throws NumberFormatException {
        if (str == null || str.trim().isEmpty()) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(str.trim());
    }

    public static List<String> toList(String str) {
        if (str == null || str.trim().isEmpty()) {
            return new ArrayList<String>();
        }
        return Arrays.asList(str.trim().split("\\s*,\\s*"));
    }

    public static int[] toIntArray(String str) throws NumberFormatException {
        if (str == null || str.trim().isEmpty()) {
            return new int[0];
        }
        String[] parts = str.trim().split("\\s*,\\s*");
        int[] intArray = new int[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            intArray[i] = Integer.parseInt(parts[i]);
        }
        return intArray;
    }

    public static double[] toDoubleArray(String str) throws NumberFormatException {
        if (str == null || str.trim().isEmpty()) {
            return new double[0];
        }
        String[] parts = str.trim().split("\\s*,\\s*");
        double[] doubleArray = new double[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            doubleArray[i] = Double.parseDouble(parts[i]);
        }
        return doubleArray;
    }

    public static boolean[] toBooleanArray(String str) {
        if (str == null || str.trim().isEmpty()) {
            return new boolean[0];
        }
        String[] parts = str.trim().split("\\s*,\\s*");
        boolean[] booleanArray = new boolean[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            booleanArray[i] = Boolean.parseBoolean(parts[i]);
        }
        return booleanArray;
    }

    public static Date parseDate(String dateString) throws ParseException {
        String[] formats;
        if (dateString == null || dateString.trim().isEmpty()) {
            return null;
        }
        for (String format : formats = new String[]{"yyyy-MM-dd'T'HH:mm:ss'Z'", "yyyy-MM-dd'T'HH:mm:ssXXX", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd", "MM/dd/yyyy HH:mm:ss", "MM/dd/yyyy", "dd/MM/yyyy HH:mm:ss", "dd/MM/yyyy", "yyyy/MM/dd", "dd-MMM-yyyy", "HH:mm:ss", "hh:mm:ss a"}) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(format);
                return sdf.parse(dateString);
            }
            catch (ParseException parseException) {
            }
        }
        throw new ParseException("Unparseable date: " + dateString, 0);
    }
}

