/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.hw.support.util.excel.utils;

import com.cntaiping.hw.support.util.excel.xls.XlsCell;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.reflections.Configuration;
import org.reflections.ReflectionUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ConfigurationBuilder;

public class XlsAnnotationUtils {
    private static Map<String, Field> fieldCache = new HashMap<String, Field>();

    public static <T extends Annotation> List<T> getAllInitAnnotations(String[] basePackages, Class<T> tClass) {
        ArrayList<T> result = new ArrayList<T>();
        for (Class<?> annotatedClass : XlsAnnotationUtils.getAllClassWithAnnotation(basePackages, tClass)) {
            result.add(annotatedClass.getAnnotation(tClass));
        }
        return result;
    }

    public static <T extends Annotation> List<Class<?>> getAllClassWithAnnotation(String[] basePackages, Class<T> tClass) {
        ArrayList list = new ArrayList();
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().forPackages(basePackages).addScanners(new Scanner[]{new TypeAnnotationsScanner()}));
        Set annotatedClasses = reflections.getTypesAnnotatedWith(tClass);
        return annotatedClasses.stream().toList();
    }

    public static void setAnnotationValue1(Annotation annotation, String key, Object newValue) {
        try {
            InvocationHandler handler = Proxy.getInvocationHandler(annotation);
            Field memberValuesField = handler.getClass().getDeclaredField("memberValues");
            memberValuesField.setAccessible(true);
            Map memberValues = (Map)memberValuesField.get(handler);
            memberValues.put(key, newValue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setFieldValue(Object object, String fieldName, Object newValue) {
        if (object == null) {
            return;
        }
        try {
            XlsAnnotationUtils.getField(object.getClass(), fieldName).set(object, newValue);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static String buildSetterName(String fieldName) {
        return "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    public static String buildGetterName(String fieldName) {
        return "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    public static Method getSetterMethod(Class<?> clazz, String propertyName) {
        if (propertyName == null || "".equals(propertyName)) {
            throw new RuntimeException("propertyName is null!");
        }
        String methodName = "set" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        return Arrays.stream(clazz.getDeclaredMethods()).filter(e -> e.getName().equals(methodName)).findFirst().orElse(null);
    }

    public static Method getGetterMethod(Class<?> clazz, String propertyName) {
        if (propertyName == null || "".equals(propertyName)) {
            throw new RuntimeException("propertyName is null!");
        }
        String methodName = "get" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        return Arrays.stream(clazz.getDeclaredMethods()).filter(e -> e.getName().equals(methodName)).findFirst().orElse(null);
    }

    public static <T> T getFieldValue(Object o, String fieldName, Class<T> tClass) {
        try {
            Field secretField = Arrays.stream(o.getClass().getDeclaredFields()).filter(e -> e.getName().equals(fieldName)).findAny().orElse(null);
            secretField.setAccessible(true);
            Object secretValue = secretField.get(o);
            return (T)secretValue;
        }
        catch (IllegalAccessException e2) {
            throw new RuntimeException(e2);
        }
    }

    public static Object initField(Object targetObj, Field field, Method setMethod, Method getMethod, Integer index) {
        try {
            Object targetFiledObj = null;
            boolean newFlag = false;
            if (getMethod != null) {
                targetFiledObj = getMethod.invoke(targetObj, new Object[0]);
            } else if (field != null) {
                targetFiledObj = field.get(targetObj);
            }
            if (targetFiledObj == null && field != null) {
                targetFiledObj = XlsAnnotationUtils.newInstance(field.getType());
                newFlag = true;
                if (setMethod != null) {
                    setMethod.invoke(targetObj, targetFiledObj);
                } else if (field != null) {
                    field.set(targetObj, targetFiledObj);
                }
            }
            if (newFlag && field != null && Collection.class.isAssignableFrom(field.getType())) {
                Type genericType = field.getGenericType();
                ParameterizedType pt = (ParameterizedType)genericType;
                Class collectionClassType = (Class)pt.getActualTypeArguments()[0];
                Object collectionObj = XlsAnnotationUtils.newInstance(collectionClassType);
                ((Collection)targetFiledObj).add(collectionObj);
            }
            return targetFiledObj;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setFileValue(Object targetObj, Object fieldValue, Field field, Method setMethod, Field innerSheetField, Method innerSetMethod, Integer index) {
        try {
            if (innerSetMethod != null || innerSheetField != null) {
                Object realObj = targetObj;
                if (index != null && targetObj instanceof Collection) {
                    while (((Collection)targetObj).size() <= index) {
                        Object collectionObj = XlsAnnotationUtils.newInstance(innerSheetField.getDeclaringClass());
                        ((Collection)targetObj).add(collectionObj);
                    }
                    if (targetObj instanceof Set) {
                        realObj = ((Set)targetObj).toArray()[index];
                    } else if (targetObj instanceof List) {
                        realObj = ((List)targetObj).get(index);
                    }
                    if (innerSetMethod != null) {
                        innerSetMethod.invoke(realObj, fieldValue);
                    } else if (innerSheetField != null) {
                        innerSheetField.set(realObj, fieldValue);
                    }
                } else if (innerSetMethod != null) {
                    innerSetMethod.invoke(realObj, fieldValue);
                } else if (innerSheetField != null) {
                    innerSheetField.set(realObj, fieldValue);
                }
            } else {
                Object realObj = targetObj;
                if (index != null && Collection.class.isAssignableFrom(targetObj.getClass())) {
                    while (((Collection)targetObj).size() <= index) {
                        Type genericType = field.getGenericType();
                        ParameterizedType pt = (ParameterizedType)genericType;
                        Class collectionClassType = (Class)pt.getActualTypeArguments()[0];
                        Object collectionObj = XlsAnnotationUtils.newInstance(collectionClassType);
                        ((Collection)targetObj).add(collectionObj);
                    }
                    if (targetObj instanceof Set) {
                        realObj = ((Set)targetObj).toArray()[index];
                    } else if (targetObj instanceof List) {
                        realObj = ((List)targetObj).get(index);
                    }
                    if (setMethod != null) {
                        setMethod.invoke(realObj, fieldValue);
                    } else if (field != null) {
                        field.set(realObj, fieldValue);
                    }
                } else if (setMethod != null) {
                    setMethod.invoke(realObj, fieldValue);
                } else if (field != null) {
                    field.set(realObj, fieldValue);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T fieldValueForJdk12(Object o, String fieldName, Class<T> tClass) {
        if (o == null) {
            return null;
        }
        try {
            return (T)XlsAnnotationUtils.getField(o.getClass(), fieldName).get(o);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static Class fieldCollectionRealType(Field field) {
        if (Collection.class.isAssignableFrom(field.getType())) {
            Type genericType = field.getGenericType();
            ParameterizedType pt = (ParameterizedType)genericType;
            return (Class)pt.getActualTypeArguments()[0];
        }
        return null;
    }

    private static Field getField(Class clazz, String fieldName) {
        String key = clazz.getName() + "." + fieldName;
        return fieldCache.computeIfAbsent(key, k -> {
            try {
                Field[] fields = clazz.getDeclaredFields();
                Field modifiersField = null;
                for (Field each : fields) {
                    if (!fieldName.equals(each.getName())) continue;
                    modifiersField = each;
                    break;
                }
                modifiersField.setAccessible(true);
                return modifiersField;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static boolean fieldContainsXlsCell(Class clazz) {
        return ReflectionUtils.getAllFields((Class)clazz, (Predicate[])new Predicate[0]).stream().anyMatch(f -> f.isAnnotationPresent(XlsCell.class));
    }

    public static Field getFieldByName(Class<?> clazz, String field) {
        Field field1 = ReflectionUtils.getAllFields(clazz, (Predicate[])new Predicate[0]).stream().filter(f -> f.getName().equals(field)).findFirst().orElse(null);
        if (field1 != null) {
            field1.setAccessible(true);
        }
        return field1;
    }

    public static boolean isNotEmptyStr(String toFieldName) {
        return toFieldName != null && !"".equals(toFieldName.trim());
    }

    public static Object getFieldValue(Object targetObj, Field field, Method getMethod, Field innerField, Method innerGetMethod, Integer innerIndex) {
        block14: {
            try {
                Object result = null;
                if (getMethod != null) {
                    result = getMethod.invoke(targetObj, new Object[0]);
                } else if (field != null) {
                    result = field.get(targetObj);
                }
                if (null == result) {
                    return null;
                }
                if (result instanceof List) {
                    if (innerIndex != null && innerIndex >= 0 && innerIndex < ((List)result).size()) {
                        result = ((List)result).get(innerIndex);
                        if (innerGetMethod != null) {
                            result = innerGetMethod.invoke(result, new Object[0]);
                        } else if (innerField != null) {
                            result = innerField.get(result);
                        }
                        return result;
                    }
                    break block14;
                }
                if (innerGetMethod != null) {
                    result = innerGetMethod.invoke(result, new Object[0]);
                } else if (innerField != null) {
                    result = innerField.get(result);
                }
                return result;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static Object newInstance(Class clazz) {
        if (clazz == List.class) {
            return new ArrayList();
        }
        if (clazz == Map.class) {
            return new HashMap();
        }
        if (clazz == Set.class) {
            return new HashSet();
        }
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

