/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.hw.support.util.excel.utils;

import com.cntaiping.fsc.common.util.Commons;
import com.cntaiping.hw.support.util.excel.dbconfig.DbAnnotationConfig;
import com.cntaiping.hw.support.util.excel.dbconfig.DbAnnotationMemberConfig;
import com.cntaiping.hw.support.util.excel.dbconfig.DbCellConfig;
import com.cntaiping.hw.support.util.excel.dbconfig.DbExcelConfig;
import com.cntaiping.hw.support.util.excel.dbconfig.DbSheetConfig;
import com.cntaiping.hw.support.util.excel.service.XlsAnnotationParseService;
import com.cntaiping.hw.support.util.excel.utils.CommonTypeCheckerUtils;
import com.cntaiping.hw.support.util.excel.utils.ExcelUtil;
import com.cntaiping.hw.support.util.excel.utils.GenericComparator;
import com.cntaiping.hw.support.util.excel.utils.StringToTypeConverterUtils;
import com.cntaiping.hw.support.util.excel.utils.XlsAnnotationUtils;
import com.cntaiping.hw.support.util.excel.xls.XlsAnnotationParse;
import com.cntaiping.hw.support.util.excel.xls.XlsCell;
import com.cntaiping.hw.support.util.excel.xls.XlsExcel;
import com.cntaiping.hw.support.util.excel.xls.XlsIgnore;
import com.cntaiping.hw.support.util.excel.xls.XlsIndex;
import com.cntaiping.hw.support.util.excel.xls.XlsSheet;
import com.cntaiping.hw.support.util.excel.xls.XlsStyleHead;
import com.cntaiping.hw.support.util.excel.xls.XlsValidation;
import com.cntaiping.hw.support.util.excel.xls.config.ColumnValidation;
import com.cntaiping.hw.support.util.excel.xls.config.CusTransform;
import com.cntaiping.hw.support.util.excel.xls.config.CusValidation;
import com.cntaiping.hw.support.util.excel.xls.config.HeadStyle;
import com.cntaiping.hw.support.util.excel.xls.config.XlsCellConfig;
import com.cntaiping.hw.support.util.excel.xls.config.XlsExcelConfig;
import com.cntaiping.hw.support.util.excel.xls.config.XlsSheetConfig;
import com.cntaiping.sg.tpsgi.underwriting.quotation.vo.GuQuotMainVo;
import com.cntaiping.sg.tpsgi.underwriting.quotation.vo.GuQuotRiInwardVo;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.SignatureAttribute;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.ByteMemberValue;
import javassist.bytecode.annotation.CharMemberValue;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.DoubleMemberValue;
import javassist.bytecode.annotation.EnumMemberValue;
import javassist.bytecode.annotation.FloatMemberValue;
import javassist.bytecode.annotation.IntegerMemberValue;
import javassist.bytecode.annotation.LongMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.ShortMemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.reflections.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class XlsGlobalUtils {
    private static final Logger LOG = LoggerFactory.getLogger(XlsGlobalUtils.class);
    public static final String EXCEL_BASE_INFO_SHEET = "base-info";
    public static Map<String, List<Map<String, String>>> allCategories = new HashMap<String, List<Map<String, String>>>();
    public static Map<Class<?>, byte[]> allTemplateCaches = new HashMap();
    public static Map<Class<?>, XlsExcelConfig> allExcelConfigs = new HashMap();
    public static Map<String, HeadStyle> headStyleMap = new HashMap<String, HeadStyle>();
    public static Map<String, ColumnValidation> validationMap = new HashMap<String, ColumnValidation>();
    public static Map<Class<? extends java.lang.annotation.Annotation>, List<XlsAnnotationParseService>> parseService = new HashMap<Class<? extends java.lang.annotation.Annotation>, List<XlsAnnotationParseService>>();
    private static final Validator validator;
    private static JdbcTemplate jdbcTemplate;

    public static void initJdbcTemplate(JdbcTemplate jt) {
        jdbcTemplate = jt;
    }

    public static void loadStyleAndValidation(String[] basePackages) {
        List<Class<?>> allStyles = XlsAnnotationUtils.getAllClassWithAnnotation(basePackages, XlsStyleHead.class);
        for (Class<?> styleClass : allStyles) {
            if (!HeadStyle.class.isAssignableFrom(styleClass)) continue;
            HeadStyle o = null;
            try {
                o = (HeadStyle)styleClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            headStyleMap.put(o.getName(), o);
        }
        List<Class<?>> allValidations = XlsAnnotationUtils.getAllClassWithAnnotation(basePackages, XlsValidation.class);
        for (Class<?> validation : allValidations) {
            if (!ColumnValidation.class.isAssignableFrom(validation)) continue;
            ColumnValidation o = null;
            try {
                o = (ColumnValidation)validation.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            validationMap.put(o.getName(), o);
        }
    }

    public static void loadAnnotationParse(String[] basePackages) {
        List<Class<?>> annotationParse = XlsAnnotationUtils.getAllClassWithAnnotation(basePackages, XlsAnnotationParse.class);
        for (Class<?> parser : annotationParse) {
            if (!XlsAnnotationParseService.class.isAssignableFrom(parser)) continue;
            XlsAnnotationParseService o = null;
            try {
                o = (XlsAnnotationParseService)parser.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            parseService.computeIfAbsent(o.getAnnotation(), k -> new ArrayList()).add(o);
        }
    }

    public static void init(List<Class<?>> allXlsExcel) {
        HashMap<String, Boolean> dubCheckMap = new HashMap<String, Boolean>();
        for (Class<?> excelClass : allXlsExcel) {
            XlsExcel xlsExcel = excelClass.getAnnotation(XlsExcel.class);
            XlsExcelConfig xlsExcelConfig = new XlsExcelConfig(xlsExcel);
            XlsAnnotationUtils.setFieldValue(xlsExcelConfig, "bindClass", excelClass);
            allExcelConfigs.put(excelClass, xlsExcelConfig);
            CharSequence[] categoryDefs = xlsExcel.category();
            String fullCategoryName = String.join((CharSequence)",", categoryDefs);
            if (dubCheckMap.containsKey(fullCategoryName)) {
                throw new RuntimeException("\u91cd\u590d\u7684\u914d\u7f6e\u7c7b\u578b: " + fullCategoryName);
            }
            dubCheckMap.put(fullCategoryName, true);
            for (CharSequence category : categoryDefs) {
                Map<String, String> newCategory;
                String[] split = ((String)category).split("\\|");
                String type = split[0];
                List categoryList = allCategories.computeIfAbsent(type, k -> new ArrayList());
                if (categoryList.contains(newCategory = Map.of(split[1], split[2]))) continue;
                categoryList.add(newCategory);
            }
            List<XlsSheetConfig> xlsSheets = xlsExcelConfig.sheetConfigs();
            if (excelClass.isAnnotationPresent(XlsSheet.class)) {
                XlsSheet xlsSheet = excelClass.getAnnotation(XlsSheet.class);
                XlsSheetConfig xlsSheetConfig = new XlsSheetConfig(xlsSheet);
                xlsSheetConfig.fieldRealTypeClass(excelClass);
                xlsSheetConfig.ownerClass(excelClass);
                xlsSheetConfig.field(null);
                xlsSheetConfig.setMethod(null);
                xlsSheetConfig.getMethod(null);
                xlsSheets.add(xlsSheetConfig);
                XlsGlobalUtils.initSheetCells(excelClass, xlsSheetConfig);
            } else {
                ArrayList allFields = new ArrayList(ReflectionUtils.getAllFields(excelClass, (Predicate[])new Predicate[]{f -> {
                    if (f.isAnnotationPresent(XlsIgnore.class)) {
                        return false;
                    }
                    f.setAccessible(true);
                    Class aClass = XlsAnnotationUtils.fieldCollectionRealType(f);
                    if (aClass != null) {
                        return aClass.isAnnotationPresent(XlsSheet.class);
                    }
                    return f.getType().isAnnotationPresent(XlsSheet.class);
                }}));
                for (Field sheetField : allFields) {
                    Class<?> realClass;
                    if (sheetField.isAnnotationPresent(XlsIgnore.class)) continue;
                    Class<?> sheetFieldClassType = sheetField.getType();
                    if (Set.class.isAssignableFrom(sheetFieldClassType) || Map.class.isAssignableFrom(sheetFieldClassType)) {
                        throw new RuntimeException(" set map not supported now ");
                    }
                    Class<?> fileRealClass = XlsAnnotationUtils.fieldCollectionRealType(sheetField);
                    if (fileRealClass == null) {
                        fileRealClass = sheetField.getType();
                    }
                    XlsSheet xlsSheet = fileRealClass.getAnnotation(XlsSheet.class);
                    XlsSheetConfig xlsSheetConfig = new XlsSheetConfig(xlsSheet);
                    xlsSheets.add(xlsSheetConfig);
                    xlsSheetConfig.fieldRealTypeClass(fileRealClass);
                    xlsSheetConfig.field(sheetField);
                    xlsSheetConfig.ownerClass(excelClass);
                    xlsSheetConfig.setMethod(XlsAnnotationUtils.getSetterMethod(excelClass, sheetField.getName()));
                    xlsSheetConfig.getMethod(XlsAnnotationUtils.getGetterMethod(excelClass, sheetField.getName()));
                    if (sheetField.isAnnotationPresent(XlsIndex.class)) {
                        xlsSheetConfig.index(sheetField.getAnnotation(XlsIndex.class).index());
                    }
                    if (Collection.class.isAssignableFrom(sheetFieldClassType)) {
                        xlsSheetConfig.isCollection(true);
                    }
                    if ((realClass = XlsAnnotationUtils.fieldCollectionRealType(sheetField)) == null) {
                        realClass = sheetField.getType();
                    }
                    if (xlsSheet.parentClass() != null) {
                        if (!"".equals(xlsSheet.linkId())) {
                            xlsSheetConfig.linkId(XlsAnnotationUtils.getFieldByName(xlsSheetConfig.toClass(), xlsSheet.linkId()));
                            xlsSheetConfig.linkSetMethod(XlsAnnotationUtils.getSetterMethod(xlsSheetConfig.toClass(), xlsSheet.linkId()));
                            xlsSheetConfig.linkGetMethod(XlsAnnotationUtils.getGetterMethod(xlsSheetConfig.toClass(), xlsSheet.linkId()));
                        }
                        if (!"".equals(xlsSheet.parentContainerField())) {
                            if (xlsSheet.parentContainerField().indexOf(".") > 0) {
                                String[] split = xlsSheet.parentContainerField().split("\\.");
                                String parentField = split[0];
                                String innerField = split[1];
                                xlsSheetConfig.parentContainerField(XlsAnnotationUtils.getFieldByName(xlsSheetConfig.parentClass(), parentField));
                                xlsSheetConfig.parentContainerSetMethod(XlsAnnotationUtils.getSetterMethod(xlsSheetConfig.parentClass(), parentField));
                                xlsSheetConfig.parentContainerGetMethod(XlsAnnotationUtils.getGetterMethod(xlsSheetConfig.parentClass(), parentField));
                                Class innerClass = XlsAnnotationUtils.getFieldByName(xlsSheetConfig.parentClass(), parentField).getType();
                                if (List.class.isAssignableFrom(innerClass)) {
                                    innerClass = XlsAnnotationUtils.fieldCollectionRealType(XlsAnnotationUtils.getFieldByName(xlsSheetConfig.parentClass(), parentField));
                                }
                                xlsSheetConfig.parentInnerContainerField(XlsAnnotationUtils.getFieldByName(innerClass, innerField));
                                xlsSheetConfig.parentInnerContainerSetMethod(XlsAnnotationUtils.getSetterMethod(innerClass, innerField));
                                xlsSheetConfig.parentInnerContainerGetMethod(XlsAnnotationUtils.getGetterMethod(innerClass, innerField));
                            } else {
                                xlsSheetConfig.parentContainerField(XlsAnnotationUtils.getFieldByName(xlsSheetConfig.parentClass(), xlsSheet.parentContainerField()));
                                xlsSheetConfig.parentContainerSetMethod(XlsAnnotationUtils.getSetterMethod(xlsSheetConfig.parentClass(), xlsSheet.parentContainerField()));
                                xlsSheetConfig.parentContainerGetMethod(XlsAnnotationUtils.getGetterMethod(xlsSheetConfig.parentClass(), xlsSheet.parentContainerField()));
                            }
                        }
                        if (!"".equals(xlsSheet.parentLinkId())) {
                            xlsSheetConfig.parentLinkId(XlsAnnotationUtils.getFieldByName(xlsSheetConfig.parentClass(), xlsSheet.parentLinkId()));
                            xlsSheetConfig.parentLinkSetMethod(XlsAnnotationUtils.getSetterMethod(xlsSheetConfig.parentClass(), xlsSheet.parentLinkId()));
                            xlsSheetConfig.parentLinkGetMethod(XlsAnnotationUtils.getGetterMethod(xlsSheetConfig.parentClass(), xlsSheet.parentLinkId()));
                        }
                    }
                    XlsGlobalUtils.initSheetCells(realClass, xlsSheetConfig);
                }
            }
            xlsSheets.forEach(sheet -> {
                if (xlsSheets.stream().filter(e -> e.index() == sheet.index()).count() > 1L) {
                    throw new RuntimeException("sheet index \u91cd\u590d\uff0c\u8bf7\u4f7f\u7528@XlsIndex \u91cd\u7f6e");
                }
            });
            Collections.sort(xlsSheets, (e1, e2) -> e1.index() - e2.index());
            for (XlsSheetConfig xlsSheet : xlsSheets) {
                int headRow = xlsSheet.xlsCellConfigs().stream().map(cell -> cell.headTitle().length).max((e1, e2) -> e1.compareTo((Integer)e2)).get();
                XlsAnnotationUtils.setFieldValue(xlsSheet, "headRow", headRow);
                Collections.sort(xlsSheet.xlsCellConfigs(), (e1, e2) -> e1.index() - e2.index());
            }
        }
    }

    public static void init(String[] basePackages) {
        List<Class<?>> allXlsExcel = XlsAnnotationUtils.getAllClassWithAnnotation(basePackages, XlsExcel.class);
        XlsGlobalUtils.init(allXlsExcel);
    }

    public static void getXlsTemplate(Class<?> clazz, OutputStream outputStream) {
        byte[] xes = allTemplateCaches.computeIfAbsent(clazz, k -> {
            XSSFWorkbook workbook = new XSSFWorkbook();
            XlsExcelConfig xlsExcel = allExcelConfigs.get(clazz);
            if (xlsExcel == null) {
                return null;
            }
            List<XlsSheetConfig> xlsSheetList = xlsExcel.sheetConfigs();
            if (xlsSheetList == null) {
                return null;
            }
            for (XlsSheetConfig xlsSheet : xlsSheetList) {
                Sheet dataSheet = workbook.createSheet(xlsSheet.title());
                int sheetIndex = workbook.getSheetIndex(dataSheet);
                if (xlsSheet.sheetActive()) {
                    workbook.setActiveSheet(sheetIndex);
                }
                if (xlsSheet.hidden()) {
                    workbook.setSheetHidden(sheetIndex, true);
                }
                List<XlsCellConfig> xlsCells = xlsSheet.xlsCellConfigs();
                DataValidationHelper dataValidationHelper = dataSheet.getDataValidationHelper();
                for (int j = 0; j < xlsSheet.headRow(); ++j) {
                    Row row = dataSheet.createRow(j);
                    int cellIndex = -1;
                    for (int i = 0; i < xlsCells.size(); ++i) {
                        XlsCellConfig xlsCell = xlsCells.get(i);
                        ++cellIndex;
                        if (xlsCell.hidden().booleanValue()) {
                            --cellIndex;
                            continue;
                        }
                        Cell cell = row.createCell(cellIndex);
                        String[] headTitles = xlsCell.headTitle();
                        if (j == 0) {
                            if (xlsCell.columnWeight() > 0) {
                                dataSheet.setColumnWidth(cellIndex, xlsCell.columnWeight() * 256);
                            } else {
                                int length = 9;
                                for (String headTitle : headTitles) {
                                    if (headTitle.length() <= length) continue;
                                    length = headTitle.length();
                                }
                                dataSheet.setColumnWidth(cellIndex, length * 256);
                            }
                            CellStyle columnStyle = workbook.createCellStyle();
                            dataSheet.setDefaultColumnStyle(cellIndex, columnStyle);
                            if (!"".equals(xlsCell.format())) {
                                creationHelper = workbook.getCreationHelper();
                                columnStyle.setDataFormat(creationHelper.createDataFormat().getFormat(xlsCell.format()));
                            } else if (Number.class.isAssignableFrom(xlsCell.field().getType()) || xlsCell.innerSheetField() != null && Number.class.isAssignableFrom(xlsCell.innerSheetField().getType())) {
                                Class<?> type;
                                Class<?> clazz2 = type = xlsCell.innerSheetField() != null ? xlsCell.innerSheetField().getType() : xlsCell.field().getType();
                                if (Integer.class.isAssignableFrom(type)) {
                                    CreationHelper creationHelper = workbook.getCreationHelper();
                                    columnStyle.setDataFormat(creationHelper.createDataFormat().getFormat("#0"));
                                } else {
                                    String numberFormat = "#,##0.00";
                                    if (!"".equals(xlsCell.format())) {
                                        numberFormat = xlsCell.format();
                                    }
                                    CreationHelper creationHelper = workbook.getCreationHelper();
                                    columnStyle.setDataFormat(creationHelper.createDataFormat().getFormat(numberFormat));
                                }
                            } else if (Date.class.isAssignableFrom(xlsCell.field().getType())) {
                                String dateFormat = "yyyy/MM/dd";
                                if (!"".equals(xlsCell.format())) {
                                    dateFormat = xlsCell.format();
                                }
                                CreationHelper creationHelper = workbook.getCreationHelper();
                                columnStyle.setDataFormat(creationHelper.createDataFormat().getFormat(dateFormat));
                            } else {
                                creationHelper = workbook.getCreationHelper();
                                columnStyle.setDataFormat(creationHelper.createDataFormat().getFormat("@"));
                            }
                            if (!xlsCell.hidden().booleanValue() && xlsCell.unique().booleanValue()) {
                                String formula = "COUNTIF($A$1:$A$1048576,A1)=1";
                                CellRangeAddressList addressList = new CellRangeAddressList(0, 1048575, 0, 0);
                                DataValidationConstraint constraint = dataValidationHelper.createCustomConstraint(formula);
                                DataValidation validation = dataValidationHelper.createValidation(constraint, addressList);
                                validation.setSuppressDropDownArrow(true);
                                validation.setShowErrorBox(true);
                                validation.createErrorBox("\u91cd\u590d\u503c\u9519\u8bef", "\u6b64\u5217\u4e2d\u4e0d\u5141\u8bb8\u91cd\u590d\u503c\u3002");
                                dataSheet.addValidationData(validation);
                            }
                        }
                        int index = xlsSheet.headRow() - headTitles.length - j >= 0 ? 0 : j - (xlsSheet.headRow() - headTitles.length);
                        String value = headTitles[index];
                        cell.setCellValue(value);
                        if (cell.getCellComment() == null) {
                            Drawing drawing = dataSheet.createDrawingPatriarch();
                            CreationHelper factory = workbook.getCreationHelper();
                            ClientAnchor anchor = factory.createClientAnchor();
                            anchor.setCol1(cell.getColumnIndex());
                            anchor.setRow1(cell.getRowIndex());
                            anchor.setCol2(cell.getColumnIndex() + 2);
                            anchor.setRow2(cell.getRowIndex() + 2);
                            Comment comment = drawing.createCellComment(anchor);
                            RichTextString str = null;
                            str = xlsCell.innerSheetField() != null ? factory.createRichTextString(xlsCell.innerSheetField().getName()) : factory.createRichTextString(xlsCell.field().getName());
                            comment.setString(str);
                            comment.setAuthor("X");
                            comment.setVisible(false);
                            cell.setCellComment(comment);
                        }
                        if (!xlsCell.headStyle().equals("")) {
                            try {
                                HeadStyle headStyle = headStyleMap.get(xlsCell.headStyle());
                                if (headStyle != null) {
                                    CellStyle cellStyle = headStyle.headStyle(dataSheet);
                                    cell.setCellStyle(cellStyle);
                                }
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }
                        if (j != xlsSheet.headRow() - 1 || xlsCell.validation().equals("")) continue;
                        try {
                            ColumnValidation columnValidation = validationMap.get(xlsCell.validation());
                            if (columnValidation == null) continue;
                            columnValidation.validation((Workbook)workbook, dataSheet, xlsSheet.headRow(), 100000, cell.getColumnIndex(), cell.getColumnIndex());
                            continue;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                int lastRowNum = dataSheet.getLastRowNum();
                int cellIndex = 0;
                for (XlsCellConfig xlsCell : xlsCells) {
                    ++cellIndex;
                    if (xlsCell.dropdown().length <= 0) continue;
                    DataValidationHelper validationHelper = dataValidationHelper;
                    String[] dropdownValues = xlsCell.dropdown();
                    DataValidationConstraint dropdownConstraint = validationHelper.createExplicitListConstraint(dropdownValues);
                    int startRow = lastRowNum + 1;
                    int endRow = 65535;
                    int startCol = cellIndex - 1;
                    int endCol = cellIndex - 1;
                    CellRangeAddressList addressList = new CellRangeAddressList(startRow, endRow, startCol, endCol);
                    DataValidation dataValidation = validationHelper.createValidation(dropdownConstraint, addressList);
                    dataValidation.setShowErrorBox(true);
                    dataSheet.addValidationData(dataValidation);
                }
                XlsGlobalUtils.mergeSameCells(dataSheet);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                workbook.write((OutputStream)byteArrayOutputStream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    workbook.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return byteArrayOutputStream.toByteArray();
        });
        try {
            outputStream.write(xes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Object loadData(byte[] excelBytes, OutputStream errorOutputStream, Class<?> clazz, CusValidation cusValidation) {
        try {
            XSSFWorkbook workbook = new XSSFWorkbook((InputStream)new ByteArrayInputStream(excelBytes));
            Boolean errorFlag = false;
            XlsExcelConfig xlsExcel = allExcelConfigs.get(clazz);
            if (xlsExcel == null) {
                return null;
            }
            List<XlsSheetConfig> xlsSheetList = xlsExcel.sheetConfigs();
            if (xlsSheetList == null) {
                return null;
            }
            Object result = XlsAnnotationUtils.newInstance(xlsExcel.bindClass());
            boolean sameFlag = false;
            if (xlsExcel.bindClass().isAnnotationPresent(XlsSheet.class)) {
                sameFlag = true;
            }
            HashMap<String, List> forCheckDatalistMap = new HashMap<String, List>();
            ArrayList<Object> forCheckSheetList = new ArrayList<Object>();
            ArrayList<Object> forCheckSheetList2 = new ArrayList<Object>();
            for (XlsSheetConfig xlsSheet : xlsSheetList) {
                Sheet dataSheet = workbook.getSheet(xlsSheet.title());
                if (null == dataSheet) {
                    throw new RuntimeException("Excel\u7bc4\u672c\u4e0d\u6b63\u78ba\uff0c\u8acb\u63a1\u7528\u6b63\u78ba\u7bc4\u672c\u9032\u884c\u5c0e\u5165.");
                }
                int lastRowNum = dataSheet.getLastRowNum();
                ArrayList<Object> currentDatalist = new ArrayList<Object>();
                Row row = dataSheet.getRow(xlsSheet.headRow() - 1);
                if (null == row) continue;
                int headLastCellNum = row.getLastCellNum();
                List<XlsCellConfig> xlsCellList = xlsSheet.xlsCellConfigs();
                int cellIndex = -1;
                for (int x = 0; x < headLastCellNum; ++x) {
                    XlsCellConfig xlsCellConfig;
                    if ((xlsCellConfig = xlsCellList.get(++cellIndex)).hidden().booleanValue()) {
                        --x;
                        continue;
                    }
                    String string = row.getCell(x).getStringCellValue();
                    if (!(xlsCellConfig.innerSheetField() != null ? !Arrays.stream(xlsCellConfig.innerSheetField().getAnnotation(XlsCell.class).innerSheetHeadTitle()).toList().contains(string) : !Arrays.stream(xlsCellConfig.field().getAnnotation(XlsCell.class).headTitle()).toList().contains(string))) continue;
                    throw new RuntimeException("\u6a21\u677f\u914d\u7f6e\u5b57\u6bb5\u987a\u5e8f\u4e0d\u4e00\u81f4\uff0c\u8acb\u63a1\u7528\u6700\u65b0\u7bc4\u672c\u9032\u884c\u5c0e\u5165\uff01" + string);
                }
                for (int rowIndex = xlsSheet.headRow(); rowIndex <= lastRowNum; ++rowIndex) {
                    void var24_32;
                    Row currentRowData = dataSheet.getRow(rowIndex);
                    if (null == currentRowData) continue;
                    Boolean bl = true;
                    Iterator iterator = currentRowData.iterator();
                    while (iterator.hasNext()) {
                        Cell cell = (Cell)iterator.next();
                        if (cell.getCellType() == CellType.BLANK) continue;
                        Boolean bl2 = false;
                        break;
                    }
                    if (var24_32.booleanValue()) continue;
                    int lastCellNum = currentRowData.getLastCellNum();
                    if (lastCellNum > headLastCellNum) {
                        lastCellNum = headLastCellNum;
                    }
                    Object mainSheetData = XlsAnnotationUtils.newInstance(xlsSheet.fieldRealTypeClass());
                    int cellConfigIndex = -1;
                    StringBuilder errorMsg = new StringBuilder();
                    block12: for (int x = 0; x < lastCellNum && ++cellConfigIndex < xlsCellList.size(); ++x) {
                        XlsCellConfig xlsCellConfig = xlsCellList.get(cellConfigIndex);
                        Object data = mainSheetData;
                        if (xlsCellConfig.innerSheetToClass() != Void.TYPE) {
                            if (Collection.class.isAssignableFrom(xlsCellConfig.field().getType())) {
                                co = xlsCellConfig.field().get(mainSheetData);
                                if (co == null) {
                                    Object list = XlsAnnotationUtils.newInstance(xlsCellConfig.field().getType());
                                    xlsCellConfig.field().set(mainSheetData, list);
                                    co = list;
                                }
                                if (xlsCellConfig.innerSheetIndex() >= ((Collection)co).size()) {
                                    data = XlsAnnotationUtils.newInstance(xlsCellConfig.fieldRealTypeClass());
                                    ((Collection)co).add(data);
                                } else {
                                    data = ((List)co).get(xlsCellConfig.innerSheetIndex());
                                }
                            } else {
                                co = xlsCellConfig.field().get(mainSheetData);
                                if (co == null) {
                                    co = XlsAnnotationUtils.newInstance(xlsCellConfig.fieldRealTypeClass());
                                    xlsCellConfig.field().set(mainSheetData, co);
                                }
                                data = co;
                            }
                        }
                        Field field = xlsCellConfig.innerSheetField() != null ? xlsCellConfig.innerSheetField() : xlsCellConfig.field();
                        Class<?> aClass = xlsCellConfig.innerSheetField() != null ? xlsCellConfig.innerSheetField().getType() : xlsCellConfig.fieldRealTypeClass();
                        Method setMethod = xlsCellConfig.innerSheetField() != null ? xlsCellConfig.innerSheetSetMethod() : xlsCellConfig.setMethod();
                        Object cellValue = null;
                        if (xlsCellConfig.hidden().booleanValue()) {
                            --x;
                            if (xlsCellConfig.innerSheetDefaultValue().length > xlsCellConfig.innerSheetIndex()) {
                                cellValue = xlsCellConfig.innerSheetDefaultValue()[xlsCellConfig.innerSheetIndex()];
                            }
                        } else {
                            cellValue = ExcelUtil.getCellValue(currentRowData.getCell(x), field != null ? field.getType() : null);
                            if ((cellValue == null || "".equals(cellValue.toString().trim())) && xlsCellConfig.innerSheetDefaultValue().length > xlsCellConfig.innerSheetIndex()) {
                                cellValue = xlsCellConfig.innerSheetDefaultValue()[xlsCellConfig.innerSheetIndex()];
                            }
                        }
                        if (xlsCellConfig.dropdown().length > 0 && !"".equals(xlsCellConfig.dropSplit()) && null != cellValue) {
                            cellValue = cellValue.toString().split(xlsCellConfig.dropSplit())[0];
                        }
                        if (cellValue != null) {
                            if (cellValue.getClass() == aClass) {
                                if (setMethod != null) {
                                    setMethod.invoke(data, cellValue);
                                } else {
                                    field.set(data, cellValue);
                                }
                            } else if (cellValue instanceof String) {
                                if (setMethod != null) {
                                    setMethod.invoke(data, StringToTypeConverterUtils.convert(cellValue.toString(), aClass));
                                } else {
                                    field.set(data, StringToTypeConverterUtils.convert(cellValue.toString(), aClass));
                                }
                            } else if (setMethod != null) {
                                setMethod.invoke(data, StringToTypeConverterUtils.convert(cellValue.toString(), aClass));
                            } else {
                                field.set(data, StringToTypeConverterUtils.convert(cellValue.toString(), aClass));
                            }
                        }
                        if (cusValidation != null) {
                            try {
                                String s = cusValidation.columnValidation(xlsSheet, xlsCellConfig, cellValue, currentDatalist);
                                if (s != null) {
                                    errorMsg.append(s + "\n");
                                }
                            }
                            catch (Exception e) {
                                throw new RuntimeException("Excel\u6570\u636e\u6821\u9a8c\u53d1\u751f\u5f02\u5e38:" + e);
                            }
                        }
                        if (!xlsCellConfig.unique().booleanValue()) continue;
                        for (int i = 0; i < currentDatalist.size(); ++i) {
                            Object rowData = currentDatalist.get(i);
                            if (rowData == null || cellValue == null || GenericComparator.compare(xlsCellConfig.field().get(rowData), cellValue) != 0) continue;
                            errorMsg.append(Arrays.stream(xlsCellConfig.headTitle()).findFirst().get() + "\u5217\u4e0d\u80fd\u6709\u91cd\u590d\u503c\n");
                            continue block12;
                        }
                    }
                    currentDatalist.add(mainSheetData);
                    if (xlsSheet.toClass() == GuQuotMainVo.class) {
                        forCheckSheetList.add(mainSheetData);
                        forCheckDatalistMap.put("guImportQuotVoList", forCheckSheetList);
                    }
                    if (xlsSheet.toClass() == GuQuotRiInwardVo.class) {
                        forCheckSheetList2.add(mainSheetData);
                        forCheckDatalistMap.put("guImportRiInwardVoList", forCheckSheetList2);
                    }
                    errorMsg.append(XlsGlobalUtils.validatorErrorMsg(mainSheetData));
                    if (cusValidation != null) {
                        try {
                            String s = cusValidation.rowValidation(xlsSheet, xlsSheet.xlsCellConfigs(), mainSheetData, currentDatalist);
                            if (s != null) {
                                errorMsg.append(s + "\n");
                            }
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Excel\u6570\u636e\u6821\u9a8c\u53d1\u751f\u5f02\u5e38:" + e);
                        }
                    }
                    if (errorMsg.length() <= 0) continue;
                    errorFlag = true;
                    CellStyle wrapStyle = workbook.createCellStyle();
                    wrapStyle.setWrapText(true);
                    Font font = workbook.createFont();
                    font.setColor((short)10);
                    wrapStyle.setFont(font);
                    Cell cell = currentRowData.createCell(headLastCellNum);
                    dataSheet.setColumnWidth(lastCellNum, 12800);
                    cell.setCellStyle(wrapStyle);
                    cell.setCellValue(errorMsg.toString());
                }
                if (cusValidation != null) {
                    try {
                        LinkedHashMap<Integer, String> errors = cusValidation.sheetValidation(xlsSheet, xlsSheet.xlsCellConfigs(), currentDatalist, forCheckDatalistMap);
                        if (errors != null && errors.size() > 0) {
                            for (Map.Entry entry : errors.entrySet()) {
                                String error = (String)entry.getValue();
                                if (Commons.isNotEmpty((Object)error)) {
                                    errorFlag = true;
                                }
                                CellStyle wrapStyle = workbook.createCellStyle();
                                wrapStyle.setWrapText(true);
                                Font font = workbook.createFont();
                                font.setColor((short)10);
                                wrapStyle.setFont(font);
                                Cell cell = null;
                                Object err = "";
                                if (dataSheet.getRow(xlsSheet.headRow() + (Integer)entry.getKey()) == null) {
                                    dataSheet.createRow(xlsSheet.headRow() + (Integer)entry.getKey());
                                }
                                if (dataSheet.getRow(xlsSheet.headRow() + (Integer)entry.getKey()).getLastCellNum() == headLastCellNum + 1) {
                                    cell = dataSheet.getRow(xlsSheet.headRow() + (Integer)entry.getKey()).getCell(headLastCellNum);
                                    err = cell.getStringCellValue() + "\n";
                                } else {
                                    cell = dataSheet.getRow(xlsSheet.headRow() + (Integer)entry.getKey()).createCell(headLastCellNum);
                                }
                                dataSheet.setColumnWidth(xlsSheet.xlsCellConfigs().size() + 1, 12800);
                                cell.setCellStyle(wrapStyle);
                                cell.setCellValue((String)err + error);
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Excel\u6570\u636e\u6821\u9a8c\u53d1\u751f\u5f02\u5e38:" + e);
                    }
                }
                if (sameFlag) {
                    return currentDatalist;
                }
                Field field = xlsSheet.field();
                Method setMethod = xlsSheet.setMethod();
                if (Collection.class.isAssignableFrom(field.getType())) {
                    if (setMethod != null) {
                        setMethod.invoke(result, currentDatalist);
                        continue;
                    }
                    field.set(result, currentDatalist);
                    continue;
                }
                if (!Commons.isNotEmpty(currentDatalist)) continue;
                if (setMethod != null) {
                    setMethod.invoke(result, currentDatalist.get(0));
                    continue;
                }
                field.set(result, currentDatalist.get(0));
            }
            if (errorFlag.booleanValue()) {
                workbook.write(errorOutputStream);
            }
            return result;
        }
        catch (Exception e) {
            LOG.error(e.getLocalizedMessage());
            throw new RuntimeException("Excel\u6570\u636e\u89e3\u6790\u5f02\u5e38\uff1a" + e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Object loadDataWithoutConf(byte[] excelBytes, OutputStream errorOutputStream, Class<?> clazz, CusValidation cusValidation) {
        try {
            XSSFWorkbook workbook = new XSSFWorkbook((InputStream)new ByteArrayInputStream(excelBytes));
            Boolean errorFlag = false;
            XlsExcelConfig xlsExcel = allExcelConfigs.get(clazz);
            if (xlsExcel == null) {
                return null;
            }
            List<XlsSheetConfig> xlsSheetList = xlsExcel.sheetConfigs();
            if (xlsSheetList == null) {
                return null;
            }
            Object result = XlsAnnotationUtils.newInstance(xlsExcel.bindClass());
            boolean sameFlag = false;
            if (xlsExcel.bindClass().isAnnotationPresent(XlsSheet.class)) {
                sameFlag = true;
            }
            for (XlsSheetConfig xlsSheet : xlsSheetList) {
                Sheet dataSheet = workbook.getSheet(xlsSheet.title());
                if (null == dataSheet) {
                    throw new RuntimeException("Excel\u5bfc\u5165\u6a21\u677f\u4e0d\u6b63\u78ba\uff0c\u9700\u8981\u5305\u542bSheet\u9875\uff1a" + xlsSheet.title() + "\uff0c\u53ef\u4ee5\u662f\u7a7a\u767d\u9875");
                }
                int lastRowNum = dataSheet.getLastRowNum();
                ArrayList<Object> currentDatalist = new ArrayList<Object>();
                Row row = dataSheet.getRow(xlsSheet.headRow() - 1);
                if (null == row) continue;
                int headLastCellNum = row.getLastCellNum();
                List<XlsCellConfig> xlsCellList = xlsSheet.xlsCellConfigs();
                if (xlsCellList.size() != headLastCellNum) {
                    throw new RuntimeException("\u5bfc\u5165\u6587\u4ef6\u6a21\u677f\u683c\u5f0f\u4e0d\u6b63\u786e, \u6807\u9898\u957f\u5ea6\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4e0b\u8f7d\u6a21\u677f\u6838\u5bf9\uff01");
                }
                for (int rowIndex = xlsSheet.headRow(); rowIndex <= lastRowNum; ++rowIndex) {
                    void var20_27;
                    Row currentRowData = dataSheet.getRow(rowIndex);
                    if (null == currentRowData) continue;
                    Boolean bl = true;
                    Iterator iterator = currentRowData.iterator();
                    while (iterator.hasNext()) {
                        Cell cell = (Cell)iterator.next();
                        if (cell.getCellType() == CellType.BLANK) continue;
                        Boolean bl2 = false;
                        break;
                    }
                    if (var20_27.booleanValue()) continue;
                    int lastCellNum = currentRowData.getLastCellNum();
                    if (lastCellNum > headLastCellNum) {
                        lastCellNum = headLastCellNum;
                    }
                    Object mainSheetData = XlsAnnotationUtils.newInstance(xlsSheet.fieldRealTypeClass());
                    int cellConfigIndex = -1;
                    StringBuilder errorMsg = new StringBuilder();
                    block11: for (int x = 0; x < lastCellNum && ++cellConfigIndex < xlsCellList.size(); ++x) {
                        XlsCellConfig xlsCellConfig = xlsCellList.get(cellConfigIndex);
                        Object data = mainSheetData;
                        if (xlsCellConfig.innerSheetToClass() != Void.TYPE) {
                            if (Collection.class.isAssignableFrom(xlsCellConfig.field().getType())) {
                                co = xlsCellConfig.field().get(mainSheetData);
                                if (co == null) {
                                    Object list = XlsAnnotationUtils.newInstance(xlsCellConfig.field().getType());
                                    xlsCellConfig.field().set(mainSheetData, list);
                                    co = list;
                                }
                                if (xlsCellConfig.innerSheetIndex() >= ((Collection)co).size()) {
                                    data = XlsAnnotationUtils.newInstance(xlsCellConfig.fieldRealTypeClass());
                                    ((Collection)co).add(data);
                                } else {
                                    data = ((List)co).get(xlsCellConfig.innerSheetIndex());
                                }
                            } else {
                                co = xlsCellConfig.field().get(mainSheetData);
                                if (co == null) {
                                    co = XlsAnnotationUtils.newInstance(xlsCellConfig.fieldRealTypeClass());
                                    xlsCellConfig.field().set(mainSheetData, co);
                                }
                                data = co;
                            }
                        }
                        Field field = xlsCellConfig.innerSheetField() != null ? xlsCellConfig.innerSheetField() : xlsCellConfig.field();
                        Class<?> aClass = xlsCellConfig.innerSheetField() != null ? xlsCellConfig.innerSheetField().getType() : xlsCellConfig.fieldRealTypeClass();
                        Method setMethod = xlsCellConfig.innerSheetField() != null ? xlsCellConfig.innerSheetSetMethod() : xlsCellConfig.setMethod();
                        Object cellValue = null;
                        if (xlsCellConfig.hidden().booleanValue()) {
                            --x;
                            if (xlsCellConfig.innerSheetDefaultValue().length > xlsCellConfig.innerSheetIndex()) {
                                cellValue = xlsCellConfig.innerSheetDefaultValue()[xlsCellConfig.innerSheetIndex()];
                            }
                        } else {
                            cellValue = ExcelUtil.getCellValue(currentRowData.getCell(x), field != null ? field.getType() : null);
                            if ((cellValue == null || "".equals(cellValue.toString().trim())) && xlsCellConfig.innerSheetDefaultValue().length > xlsCellConfig.innerSheetIndex()) {
                                cellValue = xlsCellConfig.innerSheetDefaultValue()[xlsCellConfig.innerSheetIndex()];
                            }
                        }
                        if (xlsCellConfig.dropdown().length > 0 && !"".equals(xlsCellConfig.dropSplit()) && null != cellValue) {
                            cellValue = cellValue.toString().split(xlsCellConfig.dropSplit())[0];
                        }
                        if (cellValue != null) {
                            if (cellValue.getClass() == aClass) {
                                if (setMethod != null) {
                                    setMethod.invoke(data, cellValue);
                                } else {
                                    field.set(data, cellValue);
                                }
                            } else if (cellValue instanceof String) {
                                if (setMethod != null) {
                                    setMethod.invoke(data, StringToTypeConverterUtils.convert(cellValue.toString(), aClass));
                                } else {
                                    field.set(data, StringToTypeConverterUtils.convert(cellValue.toString(), aClass));
                                }
                            } else if (setMethod != null) {
                                setMethod.invoke(data, StringToTypeConverterUtils.convert(cellValue.toString(), aClass));
                            } else {
                                field.set(data, StringToTypeConverterUtils.convert(cellValue.toString(), aClass));
                            }
                        }
                        if (cusValidation != null) {
                            try {
                                String s = cusValidation.columnValidation(xlsSheet, xlsCellConfig, cellValue, currentDatalist);
                                if (s != null) {
                                    errorMsg.append(s + "\n");
                                }
                            }
                            catch (Exception e) {
                                throw new RuntimeException("Excel\u6570\u636e\u6821\u9a8c\u53d1\u751f\u5f02\u5e38:" + e);
                            }
                        }
                        if (!xlsCellConfig.unique().booleanValue()) continue;
                        for (int i = 0; i < currentDatalist.size(); ++i) {
                            Object rowData = currentDatalist.get(i);
                            if (rowData == null || cellValue == null || GenericComparator.compare(xlsCellConfig.field().get(rowData), cellValue) != 0) continue;
                            errorMsg.append(Arrays.stream(xlsCellConfig.headTitle()).findFirst().get() + "\u5217\u4e0d\u80fd\u6709\u91cd\u590d\u503c\n");
                            continue block11;
                        }
                    }
                    currentDatalist.add(mainSheetData);
                    errorMsg.append(XlsGlobalUtils.validatorErrorMsg(mainSheetData));
                    if (cusValidation != null) {
                        try {
                            String s = cusValidation.rowValidation(xlsSheet, xlsSheet.xlsCellConfigs(), mainSheetData, currentDatalist);
                            if (s != null) {
                                errorMsg.append(s + "\n");
                            }
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Excel\u6570\u636e\u6821\u9a8c\u53d1\u751f\u5f02\u5e38:" + e);
                        }
                    }
                    if (errorMsg.length() <= 0) continue;
                    errorFlag = true;
                    CellStyle wrapStyle = workbook.createCellStyle();
                    wrapStyle.setWrapText(true);
                    Font font = workbook.createFont();
                    font.setColor((short)10);
                    wrapStyle.setFont(font);
                    Cell cell = currentRowData.createCell(headLastCellNum);
                    dataSheet.setColumnWidth(lastCellNum, 12800);
                    cell.setCellStyle(wrapStyle);
                    cell.setCellValue(errorMsg.toString());
                }
                if (cusValidation != null) {
                    try {
                        LinkedHashMap<Integer, String> errors = cusValidation.sheetValidation(xlsSheet, xlsSheet.xlsCellConfigs(), currentDatalist, null);
                        if (errors != null && errors.size() > 0) {
                            for (Map.Entry entry : errors.entrySet()) {
                                String error = (String)entry.getValue();
                                if (Commons.isNotEmpty((Object)error)) {
                                    errorFlag = true;
                                }
                                CellStyle wrapStyle = workbook.createCellStyle();
                                wrapStyle.setWrapText(true);
                                Font font = workbook.createFont();
                                font.setColor((short)10);
                                wrapStyle.setFont(font);
                                Cell cell = null;
                                Object err = "";
                                if (dataSheet.getRow(xlsSheet.headRow() + (Integer)entry.getKey()) == null) {
                                    dataSheet.createRow(xlsSheet.headRow() + (Integer)entry.getKey());
                                }
                                if (dataSheet.getRow(xlsSheet.headRow() + (Integer)entry.getKey()).getLastCellNum() == headLastCellNum + 1) {
                                    cell = dataSheet.getRow(xlsSheet.headRow() + (Integer)entry.getKey()).getCell(headLastCellNum);
                                    err = cell.getStringCellValue() + "\n";
                                } else {
                                    cell = dataSheet.getRow(xlsSheet.headRow() + (Integer)entry.getKey()).createCell(headLastCellNum);
                                }
                                dataSheet.setColumnWidth(xlsSheet.xlsCellConfigs().size() + 1, 12800);
                                cell.setCellStyle(wrapStyle);
                                cell.setCellValue((String)err + error);
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Excel\u6570\u636e\u6821\u9a8c\u53d1\u751f\u5f02\u5e38:" + e);
                    }
                }
                if (sameFlag) {
                    return currentDatalist;
                }
                Field field = xlsSheet.field();
                Method setMethod = xlsSheet.setMethod();
                if (Collection.class.isAssignableFrom(field.getType())) {
                    if (setMethod != null) {
                        setMethod.invoke(result, currentDatalist);
                        continue;
                    }
                    field.set(result, currentDatalist);
                    continue;
                }
                if (!Commons.isNotEmpty(currentDatalist)) continue;
                if (setMethod != null) {
                    setMethod.invoke(result, currentDatalist.get(0));
                    continue;
                }
                field.set(result, currentDatalist.get(0));
            }
            if (errorFlag.booleanValue()) {
                workbook.write(errorOutputStream);
            }
            return result;
        }
        catch (Exception e) {
            if (e instanceof NumberFormatException) {
                throw new RuntimeException("Excel\u6570\u636e\u8f6c\u6362\u51fa\u9519\uff0c\u6570\u503c/\u91d1\u989d/\u767e\u5206\u6bd4\u76f8\u5173\u5b57\u6bb5\u683c\u5f0f\u4e0d\u80fd\u4e3a\u6587\u672c\uff0c\u8bf7\u68c0\u67e5");
            }
            throw new RuntimeException("Excel\u6570\u636e\u89e3\u6790\u5f02\u5e38\uff1a" + e);
        }
    }

    public static List<Map<XlsSheetConfig, Object>> transform(Object o, Class<?> clazz, CusTransform cusTransform) {
        if (!clazz.isAnnotationPresent(XlsExcel.class)) {
            return null;
        }
        XlsExcelConfig xlsExcel = allExcelConfigs.get(clazz);
        List<XlsSheetConfig> sheetConfigs = xlsExcel.sheetConfigs();
        ArrayList<Map<XlsSheetConfig, Object>> result = new ArrayList<Map<XlsSheetConfig, Object>>();
        if (Collection.class.isAssignableFrom(o.getClass())) {
            result.add(XlsGlobalUtils.doTransform(xlsExcel.sheetConfigs().get(0), o, cusTransform));
        } else {
            sheetConfigs.forEach(sheetConfig -> {
                Object target = null;
                if (sheetConfig.getMethod() != null) {
                    try {
                        target = sheetConfig.getMethod().invoke(o, new Object[0]);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                try {
                    target = sheetConfig.field().get(o);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                Map<XlsSheetConfig, Object> e = XlsGlobalUtils.doTransform(sheetConfig, target, cusTransform);
                if (e != null && !e.isEmpty()) {
                    result.add(e);
                }
            });
        }
        return result;
    }

    private static Map<XlsSheetConfig, Object> doTransform(XlsSheetConfig sheetConfig, Object target, CusTransform cusTransform) {
        try {
            if (target == null) {
                return null;
            }
            if (sheetConfig.toClass() == null) {
                return Map.of(sheetConfig, target);
            }
            ArrayList<Object> result = new ArrayList<Object>();
            int loopTime = target instanceof Collection ? ((Collection)target).size() : 1;
            boolean collectionFlag = target instanceof Collection;
            List<Object> listObj = collectionFlag ? Arrays.asList(((Collection)target).toArray()) : new ArrayList();
            Class<?> targetClass = sheetConfig.toClass();
            if (targetClass == Void.TYPE) {
                return Map.of(sheetConfig, target);
            }
            for (int i = 0; i < loopTime; ++i) {
                Object loopObj = null;
                loopObj = !collectionFlag ? target : listObj.get(i);
                if (loopObj == null) continue;
                Object targetObj = XlsAnnotationUtils.newInstance(targetClass);
                Object finalLoopObj = loopObj;
                sheetConfig.xlsCellConfigs().forEach(cellConfig -> {
                    if (cellConfig.innerSheetField() != null) {
                        int index = cellConfig.innerSheetIndex();
                        Object innerSheetObj = null;
                        if (cellConfig.targetParentField() != null) {
                            Object targetParentObj = XlsAnnotationUtils.initField(targetObj, cellConfig.targetParentField(), cellConfig.targetParentSetMethod(), cellConfig.targetParentGetMethod(), null);
                            innerSheetObj = Collection.class.isAssignableFrom(cellConfig.targetParentField().getType()) ? XlsAnnotationUtils.initField(((List)targetParentObj).get(0), cellConfig.targetField(), cellConfig.targetSetMethod(), cellConfig.targetGetMethod(), null) : XlsAnnotationUtils.initField(targetParentObj, cellConfig.targetField(), cellConfig.targetSetMethod(), cellConfig.targetGetMethod(), null);
                        } else {
                            innerSheetObj = XlsAnnotationUtils.initField(targetObj, cellConfig.targetField(), cellConfig.targetSetMethod(), cellConfig.targetGetMethod(), null);
                        }
                        if (innerSheetObj != null) {
                            Object resultO = XlsAnnotationUtils.getFieldValue(finalLoopObj, cellConfig.field(), cellConfig.getMethod(), cellConfig.innerSheetField(), cellConfig.innerSheetGetMethod(), index);
                            XlsAnnotationUtils.setFileValue(innerSheetObj, resultO, null, null, cellConfig.innerSheetTargetField(), cellConfig.innerSheetTargetSetMethod(), index);
                        }
                    } else {
                        Object resultO = XlsAnnotationUtils.getFieldValue(finalLoopObj, cellConfig.field(), cellConfig.getMethod(), cellConfig.innerSheetField(), cellConfig.innerSheetGetMethod(), null);
                        XlsAnnotationUtils.setFileValue(targetObj, resultO, cellConfig.targetField(), cellConfig.targetSetMethod(), null, null, null);
                    }
                });
                if (cusTransform != null) {
                    cusTransform.doTransform(loopObj, targetObj, sheetConfig);
                }
                result.add(targetObj);
            }
            if (!collectionFlag && !result.isEmpty()) {
                return Map.of(sheetConfig, result.get(0));
            }
            return Map.of(sheetConfig, result);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static int initSheetCells(Class sheetFieldRealClass, XlsSheetConfig xlsSheetConfig) {
        if (!sheetFieldRealClass.isAnnotationPresent(XlsSheet.class)) {
            return -1;
        }
        ArrayList allFieldsInSheets = new ArrayList(ReflectionUtils.getAllFields((Class)sheetFieldRealClass, (Predicate[])new Predicate[]{f -> {
            f.setAccessible(true);
            return f.isAnnotationPresent(XlsCell.class) && !f.isAnnotationPresent(XlsIgnore.class);
        }}));
        boolean sameIndexFlag = allFieldsInSheets.stream().anyMatch(field -> allFieldsInSheets.stream().anyMatch(innerField -> innerField != field && innerField.getAnnotation(XlsCell.class).index() == field.getAnnotation(XlsCell.class).index()));
        if (sameIndexFlag) {
            throw new RuntimeException(sheetFieldRealClass.getName() + " cell \u4e2d\u6709\u91cd\u590d\u7684index \uff0c\u8bf7\u68c0\u67e5 ");
        }
        Collections.sort(allFieldsInSheets, (f1, f2) -> f1.getAnnotation(XlsCell.class).index() - f2.getAnnotation(XlsCell.class).index());
        Class<?> sheetToClass = xlsSheetConfig.toClass();
        int cellIndex = -1;
        for (int sheetFieldLoopIndex = 0; sheetFieldLoopIndex < allFieldsInSheets.size(); ++sheetFieldLoopIndex) {
            ++cellIndex;
            Field fieldInSheet = (Field)allFieldsInSheets.get(sheetFieldLoopIndex);
            if (Set.class.isAssignableFrom(fieldInSheet.getType()) || Map.class.isAssignableFrom(fieldInSheet.getType())) {
                throw new RuntimeException("Set Map not support yet!");
            }
            Class<?> fieldRealClassInSheet = XlsAnnotationUtils.fieldCollectionRealType(fieldInSheet);
            if (fieldRealClassInSheet == null) {
                fieldRealClassInSheet = fieldInSheet.getType();
            }
            XlsCell xlsCellAnnotation = fieldInSheet.getAnnotation(XlsCell.class);
            if (!CommonTypeCheckerUtils.isCommonType(fieldRealClassInSheet) && XlsAnnotationUtils.fieldContainsXlsCell(fieldRealClassInSheet)) {
                cellIndex = XlsGlobalUtils.initInnerSheetCells(cellIndex, fieldInSheet, xlsCellAnnotation, fieldRealClassInSheet, xlsSheetConfig);
                continue;
            }
            XlsCellConfig xlsCellConfig = new XlsCellConfig(xlsCellAnnotation);
            XlsGlobalUtils.initDropDownSql(xlsCellConfig);
            XlsGlobalUtils.initDropDownCodeType(xlsCellConfig);
            xlsCellConfig.index(cellIndex);
            xlsCellConfig.fieldRealTypeClass(fieldRealClassInSheet);
            xlsCellConfig.field(fieldInSheet);
            xlsCellConfig.getMethod(XlsAnnotationUtils.getGetterMethod(sheetFieldRealClass, fieldInSheet.getName()));
            xlsCellConfig.setMethod(XlsAnnotationUtils.getSetterMethod(sheetFieldRealClass, fieldInSheet.getName()));
            String toFieldName = xlsCellAnnotation.toField();
            if (!XlsAnnotationUtils.isNotEmptyStr(toFieldName)) {
                toFieldName = fieldInSheet.getName();
            }
            xlsCellConfig.targetField(XlsAnnotationUtils.getFieldByName(sheetToClass, toFieldName));
            xlsCellConfig.targetSetMethod(XlsAnnotationUtils.getSetterMethod(sheetToClass, toFieldName));
            xlsCellConfig.targetGetMethod(XlsAnnotationUtils.getGetterMethod(sheetToClass, toFieldName));
            if (xlsCellConfig.headTitle().length == 0) {
                xlsCellConfig.headTitle(new String[]{fieldInSheet.getName()});
            }
            xlsSheetConfig.xlsCellConfigs().add(xlsCellConfig);
        }
        return 0;
    }

    private static void initDropDownSql(XlsCellConfig xlsCellConfig) {
        if (XlsAnnotationUtils.isNotEmptyStr(xlsCellConfig.dropdownSql())) {
            if (jdbcTemplate == null) {
                throw new RuntimeException("jdbcTemplate \u672a\u521d\u59cb\u5316");
            }
            List selectOptions = jdbcTemplate.queryForList(xlsCellConfig.dropdownSql(), String.class);
            xlsCellConfig.dropdown(selectOptions.toArray(new String[0]));
        }
    }

    private static void initDropDownCodeType(XlsCellConfig xlsCellConfig) {
        if (XlsAnnotationUtils.isNotEmptyStr(xlsCellConfig.dropdownCodeType())) {
            if (jdbcTemplate == null) {
                throw new RuntimeException("jdbcTemplate \u672a\u521d\u59cb\u5316");
            }
            List selectOptions = jdbcTemplate.queryForList("select codecode||'-'||codename from ggcode where codetype = ? and validind = '1'", String.class, new Object[]{xlsCellConfig.dropdownCodeType()});
            xlsCellConfig.dropdown(selectOptions.toArray(new String[0]));
        }
    }

    private static int initInnerSheetCells(int startCellIndex, Field fieldInMainSheet, XlsCell xlsCellAnnotationInMainSheet, Class fieldRealClassInMainSheet, XlsSheetConfig xlsSheetConfig) {
        ArrayList allFieldsInInnerSheets;
        boolean sameIndexFlagForInnerSheet;
        int innerSheetLoopTime = 1;
        boolean innerFieldIsList = false;
        if (List.class.isAssignableFrom(fieldInMainSheet.getType())) {
            innerFieldIsList = true;
            innerSheetLoopTime = xlsCellAnnotationInMainSheet.innerSheetRowCount();
        }
        if (sameIndexFlagForInnerSheet = (allFieldsInInnerSheets = new ArrayList(ReflectionUtils.getAllFields((Class)fieldRealClassInMainSheet, (Predicate[])new Predicate[]{f -> {
            f.setAccessible(true);
            return f.isAnnotationPresent(XlsCell.class) && !f.isAnnotationPresent(XlsIgnore.class);
        }}))).stream().anyMatch(field -> allFieldsInInnerSheets.stream().anyMatch(innerField -> innerField != field && innerField.getAnnotation(XlsCell.class).index() == field.getAnnotation(XlsCell.class).index()))) {
            throw new RuntimeException(fieldRealClassInMainSheet.getName() + " cell \u4e2d\u6709\u91cd\u590d\u7684index \uff0c\u8bf7\u68c0\u67e5 ");
        }
        Collections.sort(allFieldsInInnerSheets, (f1, f2) -> f1.getAnnotation(XlsCell.class).index() - f2.getAnnotation(XlsCell.class).index());
        --startCellIndex;
        int loopInnerIndex = -1;
        for (int innerCellLoopIndex = 0; innerCellLoopIndex < innerSheetLoopTime; ++innerCellLoopIndex) {
            ++loopInnerIndex;
            for (Field innerSheetField : allFieldsInInnerSheets) {
                XlsCell xlsCellAnnotationInInnerSheet = innerSheetField.getAnnotation(XlsCell.class);
                XlsCellConfig xlsCellConfig = new XlsCellConfig(xlsCellAnnotationInInnerSheet);
                XlsGlobalUtils.initDropDownSql(xlsCellConfig);
                XlsGlobalUtils.initDropDownCodeType(xlsCellConfig);
                xlsCellConfig.index(++startCellIndex);
                xlsCellConfig.fieldRealTypeClass(fieldRealClassInMainSheet);
                xlsCellConfig.field(fieldInMainSheet);
                xlsCellConfig.getMethod(XlsAnnotationUtils.getGetterMethod(xlsSheetConfig.fieldRealTypeClass(), fieldInMainSheet.getName()));
                xlsCellConfig.setMethod(XlsAnnotationUtils.getSetterMethod(xlsSheetConfig.fieldRealTypeClass(), fieldInMainSheet.getName()));
                String toFieldName = xlsCellAnnotationInMainSheet.toField();
                if (!XlsAnnotationUtils.isNotEmptyStr(toFieldName)) {
                    toFieldName = fieldInMainSheet.getName();
                }
                if (toFieldName.indexOf(".") > 0) {
                    String parentFieldName = toFieldName.split("\\.")[0];
                    String currentFieldName = toFieldName.split("\\.")[1];
                    xlsCellConfig.targetParentField(XlsAnnotationUtils.getFieldByName(xlsSheetConfig.toClass(), parentFieldName));
                    xlsCellConfig.targetParentSetMethod(XlsAnnotationUtils.getSetterMethod(xlsSheetConfig.toClass(), parentFieldName));
                    xlsCellConfig.targetParentGetMethod(XlsAnnotationUtils.getGetterMethod(xlsSheetConfig.toClass(), parentFieldName));
                    Class type = xlsCellConfig.targetParentField().getType();
                    if (Collection.class.isAssignableFrom(type)) {
                        type = XlsAnnotationUtils.fieldCollectionRealType(xlsCellConfig.targetParentField());
                    }
                    xlsCellConfig.targetField(XlsAnnotationUtils.getFieldByName(type, currentFieldName));
                    xlsCellConfig.targetSetMethod(XlsAnnotationUtils.getSetterMethod(type, currentFieldName));
                    xlsCellConfig.targetGetMethod(XlsAnnotationUtils.getGetterMethod(type, currentFieldName));
                } else {
                    xlsCellConfig.targetField(XlsAnnotationUtils.getFieldByName(xlsSheetConfig.toClass(), toFieldName));
                    xlsCellConfig.targetSetMethod(XlsAnnotationUtils.getSetterMethod(xlsSheetConfig.toClass(), toFieldName));
                    xlsCellConfig.targetGetMethod(XlsAnnotationUtils.getGetterMethod(xlsSheetConfig.toClass(), toFieldName));
                }
                xlsCellConfig.innerSheetIndex(innerCellLoopIndex);
                xlsCellConfig.isArray(innerFieldIsList);
                String innerFieldToName = xlsCellAnnotationInInnerSheet.toField();
                if (!XlsAnnotationUtils.isNotEmptyStr(innerFieldToName)) {
                    innerFieldToName = innerSheetField.getName();
                }
                xlsCellConfig.innerSheetToClass(xlsCellAnnotationInMainSheet.innerSheetToClass());
                xlsCellConfig.innerSheetField(innerSheetField);
                xlsCellConfig.innerSheetGetMethod(XlsAnnotationUtils.getGetterMethod(fieldRealClassInMainSheet, innerSheetField.getName()));
                xlsCellConfig.innerSheetSetMethod(XlsAnnotationUtils.getSetterMethod(fieldRealClassInMainSheet, innerSheetField.getName()));
                xlsCellConfig.innerSheetTargetField(XlsAnnotationUtils.getFieldByName(xlsCellAnnotationInMainSheet.innerSheetToClass(), innerFieldToName));
                xlsCellConfig.innerSheetTargetGetMethod(XlsAnnotationUtils.getGetterMethod(xlsCellAnnotationInMainSheet.innerSheetToClass(), innerFieldToName));
                xlsCellConfig.innerSheetTargetSetMethod(XlsAnnotationUtils.getSetterMethod(xlsCellAnnotationInMainSheet.innerSheetToClass(), innerFieldToName));
                if (!xlsCellConfig.innerSheetExportSortKey().isEmpty()) {
                    xlsCellConfig.setInnerSheetExportSortKeyField(XlsAnnotationUtils.getFieldByName(xlsCellAnnotationInMainSheet.innerSheetToClass(), xlsCellConfig.innerSheetExportSortKey()));
                }
                if (xlsCellConfig.headTitle().length == 0) {
                    xlsCellConfig.headTitle(new String[]{xlsCellConfig.innerSheetField().getName()});
                }
                if (xlsCellConfig.innerSheetHeadTitle().length > 0) {
                    xlsCellConfig.headTitle(new String[]{xlsCellConfig.innerSheetHeadTitle()[loopInnerIndex]});
                }
                xlsSheetConfig.xlsCellConfigs().add(xlsCellConfig);
            }
        }
        return startCellIndex;
    }

    private static void mergeSameCells(Sheet sheet) {
        int lastRowNum = sheet.getLastRowNum();
        for (int rowIndex = 0; rowIndex <= lastRowNum; ++rowIndex) {
            Row row = sheet.getRow(rowIndex);
            if (row == null) continue;
            int lastCellNum = row.getLastCellNum();
            for (int cellIndex = 0; cellIndex <= lastCellNum; ++cellIndex) {
                Cell nextCell;
                Row nextRow;
                Cell cell = row.getCell(cellIndex);
                if (cell == null || XlsGlobalUtils.isMergedCell(sheet, cell)) continue;
                String cellValue = cell.getStringCellValue();
                int startRow = rowIndex;
                int endRow = rowIndex;
                int startCell = cellIndex;
                int endCell = cellIndex;
                int c = cellIndex + 1;
                while (c <= lastCellNum && (nextRow = sheet.getRow(rowIndex)) != null && (nextCell = nextRow.getCell(c)) != null && cellValue.equals(nextCell.getStringCellValue())) {
                    endCell = c++;
                }
                for (c = cellIndex + 1; c <= lastCellNum; ++c) {
                    Cell innerNextCell;
                    Row innerNextRow;
                    int r = rowIndex + 1;
                    while (r <= lastRowNum && (innerNextRow = sheet.getRow(r)) != null && (innerNextCell = innerNextRow.getCell(cellIndex)) != null && cellValue.equals(innerNextCell.getStringCellValue())) {
                        endRow = r++;
                    }
                }
                if (endRow <= startRow && endCell <= startCell) continue;
                sheet.addMergedRegion(new CellRangeAddress(startRow, endRow, startCell, endCell));
                cellIndex = endCell;
            }
        }
    }

    private static boolean isMergedCell(Sheet sheet, Cell cell) {
        int rowIndex = cell.getRowIndex();
        int columnIndex = cell.getColumnIndex();
        List mergedRegions = sheet.getMergedRegions();
        for (CellRangeAddress range : mergedRegions) {
            if (!range.isInRange(rowIndex, columnIndex)) continue;
            return true;
        }
        return false;
    }

    public static void buildStruct(List<Map<XlsSheetConfig, Object>> businessObj) {
        for (int i = 0; i < businessObj.size(); ++i) {
            Map<XlsSheetConfig, Object> xlsSheetConfigObjectMap = businessObj.get(i);
            xlsSheetConfigObjectMap.forEach((xlsSheetConfig, loopData) -> {
                if (xlsSheetConfig.parentClass() != null && xlsSheetConfig.parentClass() != Void.TYPE) {
                    List<Map<XlsSheetConfig, Object>> parentDataList = businessObj.stream().filter(b -> b.keySet().stream().anyMatch(xlsSheetConfig1 -> xlsSheetConfig1.toClass() == xlsSheetConfig.parentClass())).toList();
                    if (parentDataList.isEmpty()) {
                        return;
                    }
                    if (parentDataList.size() > 1) {
                        throw new RuntimeException("parent times not right :" + xlsSheetConfig.parentClass());
                    }
                    if (loopData instanceof List) {
                        ((List)loopData).forEach(data -> XlsGlobalUtils.doLink(xlsSheetConfig, data, parentDataList));
                    } else {
                        XlsGlobalUtils.doLink(xlsSheetConfig, loopData, parentDataList);
                    }
                }
            });
        }
    }

    private static void doLink(XlsSheetConfig xlsSheetConfig, Object data, List<Map<XlsSheetConfig, Object>> parentDataList) {
        if (data == null) {
            return;
        }
        if (xlsSheetConfig.parentClass() == null) {
            return;
        }
        Object foreignKey = null;
        try {
            if (xlsSheetConfig.linkGetMethod() != null) {
                foreignKey = xlsSheetConfig.linkGetMethod().invoke(data, new Object[0]);
            } else if (xlsSheetConfig.linkId() != null) {
                foreignKey = xlsSheetConfig.linkId().get(data);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Object finalForeignKey = foreignKey;
        parentDataList.stream().filter(p -> p.keySet().stream().anyMatch(pk -> pk.toClass() == xlsSheetConfig.parentClass())).flatMap(p -> {
            ArrayList result = new ArrayList();
            p.values().forEach(pp -> {
                if (pp instanceof Collection) {
                    result.addAll((Collection)pp);
                } else {
                    result.add(pp);
                }
            });
            return result.stream();
        }).filter(p -> {
            try {
                Object pDatum = p;
                Object parentKey = null;
                if (xlsSheetConfig.parentLinkGetMethod() != null) {
                    parentKey = xlsSheetConfig.parentLinkGetMethod().invoke(pDatum, new Object[0]);
                } else if (xlsSheetConfig.parentLinkId() != null) {
                    parentKey = xlsSheetConfig.parentLinkId().get(pDatum);
                }
                if (finalForeignKey != null && parentKey != null) {
                    return GenericComparator.compare(finalForeignKey, parentKey) == 0;
                }
                return false;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).forEach(p -> {
            try {
                List<Object> l = null;
                l = p instanceof List ? (List<Object>)p : List.of(p);
                for (Object pData : l) {
                    if (xlsSheetConfig.parentInnerContainerField() != null) {
                        Object parentObj = null;
                        if (Collection.class.isAssignableFrom(xlsSheetConfig.parentContainerField().getType())) {
                            parentObj = xlsSheetConfig.parentContainerField().get(pData);
                            if (parentObj == null) {
                                parentObj = XlsAnnotationUtils.newInstance(xlsSheetConfig.parentContainerField().getType());
                            }
                        } else if (xlsSheetConfig.parentContainerGetMethod() != null) {
                            parentObj = xlsSheetConfig.parentContainerGetMethod().invoke(pData, new Object[0]);
                        } else if (xlsSheetConfig.parentContainerField() != null) {
                            parentObj = xlsSheetConfig.parentContainerField().get(pData);
                        }
                        if (Collection.class.isAssignableFrom(xlsSheetConfig.parentInnerContainerField().getType())) {
                            Object list;
                            if (List.class.isAssignableFrom(parentObj.getClass())) {
                                parentObj = ((List)parentObj).get(0);
                            }
                            if ((list = xlsSheetConfig.parentInnerContainerField().get(parentObj)) == null) {
                                list = XlsAnnotationUtils.newInstance(xlsSheetConfig.parentInnerContainerField().getType());
                                xlsSheetConfig.parentInnerContainerField().set(parentObj, list);
                            }
                            ((Collection)list).add(data);
                            continue;
                        }
                        if (xlsSheetConfig.parentContainerSetMethod() != null) {
                            xlsSheetConfig.parentContainerSetMethod().invoke(parentObj, data);
                            continue;
                        }
                        if (xlsSheetConfig.parentContainerField() == null) continue;
                        xlsSheetConfig.parentContainerField().set(parentObj, data);
                        continue;
                    }
                    if (Collection.class.isAssignableFrom(xlsSheetConfig.parentContainerField().getType())) {
                        Object list = xlsSheetConfig.parentContainerField().get(pData);
                        if (list == null) {
                            list = XlsAnnotationUtils.newInstance(xlsSheetConfig.parentContainerField().getType());
                            xlsSheetConfig.parentContainerField().set(pData, list);
                        }
                        ((Collection)list).add(data);
                        continue;
                    }
                    if (xlsSheetConfig.parentContainerSetMethod() != null) {
                        xlsSheetConfig.parentContainerSetMethod().invoke(pData, data);
                        continue;
                    }
                    if (xlsSheetConfig.parentContainerField() == null) continue;
                    xlsSheetConfig.parentContainerField().set(pData, data);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static void export(Object data, Class<?> mainVoClass, OutputStream outputStream) {
        XlsExcelConfig xlsExcelConfig = allExcelConfigs.get(mainVoClass);
        if (xlsExcelConfig == null) {
            throw new RuntimeException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u914d\u7f6e\u6570\u636e");
        }
        HashMap<XlsSheetConfig, List> splitedData = new HashMap<XlsSheetConfig, List>();
        ArrayList<Object> loopData = new ArrayList<Object>();
        if (data instanceof Map) {
            loopData.addAll(((Map)data).values());
        } else if (data instanceof Collection) {
            loopData.addAll((Collection)data);
        } else {
            Set allFields = ReflectionUtils.getAllFields(data.getClass(), (Predicate[])new Predicate[0]);
            for (Field field : allFields) {
                field.setAccessible(true);
                Object o = null;
                try {
                    o = field.get(data);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                if (o == null) continue;
                loopData.add(o);
            }
        }
        loopData.forEach(v -> {
            Class<?> z = v.getClass();
            if (Collection.class.isAssignableFrom(v.getClass()) && !((Collection)v).isEmpty()) {
                z = ((Collection)v).iterator().next().getClass();
            }
            Class<?> finalZ = z;
            XlsSheetConfig xlsSheetConfig = xlsExcelConfig.sheetConfigs().stream().filter(sheet -> sheet.toClass() == finalZ).findFirst().orElse(null);
            if (xlsSheetConfig != null) {
                splitedData.put(xlsSheetConfig, v instanceof List ? (List<Object>)v : List.of(v));
            }
        });
        ByteArrayOutputStream templateOutputStream = new ByteArrayOutputStream();
        XlsGlobalUtils.getXlsTemplate(mainVoClass, templateOutputStream);
        SXSSFWorkbook workbook = null;
        int rowAccessWindowSize = 500;
        HashMap cellStyleCache = new HashMap();
        try {
            workbook = new SXSSFWorkbook(new XSSFWorkbook((InputStream)new ByteArrayInputStream(templateOutputStream.toByteArray())), rowAccessWindowSize);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        SXSSFWorkbook finalWorkbook = workbook;
        splitedData.forEach((xlsSheetConfig, sheetData) -> {
            SXSSFSheet sheet = finalWorkbook.getSheet(xlsSheetConfig.title());
            int startRow = xlsSheetConfig.headRow() - 1;
            for (Object rowData : sheetData) {
                ++startRow;
                int startCol = -1;
                for (XlsCellConfig xlsCellConfig : xlsSheetConfig.xlsCellConfigs()) {
                    if (xlsCellConfig.hidden().booleanValue()) continue;
                    try {
                        Cell cell;
                        ++startCol;
                        Object cellValue = null;
                        if (xlsCellConfig.targetParentField() != null) {
                            Object currentData = null;
                            if (xlsCellConfig.targetParentGetMethod() != null) {
                                currentData = xlsCellConfig.targetParentGetMethod().invoke(rowData, new Object[0]);
                            } else if (xlsCellConfig.targetParentField() != null) {
                                currentData = xlsCellConfig.targetParentField().get(rowData);
                            }
                            if (List.class.isAssignableFrom(currentData.getClass())) {
                                currentData = ((List)currentData).get(xlsCellConfig.innerSheetIndex());
                            }
                            if (xlsCellConfig.targetGetMethod() != null) {
                                cellValue = xlsCellConfig.targetGetMethod().invoke(currentData, new Object[0]);
                            } else if (xlsCellConfig.targetField() != null) {
                                cellValue = xlsCellConfig.targetField().get(currentData);
                            }
                        } else if (xlsCellConfig.targetGetMethod() != null) {
                            cellValue = xlsCellConfig.targetGetMethod().invoke(rowData, new Object[0]);
                        } else if (xlsCellConfig.targetField() != null) {
                            cellValue = xlsCellConfig.targetField().get(rowData);
                        }
                        if (xlsCellConfig.isArray() && cellValue != null) {
                            if (((List)cellValue).size() > 0) {
                                String[] sortKey = xlsCellConfig.innerSheetExportSortValue();
                                List listCellValue = (List)cellValue;
                                if (xlsCellConfig.innerSheetExportSortKeyField() != null) {
                                    Optional<Object> first = listCellValue.stream().filter(e -> {
                                        try {
                                            Object compareValue = xlsCellConfig.innerSheetExportSortKeyField().get(e);
                                            if (sortKey[xlsCellConfig.innerSheetIndex()].equals(compareValue)) {
                                                return true;
                                            }
                                        }
                                        catch (IllegalAccessException ex) {
                                            throw new RuntimeException(ex);
                                        }
                                        return false;
                                    }).findFirst();
                                    cellValue = first.orElse(null);
                                } else {
                                    cellValue = ((List)cellValue).get(xlsCellConfig.innerSheetIndex());
                                }
                            } else {
                                cellValue = null;
                            }
                        }
                        if (cellValue != null && xlsCellConfig.innerSheetTargetGetMethod() != null) {
                            cellValue = xlsCellConfig.innerSheetTargetGetMethod().invoke(cellValue, new Object[0]);
                        } else if (cellValue != null && xlsCellConfig.innerSheetTargetField() != null) {
                            cellValue = xlsCellConfig.innerSheetTargetField().get(cellValue);
                        }
                        if (cellValue == null) continue;
                        SXSSFRow row = sheet.getRow(startRow);
                        if (row == null) {
                            row = sheet.createRow(startRow);
                        }
                        if ((cell = row.getCell(startCol)) == null) {
                            cell = row.createCell(startCol);
                        }
                        if (!"".equals(xlsCellConfig.format())) {
                            try {
                                cell.setCellStyle(xlsCellConfig.cellStyle((Workbook)finalWorkbook, cellStyleCache));
                            }
                            catch (Exception e2) {
                                LOG.error("format is  {},", (Object)xlsCellConfig.format());
                                LOG.error(e2.getLocalizedMessage(), (Throwable)e2);
                            }
                        }
                        if (xlsCellConfig.dropdown().length > 0) {
                            Object finalCellValue = cellValue;
                            String newValue = Arrays.stream(xlsCellConfig.dropdown()).filter(d -> {
                                if (finalCellValue.toString().contains("-")) {
                                    return finalCellValue.toString().equals(d);
                                }
                                return finalCellValue.toString().equals(d.split(xlsCellConfig.dropSplit())[0]);
                            }).findFirst().orElse(null);
                            cell.setCellValue(newValue);
                            continue;
                        }
                        if (cellValue instanceof Boolean) {
                            cell.setCellValue(((Boolean)cellValue).booleanValue());
                            continue;
                        }
                        if (cellValue instanceof Double) {
                            cell.setCellValue(((Double)cellValue).doubleValue());
                            continue;
                        }
                        if (cellValue instanceof Integer) {
                            cell.setCellValue((double)((Integer)cellValue).intValue());
                            continue;
                        }
                        if (cellValue instanceof Long) {
                            cell.setCellValue((double)((Long)cellValue).longValue());
                            continue;
                        }
                        if (cellValue instanceof String) {
                            cell.setCellValue((String)cellValue);
                            continue;
                        }
                        if (cellValue instanceof Date) {
                            cell.setCellValue((Date)cellValue);
                            continue;
                        }
                        if (cellValue instanceof Float) {
                            cell.setCellValue(((Float)cellValue).doubleValue());
                            continue;
                        }
                        if (cellValue instanceof BigDecimal) {
                            cell.setCellValue(((BigDecimal)cellValue).doubleValue());
                            continue;
                        }
                        if (!CommonTypeCheckerUtils.isCommonType(cellValue)) continue;
                        cell.setCellValue(cellValue.toString());
                    }
                    catch (Exception e3) {
                        throw new RuntimeException(e3);
                    }
                }
            }
        });
        try {
            workbook.write(outputStream);
            workbook.dispose();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String validatorErrorMsg(Object object) {
        Set violations = validator.validate(object, new Class[0]);
        StringBuilder sb = new StringBuilder();
        for (ConstraintViolation violation : violations) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(violation.getMessage());
        }
        return sb.toString();
    }

    public static void createConfigClass(List<DbExcelConfig> dbExcelConfigs) throws CannotCompileException, NotFoundException {
        ClassPool pool = ClassPool.getDefault();
        for (DbExcelConfig excelConfig : dbExcelConfigs) {
            for (DbSheetConfig dbSheetConfig : excelConfig.getDbSheetConfigs()) {
                for (DbCellConfig dbCellConfig : dbSheetConfig.getDbCellConfigs()) {
                    String classFullName;
                    CtClass orNull;
                    if (!XlsAnnotationUtils.isNotEmptyStr(dbCellConfig.getFieldTypeClassName()) || (orNull = pool.getOrNull(classFullName = excelConfig.getPackageName() + "." + dbCellConfig.getFieldTypeClassName())) != null) continue;
                    ArrayList<DbCellConfig> allInnerCellFields = new ArrayList<DbCellConfig>(dbSheetConfig.getDbCellConfigs().stream().filter(cell -> dbCellConfig.getFieldTypeClassName().equals(cell.getFieldTypeClassName())).toList());
                    CtClass innerSheetClass = pool.makeClass(classFullName);
                    ConstPool innserSheetClassConstPool = innerSheetClass.getClassFile().getConstPool();
                    int index = -1;
                    Collections.sort(allInnerCellFields, (e1, e2) -> e1.getIndex() - e2.getIndex());
                    for (DbCellConfig innerCellField : allInnerCellFields) {
                        ArrayMemberValue titlesArrayMemberValues;
                        CtField ctInnerCellField = new CtField(pool.get(innerCellField.getInnerSheetFieldType()), innerCellField.getInnerSheetToField(), innerSheetClass);
                        ctInnerCellField.setModifiers(1);
                        AnnotationsAttribute fieldAttr = new AnnotationsAttribute(innserSheetClassConstPool, "RuntimeVisibleAnnotations");
                        Annotation xlsCellAnnotation = new Annotation(XlsCell.class.getName(), innserSheetClassConstPool);
                        xlsCellAnnotation.addMemberValue("index", (MemberValue)new IntegerMemberValue(innserSheetClassConstPool, ++index));
                        if (XlsAnnotationUtils.isNotEmptyStr(innerCellField.getToField())) {
                            xlsCellAnnotation.addMemberValue("toField", (MemberValue)new StringMemberValue(innerCellField.getToField(), innserSheetClassConstPool));
                        }
                        if (innerCellField.getHeadTitle().length > 0) {
                            MemberValue[] titles = Arrays.stream(innerCellField.getHeadTitle()).map(f -> new StringMemberValue(f, innserSheetClassConstPool)).toList().toArray(new MemberValue[0]);
                            titlesArrayMemberValues = new ArrayMemberValue(innserSheetClassConstPool);
                            titlesArrayMemberValues.setValue(titles);
                            xlsCellAnnotation.addMemberValue("headTitle", (MemberValue)titlesArrayMemberValues);
                        }
                        if (XlsAnnotationUtils.isNotEmptyStr(innerCellField.getHeadStyle())) {
                            xlsCellAnnotation.addMemberValue("headStyle", (MemberValue)new StringMemberValue(innerCellField.getHeadStyle(), innserSheetClassConstPool));
                        }
                        if (XlsAnnotationUtils.isNotEmptyStr(innerCellField.getValidation())) {
                            xlsCellAnnotation.addMemberValue("validation", (MemberValue)new StringMemberValue(innerCellField.getValidation(), innserSheetClassConstPool));
                        }
                        if (XlsAnnotationUtils.isNotEmptyStr(innerCellField.getDropSplit())) {
                            xlsCellAnnotation.addMemberValue("dropSplit", (MemberValue)new StringMemberValue(innerCellField.getDropSplit(), innserSheetClassConstPool));
                        }
                        if (XlsAnnotationUtils.isNotEmptyStr(innerCellField.getDropdownSql())) {
                            xlsCellAnnotation.addMemberValue("dropdownSql", (MemberValue)new StringMemberValue(innerCellField.getDropdownSql(), innserSheetClassConstPool));
                        }
                        if (XlsAnnotationUtils.isNotEmptyStr(innerCellField.getDropdownCodeType())) {
                            xlsCellAnnotation.addMemberValue("dropdownCodeType", (MemberValue)new StringMemberValue(innerCellField.getDropdownCodeType(), innserSheetClassConstPool));
                        }
                        if (innerCellField.getDropdown().length > 0) {
                            MemberValue[] dropdowns = Arrays.stream(innerCellField.getDropdown()).map(f -> new StringMemberValue(f, innserSheetClassConstPool)).toList().toArray(new MemberValue[0]);
                            titlesArrayMemberValues = new ArrayMemberValue(innserSheetClassConstPool);
                            titlesArrayMemberValues.setValue(dropdowns);
                            xlsCellAnnotation.addMemberValue("dropdown", (MemberValue)titlesArrayMemberValues);
                        }
                        if (XlsAnnotationUtils.isNotEmptyStr(innerCellField.getFormat())) {
                            xlsCellAnnotation.addMemberValue("format", (MemberValue)new StringMemberValue(innerCellField.getFormat(), innserSheetClassConstPool));
                        }
                        if (innerCellField.getColumnWeight() > 0) {
                            xlsCellAnnotation.addMemberValue("columnWeight", (MemberValue)new IntegerMemberValue(innserSheetClassConstPool, innerCellField.getColumnWeight().intValue()));
                        }
                        fieldAttr.addAnnotation(xlsCellAnnotation);
                        XlsGlobalUtils.setOtherAnnotations(innerCellField, innserSheetClassConstPool, ctInnerCellField, fieldAttr);
                        ctInnerCellField.getFieldInfo().addAttribute((AttributeInfo)fieldAttr);
                        innerSheetClass.addField(ctInnerCellField);
                    }
                    innerSheetClass.toClass();
                }
            }
        }
        for (DbExcelConfig excelConfig : dbExcelConfigs) {
            for (DbSheetConfig dbSheetConfig : excelConfig.getDbSheetConfigs()) {
                String classFullName = excelConfig.getPackageName() + "." + dbSheetConfig.getClassName();
                CtClass orNull = pool.getOrNull(classFullName);
                if (orNull != null) continue;
                CtClass sheetClass = pool.makeClass(classFullName);
                sheetClass.setModifiers(1);
                ClassFile sheetClassFile = sheetClass.getClassFile();
                ConstPool sheetClassConstPool = sheetClassFile.getConstPool();
                AnnotationsAttribute classAnnotationAttr = new AnnotationsAttribute(sheetClassConstPool, "RuntimeVisibleAnnotations");
                Annotation xlsSheetAnnotation = new Annotation(XlsSheet.class.getName(), sheetClassConstPool);
                if (dbSheetConfig.getIndex() != null) {
                    xlsSheetAnnotation.addMemberValue("index", (MemberValue)new IntegerMemberValue(sheetClassConstPool, dbSheetConfig.getIndex().intValue()));
                }
                xlsSheetAnnotation.addMemberValue("title", (MemberValue)new StringMemberValue(dbSheetConfig.getTitle(), sheetClassConstPool));
                if (dbSheetConfig.getSheetActive() != null) {
                    xlsSheetAnnotation.addMemberValue("sheetActive", (MemberValue)new BooleanMemberValue(dbSheetConfig.getSheetActive().booleanValue(), sheetClassConstPool));
                }
                if (dbSheetConfig.getHeadRow() != null) {
                    xlsSheetAnnotation.addMemberValue("headRow", (MemberValue)new IntegerMemberValue(sheetClassConstPool, dbSheetConfig.getHeadRow().intValue()));
                }
                if (dbSheetConfig.getHidden() != null) {
                    xlsSheetAnnotation.addMemberValue("hidden", (MemberValue)new BooleanMemberValue(dbSheetConfig.getHidden().booleanValue(), sheetClassConstPool));
                }
                if (!"void.class".equals(dbSheetConfig.getToClass()) && XlsAnnotationUtils.isNotEmptyStr(dbSheetConfig.getToClass())) {
                    xlsSheetAnnotation.addMemberValue("toClass", (MemberValue)new ClassMemberValue(dbSheetConfig.getToClass(), sheetClassConstPool));
                }
                if (!"void.class".equals(dbSheetConfig.getParentClass()) && XlsAnnotationUtils.isNotEmptyStr(dbSheetConfig.getParentClass())) {
                    xlsSheetAnnotation.addMemberValue("parentClass", (MemberValue)new ClassMemberValue(dbSheetConfig.getParentClass(), sheetClassConstPool));
                }
                if (XlsAnnotationUtils.isNotEmptyStr(dbSheetConfig.getParentContainerField())) {
                    xlsSheetAnnotation.addMemberValue("parentContainerField", (MemberValue)new StringMemberValue(dbSheetConfig.getParentContainerField(), sheetClassConstPool));
                }
                if (XlsAnnotationUtils.isNotEmptyStr(dbSheetConfig.getParentLinkId())) {
                    xlsSheetAnnotation.addMemberValue("parentLinkId", (MemberValue)new StringMemberValue(dbSheetConfig.getParentLinkId(), sheetClassConstPool));
                }
                if (XlsAnnotationUtils.isNotEmptyStr(dbSheetConfig.getLinkId())) {
                    xlsSheetAnnotation.addMemberValue("linkId", (MemberValue)new StringMemberValue(dbSheetConfig.getLinkId(), sheetClassConstPool));
                }
                classAnnotationAttr.addAnnotation(xlsSheetAnnotation);
                sheetClassFile.addAttribute((AttributeInfo)classAnnotationAttr);
                for (DbCellConfig cellField : dbSheetConfig.getDbCellConfigs()) {
                    ArrayMemberValue titlesArrayMemberValues;
                    if (Arrays.stream(sheetClass.getDeclaredFields()).anyMatch(e -> e.getName().equals(cellField.getFieldName()))) continue;
                    CtField ctCellField = new CtField(pool.get(cellField.getFieldType()), cellField.getFieldName(), sheetClass);
                    ctCellField.setModifiers(1);
                    AnnotationsAttribute fieldAttr = new AnnotationsAttribute(sheetClassConstPool, "RuntimeVisibleAnnotations");
                    Annotation xlsCellAnnotation = new Annotation(XlsCell.class.getName(), sheetClassConstPool);
                    xlsCellAnnotation.addMemberValue("index", (MemberValue)new IntegerMemberValue(sheetClassConstPool, cellField.getIndex().intValue()));
                    if (XlsAnnotationUtils.isNotEmptyStr(cellField.getToField())) {
                        xlsCellAnnotation.addMemberValue("toField", (MemberValue)new StringMemberValue(cellField.getToField(), sheetClassConstPool));
                    }
                    if (cellField.getHeadTitle().length > 0) {
                        MemberValue[] titles = Arrays.stream(cellField.getHeadTitle()).map(f -> new StringMemberValue(f, sheetClassConstPool)).toList().toArray(new MemberValue[0]);
                        titlesArrayMemberValues = new ArrayMemberValue(sheetClassConstPool);
                        titlesArrayMemberValues.setValue(titles);
                        xlsCellAnnotation.addMemberValue("headTitle", (MemberValue)titlesArrayMemberValues);
                    }
                    if (XlsAnnotationUtils.isNotEmptyStr(cellField.getHeadStyle())) {
                        xlsCellAnnotation.addMemberValue("headStyle", (MemberValue)new StringMemberValue(cellField.getHeadStyle(), sheetClassConstPool));
                    }
                    if (XlsAnnotationUtils.isNotEmptyStr(cellField.getValidation())) {
                        xlsCellAnnotation.addMemberValue("validation", (MemberValue)new StringMemberValue(cellField.getValidation(), sheetClassConstPool));
                    }
                    if (!"void.class".equals(cellField.getFieldTypeClassName()) && XlsAnnotationUtils.isNotEmptyStr(cellField.getFieldTypeClassName())) {
                        String sig = new SignatureAttribute.ClassSignature(null, new SignatureAttribute.ClassType(ctCellField.getType().getName(), new SignatureAttribute.TypeArgument[]{new SignatureAttribute.TypeArgument((SignatureAttribute.ObjectType)new SignatureAttribute.ClassType(excelConfig.getPackageName() + "." + cellField.getFieldTypeClassName()))}), null).encode();
                        ctCellField.setGenericSignature(sig);
                    }
                    if (!"void.class".equals(cellField.getInnerSheetToClass()) && XlsAnnotationUtils.isNotEmptyStr(cellField.getInnerSheetToClass())) {
                        xlsCellAnnotation.addMemberValue("innerSheetToClass", (MemberValue)new ClassMemberValue(cellField.getInnerSheetToClass(), sheetClassConstPool));
                    }
                    if (cellField.getInnerSheetRowCount() > 0) {
                        xlsCellAnnotation.addMemberValue("innerSheetRowCount", (MemberValue)new IntegerMemberValue(sheetClassConstPool, cellField.getInnerSheetRowCount()));
                    }
                    if (XlsAnnotationUtils.isNotEmptyStr(cellField.getDropSplit())) {
                        xlsCellAnnotation.addMemberValue("dropSplit", (MemberValue)new StringMemberValue(cellField.getDropSplit(), sheetClassConstPool));
                    }
                    if (XlsAnnotationUtils.isNotEmptyStr(cellField.getDropdownSql())) {
                        xlsCellAnnotation.addMemberValue("dropdownSql", (MemberValue)new StringMemberValue(cellField.getDropdownSql(), sheetClassConstPool));
                    }
                    if (XlsAnnotationUtils.isNotEmptyStr(cellField.getDropdownCodeType())) {
                        xlsCellAnnotation.addMemberValue("dropdownCodeType", (MemberValue)new StringMemberValue(cellField.getDropdownCodeType(), sheetClassConstPool));
                    }
                    if (cellField.getDropdown().length > 0) {
                        MemberValue[] dropdowns = Arrays.stream(cellField.getDropdown()).map(f -> new StringMemberValue(f, sheetClassConstPool)).toList().toArray(new MemberValue[0]);
                        titlesArrayMemberValues = new ArrayMemberValue(sheetClassConstPool);
                        titlesArrayMemberValues.setValue(dropdowns);
                        xlsCellAnnotation.addMemberValue("dropdown", (MemberValue)titlesArrayMemberValues);
                    }
                    if (XlsAnnotationUtils.isNotEmptyStr(cellField.getFormat())) {
                        xlsCellAnnotation.addMemberValue("format", (MemberValue)new StringMemberValue(cellField.getFormat(), sheetClassConstPool));
                    }
                    if (cellField.getColumnWeight() > 0) {
                        xlsCellAnnotation.addMemberValue("columnWeight", (MemberValue)new IntegerMemberValue(sheetClassConstPool, cellField.getColumnWeight().intValue()));
                    }
                    fieldAttr.addAnnotation(xlsCellAnnotation);
                    XlsGlobalUtils.setOtherAnnotations(cellField, sheetClassConstPool, ctCellField, fieldAttr);
                    ctCellField.getFieldInfo().addAttribute((AttributeInfo)fieldAttr);
                    sheetClass.addField(ctCellField);
                }
                sheetClass.toClass();
            }
        }
        for (DbExcelConfig loopExcelConfig : dbExcelConfigs) {
            CtClass mainContainerClass = pool.makeClass(loopExcelConfig.getPackageName() + "." + loopExcelConfig.getClassName());
            mainContainerClass.setModifiers(1);
            ConstPool mainContainerClassClassPool = mainContainerClass.getClassFile().getConstPool();
            AnnotationsAttribute classAttr = new AnnotationsAttribute(mainContainerClassClassPool, "RuntimeVisibleAnnotations");
            Annotation xlsExcel = new Annotation(XlsExcel.class.getName(), mainContainerClassClassPool);
            xlsExcel.addMemberValue("title", (MemberValue)new StringMemberValue(loopExcelConfig.getTitle(), mainContainerClassClassPool));
            ArrayMemberValue categoryArray = new ArrayMemberValue(mainContainerClassClassPool);
            MemberValue[] array = Arrays.stream(loopExcelConfig.getCategory()).map(p -> new StringMemberValue(p, mainContainerClassClassPool)).toList().toArray(new MemberValue[0]);
            categoryArray.setValue(array);
            xlsExcel.addMemberValue("category", (MemberValue)categoryArray);
            classAttr.addAnnotation(xlsExcel);
            mainContainerClass.getClassFile().addAttribute((AttributeInfo)classAttr);
            for (DbSheetConfig dbSheetConfig : loopExcelConfig.getDbSheetConfigs()) {
                CtClass listClass = pool.get(List.class.getName());
                CtClass type = pool.get(loopExcelConfig.getPackageName() + "." + dbSheetConfig.getClassName());
                CtField ctField = new CtField(listClass, Character.toLowerCase(dbSheetConfig.getClassName().charAt(0)) + dbSheetConfig.getClassName().substring(1), mainContainerClass);
                String sig = new SignatureAttribute.ClassSignature(null, new SignatureAttribute.ClassType(listClass.getName(), new SignatureAttribute.TypeArgument[]{new SignatureAttribute.TypeArgument((SignatureAttribute.ObjectType)new SignatureAttribute.ClassType(type.getName()))}), null).encode();
                ctField.setGenericSignature(sig);
                ctField.setModifiers(1);
                mainContainerClass.addField(ctField);
            }
            mainContainerClass.toClass();
        }
    }

    private static void setOtherAnnotations(DbCellConfig cellField, ConstPool cassConstPool, CtField ctCellField, AnnotationsAttribute otherFieldAttr) {
        List<DbAnnotationConfig> annotationConfigs = cellField.getAnnotationConfigs();
        if (annotationConfigs == null) {
            return;
        }
        for (DbAnnotationConfig annotationConfig : annotationConfigs) {
            Annotation otherXlsCellAnnotation = new Annotation(annotationConfig.getClassName(), cassConstPool);
            List<DbAnnotationMemberConfig> memberConfigList = annotationConfig.getMemberConfigList();
            for (DbAnnotationMemberConfig dbAnnotationMemberConfig : memberConfigList) {
                if (String.class.getName().equals(dbAnnotationMemberConfig.getType())) {
                    otherXlsCellAnnotation.addMemberValue(dbAnnotationMemberConfig.getKey(), (MemberValue)new StringMemberValue(dbAnnotationMemberConfig.getValue(), cassConstPool));
                    continue;
                }
                if (Integer.class.getName().equals(dbAnnotationMemberConfig.getType())) {
                    otherXlsCellAnnotation.addMemberValue(dbAnnotationMemberConfig.getKey(), (MemberValue)new IntegerMemberValue(cassConstPool, Integer.valueOf(dbAnnotationMemberConfig.getValue()).intValue()));
                    continue;
                }
                if (Long.class.getName().equals(dbAnnotationMemberConfig.getType())) {
                    otherXlsCellAnnotation.addMemberValue(dbAnnotationMemberConfig.getKey(), (MemberValue)new LongMemberValue(Long.valueOf(dbAnnotationMemberConfig.getValue()).longValue(), cassConstPool));
                    continue;
                }
                if (Double.class.getName().equals(dbAnnotationMemberConfig.getType())) {
                    otherXlsCellAnnotation.addMemberValue(dbAnnotationMemberConfig.getKey(), (MemberValue)new DoubleMemberValue(Double.valueOf(dbAnnotationMemberConfig.getValue()).doubleValue(), cassConstPool));
                    continue;
                }
                if (Float.class.getName().equals(dbAnnotationMemberConfig.getType())) {
                    otherXlsCellAnnotation.addMemberValue(dbAnnotationMemberConfig.getKey(), (MemberValue)new FloatMemberValue(Float.valueOf(dbAnnotationMemberConfig.getValue()).floatValue(), cassConstPool));
                    continue;
                }
                if (Short.class.getName().equals(dbAnnotationMemberConfig.getType())) {
                    otherXlsCellAnnotation.addMemberValue(dbAnnotationMemberConfig.getKey(), (MemberValue)new ShortMemberValue(Short.valueOf(dbAnnotationMemberConfig.getValue()).shortValue(), cassConstPool));
                    continue;
                }
                if (Boolean.class.getName().equals(dbAnnotationMemberConfig.getType())) {
                    otherXlsCellAnnotation.addMemberValue(dbAnnotationMemberConfig.getKey(), (MemberValue)new BooleanMemberValue(Boolean.valueOf(dbAnnotationMemberConfig.getValue()).booleanValue(), cassConstPool));
                    continue;
                }
                if (Character.class.getName().equals(dbAnnotationMemberConfig.getType())) {
                    otherXlsCellAnnotation.addMemberValue(dbAnnotationMemberConfig.getKey(), (MemberValue)new CharMemberValue(dbAnnotationMemberConfig.getValue().charAt(0), cassConstPool));
                    continue;
                }
                if (Byte.class.getName().equals(dbAnnotationMemberConfig.getType())) {
                    otherXlsCellAnnotation.addMemberValue(dbAnnotationMemberConfig.getKey(), (MemberValue)new ByteMemberValue(dbAnnotationMemberConfig.getValue().getBytes()[0], cassConstPool));
                    continue;
                }
                if (Class.class.getName().equals(dbAnnotationMemberConfig.getType())) {
                    otherXlsCellAnnotation.addMemberValue(dbAnnotationMemberConfig.getKey(), (MemberValue)new ClassMemberValue(dbAnnotationMemberConfig.getValue(), cassConstPool));
                    continue;
                }
                if (Enum.class.getName().equals(dbAnnotationMemberConfig.getType())) {
                    EnumMemberValue value = new EnumMemberValue(cassConstPool);
                    value.setValue(dbAnnotationMemberConfig.getValue());
                    value.setType(dbAnnotationMemberConfig.getType());
                    otherXlsCellAnnotation.addMemberValue(dbAnnotationMemberConfig.getKey(), (MemberValue)value);
                    continue;
                }
                if (Arrays.class.getName().equals(dbAnnotationMemberConfig.getType())) {
                    throw new RuntimeException("not support yet!");
                }
                if (!Annotation.class.getName().equals(dbAnnotationMemberConfig.getType())) continue;
                throw new RuntimeException("not support yet!");
            }
            otherFieldAttr.addAnnotation(otherXlsCellAnnotation);
        }
    }

    static {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        validator = factory.getValidator();
    }
}

