/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.hw.support.util.excel.validation;

import com.cntaiping.hw.support.util.excel.xls.XlsValidation;
import com.cntaiping.hw.support.util.excel.xls.config.ColumnValidation;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;

@XlsValidation
public class DateFormatValidation
implements ColumnValidation {
    @Override
    public String getName() {
        return "Date";
    }

    @Override
    public void validation(Workbook workbook, Sheet sheet, int firstRow, int lastRow, int firstCol, int lastCol) {
        CellRangeAddressList addressList = new CellRangeAddressList(firstRow, lastRow, firstCol, lastCol);
        DataValidationHelper validationHelper = sheet.getDataValidationHelper();
        DataValidationConstraint integerConstraint = validationHelper.createDateConstraint(6, "1000/01/01", "9999/12/31", "YYYY/MM/DD");
        DataValidation dataValidation = validationHelper.createValidation(integerConstraint, addressList);
        dataValidation.setErrorStyle(0);
        dataValidation.setShowErrorBox(true);
        dataValidation.createErrorBox("Invalid Input", "Please enter an Date between 1000-01-01 and 9999-12-31");
        sheet.addValidationData(dataValidation);
    }
}

