/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.hw.support.util.excel.validation;

import com.cntaiping.hw.support.util.excel.utils.ExcelUtil;
import com.cntaiping.hw.support.util.excel.xls.XlsValidation;
import com.cntaiping.hw.support.util.excel.xls.config.ColumnValidation;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;

@XlsValidation
public class EmailFormatValidation
implements ColumnValidation {
    @Override
    public String getName() {
        return "email";
    }

    @Override
    public void validation(Workbook workbook, Sheet sheet, int firstRow, int lastRow, int firstCol, int lastCol) {
        DataValidationHelper validationHelper = sheet.getDataValidationHelper();
        String label = ExcelUtil.getColumnLabel(firstCol) + firstRow;
        String customFormula = "AND(ISNUMBER(FIND(\"@\"," + label + ")),ISNUMBER(FIND(\".\"," + label + ")),NOT(ISNUMBER(FIND(\" \"," + label + "))))";
        CellRangeAddressList addressList = new CellRangeAddressList(firstRow, lastRow, firstCol, lastCol);
        DataValidationConstraint constraint = validationHelper.createCustomConstraint(customFormula);
        DataValidation dataValidation = validationHelper.createValidation(constraint, addressList);
        dataValidation.setSuppressDropDownArrow(true);
        dataValidation.setShowErrorBox(true);
        dataValidation.createErrorBox("Invalid Input", "Please input email.");
        sheet.addValidationData(dataValidation);
    }
}

