/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.hw.support.util.excel.validation;

import com.cntaiping.hw.support.util.excel.xls.XlsValidation;
import com.cntaiping.hw.support.util.excel.xls.config.ColumnValidation;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;

@XlsValidation
public class PositiveIntegerFormatValidation
implements ColumnValidation {
    @Override
    public String getName() {
        return "PositiveInteger";
    }

    @Override
    public void validation(Workbook workbook, Sheet sheet, int firstRow, int lastRow, int firstCol, int lastCol) {
        CellRangeAddressList addressList = new CellRangeAddressList(firstRow, lastRow, firstCol, lastCol);
        DataValidationHelper validationHelper = sheet.getDataValidationHelper();
        DataValidationConstraint integerConstraint = validationHelper.createIntegerConstraint(0, String.valueOf(0), String.valueOf(Integer.MAX_VALUE));
        DataValidation dataValidation = validationHelper.createValidation(integerConstraint, addressList);
        dataValidation.setErrorStyle(0);
        dataValidation.setShowErrorBox(true);
        dataValidation.createErrorBox("\u975e\u6cd5\u8f93\u5165", "\u8bf7\u8f93\u5165 0 \u81f3 2147483647\u4e4b\u95f4\u7684\u6b63\u6574\u6570");
        sheet.addValidationData(dataValidation);
    }
}

