/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.hw.support.util.excel.xls.config;

import com.cntaiping.hw.support.util.excel.xls.XlsCell;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Workbook;

public class XlsCellConfig {
    private Class<?> fieldRealTypeClass;
    private Field field;
    private String headStyle;
    private String validation;
    private String[] headTitle;
    private int index;
    private boolean isArray;
    private String toField;
    private Method setMethod;
    private Method getMethod;
    private Field targetParentField;
    private Method targetParentGetMethod;
    private Method targetParentSetMethod;
    private Field targetField;
    private Method targetSetMethod;
    private Method targetGetMethod;
    private Class<?> innerSheetToClass;
    private String innerSheetToField;
    private int innerSheetRowCount;
    private Field innerSheetField;
    private Method innerSheetSetMethod;
    private Method innerSheetGetMethod;
    private Field innerSheetTargetField;
    private Method innerSheetTargetSetMethod;
    private Method innerSheetTargetGetMethod;
    private int innerSheetIndex;
    private Boolean hidden;
    private String[] innerSheetHeadTitle;
    private String[] innerSheetDefaultValue;
    private String[] dropdown;
    private String dropdownSql;
    private String dropdownCodeType;
    private String dropSplit;
    private String format;
    private Integer columnWeight;
    private Boolean unique;
    private String[] innerSheetExportSortValue;
    private String innerSheetExportSortKey;
    private Field innerSheetExportSortKeyField;

    public XlsCellConfig(XlsCell xlsCell) {
        this.headStyle = xlsCell.headStyle();
        this.validation = xlsCell.validation();
        this.headTitle = xlsCell.headTitle();
        this.index = xlsCell.index();
        this.toField = xlsCell.toField();
        this.innerSheetToClass = xlsCell.innerSheetToClass();
        this.innerSheetRowCount = xlsCell.innerSheetRowCount();
        this.innerSheetToField = xlsCell.innerSheetToField();
        this.dropdown = xlsCell.dropdown();
        this.dropdownSql = xlsCell.dropdownSql();
        this.dropdownCodeType = xlsCell.dropdownCodeType();
        this.dropSplit = xlsCell.dropSplit();
        this.format = xlsCell.format();
        this.columnWeight = xlsCell.columnWeight();
        this.innerSheetHeadTitle = xlsCell.innerSheetHeadTitle();
        this.hidden = xlsCell.hidden();
        this.innerSheetDefaultValue = xlsCell.innerSheetDefaultValue();
        this.unique = xlsCell.unique();
        this.innerSheetExportSortValue = xlsCell.innerSheetExportSortValue();
        this.innerSheetExportSortKey = xlsCell.innerSheetExportSortKey();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XlsCellConfig that = (XlsCellConfig)o;
        return Objects.equals(this.fieldRealTypeClass, that.fieldRealTypeClass) && Objects.equals(this.field, that.field);
    }

    public int hashCode() {
        return Objects.hash(this.fieldRealTypeClass, this.field);
    }

    public CellStyle cellStyle(Workbook workbook, Map<String, CellStyle> cellStyleCache) {
        CellStyle cellStyle = null;
        if (!"".equals(this.format)) {
            cellStyle = cellStyleCache.get(this.format);
            if (cellStyle != null) {
                return cellStyle;
            }
            cellStyle = workbook.createCellStyle();
            CreationHelper creationHelper = workbook.getCreationHelper();
            short format1 = creationHelper.createDataFormat().getFormat(this.format);
            cellStyle.setDataFormat(format1);
            cellStyleCache.put(this.format, cellStyle);
        }
        return cellStyle;
    }

    public Field innerSheetExportSortKeyField() {
        return this.innerSheetExportSortKeyField;
    }

    public XlsCellConfig setInnerSheetExportSortKeyField(Field innerSheetExportSortKeyField) {
        this.innerSheetExportSortKeyField = innerSheetExportSortKeyField;
        return this;
    }

    public String innerSheetExportSortKey() {
        return this.innerSheetExportSortKey;
    }

    public XlsCellConfig setInnerSheetExportSortKey(String innerSheetExportSortKey) {
        this.innerSheetExportSortKey = innerSheetExportSortKey;
        return this;
    }

    public String[] innerSheetExportSortValue() {
        return this.innerSheetExportSortValue;
    }

    public XlsCellConfig setInnerSheetExportSortValue(String[] innerSheetExportSortValue) {
        this.innerSheetExportSortValue = innerSheetExportSortValue;
        return this;
    }

    public Boolean unique() {
        return this.unique;
    }

    public XlsCellConfig unique(Boolean unique) {
        this.unique = unique;
        return this;
    }

    public Field targetParentField() {
        return this.targetParentField;
    }

    public XlsCellConfig targetParentField(Field targetParentField) {
        this.targetParentField = targetParentField;
        return this;
    }

    public Method targetParentGetMethod() {
        return this.targetParentGetMethod;
    }

    public XlsCellConfig targetParentGetMethod(Method targetParentGetMethod) {
        this.targetParentGetMethod = targetParentGetMethod;
        return this;
    }

    public Method targetParentSetMethod() {
        return this.targetParentSetMethod;
    }

    public XlsCellConfig targetParentSetMethod(Method targetParentSetMethod) {
        this.targetParentSetMethod = targetParentSetMethod;
        return this;
    }

    public Boolean hidden() {
        return this.hidden;
    }

    public XlsCellConfig setHidden(Boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    public String[] innerSheetDefaultValue() {
        return this.innerSheetDefaultValue;
    }

    public XlsCellConfig setInnerSheetDefaultValue(String[] innerSheetDefaultValue) {
        this.innerSheetDefaultValue = innerSheetDefaultValue;
        return this;
    }

    public String[] innerSheetHeadTitle() {
        return this.innerSheetHeadTitle;
    }

    public XlsCellConfig innerSheetHeadTitle(String[] innerSheetHeadTitle) {
        this.innerSheetHeadTitle = innerSheetHeadTitle;
        return this;
    }

    public Integer columnWeight() {
        return this.columnWeight;
    }

    public XlsCellConfig columnWeight(Integer columnWeight) {
        this.columnWeight = columnWeight;
        return this;
    }

    public String format() {
        return this.format;
    }

    public XlsCellConfig format(String format) {
        this.format = format;
        return this;
    }

    public String[] dropdown() {
        return this.dropdown;
    }

    public XlsCellConfig dropdown(String[] dropdown) {
        this.dropdown = dropdown;
        return this;
    }

    public String dropdownSql() {
        return this.dropdownSql;
    }

    public XlsCellConfig dropdownSql(String dropdownSql) {
        this.dropdownSql = dropdownSql;
        return this;
    }

    public String dropdownCodeType() {
        return this.dropdownCodeType;
    }

    public XlsCellConfig dropdownCodeType(String dropdownCodeType) {
        this.dropdownCodeType = dropdownCodeType;
        return this;
    }

    public String dropSplit() {
        return this.dropSplit;
    }

    public XlsCellConfig dropSplit(String dropSplit) {
        this.dropSplit = dropSplit;
        return this;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public XlsCellConfig isArray(boolean array) {
        this.isArray = array;
        return this;
    }

    public Class<?> fieldRealTypeClass() {
        return this.fieldRealTypeClass;
    }

    public XlsCellConfig fieldRealTypeClass(Class<?> bindClass) {
        this.fieldRealTypeClass = bindClass;
        return this;
    }

    public Field field() {
        return this.field;
    }

    public XlsCellConfig field(Field bindField) {
        this.field = bindField;
        return this;
    }

    public String headStyle() {
        return this.headStyle;
    }

    public XlsCellConfig headStyle(String styleMethod) {
        this.headStyle = styleMethod;
        return this;
    }

    public String validation() {
        return this.validation;
    }

    public XlsCellConfig validation(String columnStyleMethod) {
        this.validation = columnStyleMethod;
        return this;
    }

    public String[] headTitle() {
        return this.headTitle;
    }

    public XlsCellConfig headTitle(String[] headTitle) {
        this.headTitle = headTitle;
        return this;
    }

    public int index() {
        return this.index;
    }

    public XlsCellConfig index(int index) {
        this.index = index;
        return this;
    }

    public String toField() {
        return this.toField;
    }

    public XlsCellConfig toField(String toField) {
        this.toField = toField;
        return this;
    }

    public Method setMethod() {
        return this.setMethod;
    }

    public XlsCellConfig setMethod(Method setMethod) {
        this.setMethod = setMethod;
        return this;
    }

    public Method getMethod() {
        return this.getMethod;
    }

    public XlsCellConfig getMethod(Method getMethod) {
        this.getMethod = getMethod;
        return this;
    }

    public Field targetField() {
        return this.targetField;
    }

    public XlsCellConfig targetField(Field targetField) {
        this.targetField = targetField;
        return this;
    }

    public Method targetSetMethod() {
        return this.targetSetMethod;
    }

    public XlsCellConfig targetSetMethod(Method targetSetMethod) {
        this.targetSetMethod = targetSetMethod;
        return this;
    }

    public Method targetGetMethod() {
        return this.targetGetMethod;
    }

    public XlsCellConfig targetGetMethod(Method targetGetMethod) {
        this.targetGetMethod = targetGetMethod;
        return this;
    }

    public Class<?> innerSheetToClass() {
        return this.innerSheetToClass;
    }

    public XlsCellConfig innerSheetToClass(Class<?> innerSheetToClass) {
        this.innerSheetToClass = innerSheetToClass;
        return this;
    }

    public String innerSheetToField() {
        return this.innerSheetToField;
    }

    public XlsCellConfig innerSheetToField(String innerSheetToField) {
        this.innerSheetToField = innerSheetToField;
        return this;
    }

    public int innerSheetRowCount() {
        return this.innerSheetRowCount;
    }

    public XlsCellConfig innerSheetRowCount(int innerSheetRowCount) {
        this.innerSheetRowCount = innerSheetRowCount;
        return this;
    }

    public Field innerSheetField() {
        return this.innerSheetField;
    }

    public XlsCellConfig innerSheetField(Field innerSheetField) {
        this.innerSheetField = innerSheetField;
        return this;
    }

    public Method innerSheetSetMethod() {
        return this.innerSheetSetMethod;
    }

    public XlsCellConfig innerSheetSetMethod(Method innerSheetSetMethod) {
        this.innerSheetSetMethod = innerSheetSetMethod;
        return this;
    }

    public Method innerSheetGetMethod() {
        return this.innerSheetGetMethod;
    }

    public XlsCellConfig innerSheetGetMethod(Method innerSheetGetMethod) {
        this.innerSheetGetMethod = innerSheetGetMethod;
        return this;
    }

    public Field innerSheetTargetField() {
        return this.innerSheetTargetField;
    }

    public XlsCellConfig innerSheetTargetField(Field innerSheetTargetField) {
        this.innerSheetTargetField = innerSheetTargetField;
        return this;
    }

    public Method innerSheetTargetSetMethod() {
        return this.innerSheetTargetSetMethod;
    }

    public XlsCellConfig innerSheetTargetSetMethod(Method innerSheetTargetSetMethod) {
        this.innerSheetTargetSetMethod = innerSheetTargetSetMethod;
        return this;
    }

    public Method innerSheetTargetGetMethod() {
        return this.innerSheetTargetGetMethod;
    }

    public XlsCellConfig innerSheetTargetGetMethod(Method innerSheetTargetGetMethod) {
        this.innerSheetTargetGetMethod = innerSheetTargetGetMethod;
        return this;
    }

    public int innerSheetIndex() {
        return this.innerSheetIndex;
    }

    public XlsCellConfig innerSheetIndex(int innerSheetIndex) {
        this.innerSheetIndex = innerSheetIndex;
        return this;
    }
}

