/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tc.core.transaction.tcc.control;

import com.codingapi.txlcn.common.exception.TransactionClearException;
import com.codingapi.txlcn.common.exception.TransactionException;
import com.codingapi.txlcn.common.util.function.Supplier;
import com.codingapi.txlcn.tc.core.DTXLocalContext;
import com.codingapi.txlcn.tc.core.DTXLocalControl;
import com.codingapi.txlcn.tc.core.TccTransactionInfo;
import com.codingapi.txlcn.tc.core.TxTransactionInfo;
import com.codingapi.txlcn.tc.core.context.TCGlobalContext;
import com.codingapi.txlcn.tc.core.template.TransactionCleanTemplate;
import com.codingapi.txlcn.tc.core.template.TransactionControlTemplate;
import com.codingapi.txlcn.tc.core.transaction.tcc.control.TccStartingTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="control_tcc_running")
public class TccRunningTransaction
implements DTXLocalControl {
    private static final Logger log = LoggerFactory.getLogger(TccRunningTransaction.class);
    private final TCGlobalContext globalContext;
    private final TransactionCleanTemplate transactionCleanTemplate;
    private final TransactionControlTemplate transactionControlTemplate;

    @Autowired
    public TccRunningTransaction(TransactionCleanTemplate transactionCleanTemplate, TransactionControlTemplate transactionControlTemplate, TCGlobalContext globalContext) {
        this.transactionCleanTemplate = transactionCleanTemplate;
        this.transactionControlTemplate = transactionControlTemplate;
        this.globalContext = globalContext;
    }

    @Override
    public void preBusinessCode(TxTransactionInfo info) throws TransactionException {
        try {
            this.globalContext.tccTransactionInfo(info.getUnitId(), (Supplier<TccTransactionInfo, TransactionException>)((Supplier)() -> TccStartingTransaction.prepareTccInfo(info))).setMethodParameter(info.getTransactionInfo().getArgumentValues());
        }
        catch (Throwable throwable) {
            throw new TransactionException(throwable);
        }
    }

    @Override
    public void onBusinessCodeError(TxTransactionInfo info, Throwable throwable) {
        try {
            this.transactionCleanTemplate.clean(DTXLocalContext.cur().getGroupId(), info.getUnitId(), info.getTransactionType(), 0);
        }
        catch (TransactionClearException e) {
            log.error("tcc > clean transaction error.", (Throwable)e);
        }
    }

    @Override
    public void onBusinessCodeSuccess(TxTransactionInfo info, Object result) throws TransactionException {
        this.transactionControlTemplate.joinGroup(info.getGroupId(), info.getUnitId(), info.getTransactionType(), info.getTransactionInfo());
    }
}

