/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tc.core.transaction.txc.analy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.ItemsListVisitor;
import net.sf.jsqlparser.expression.operators.relational.MultiExpressionList;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.SubSelect;
import org.aspectj.util.Reflection;

public class PrimaryKeyListVisitor
implements ItemsListVisitor {
    private List<Column> columns;
    private List<String> primaryKeys;
    private Table table;
    private List<Map<String, Object>> primaryKeyValuesList;

    public PrimaryKeyListVisitor(Table table, List<Column> columns, List<String> primaryKeys) {
        this.columns = columns;
        this.primaryKeys = primaryKeys;
        this.table = table;
    }

    public void visit(SubSelect subSelect) {
    }

    public void visit(ExpressionList expressionList) {
        this.primaryKeyValuesList = new ArrayList<Map<String, Object>>();
        this.primaryKeyValuesList.add(this.newKeyValues(expressionList.getExpressions()));
    }

    public void visit(MultiExpressionList multiExprList) {
        this.primaryKeyValuesList = new ArrayList<Map<String, Object>>(multiExprList.getExprList().size());
        multiExprList.getExprList().forEach(expressionList -> this.primaryKeyValuesList.add(this.newKeyValues(expressionList.getExpressions())));
    }

    public List<Map<String, Object>> getPrimaryKeyValuesList() {
        return this.primaryKeyValuesList;
    }

    private Map<String, Object> newKeyValues(List<Expression> expressions) {
        HashMap<String, Object> keyValues = new HashMap<String, Object>();
        for (int i = 0; i < this.columns.size(); ++i) {
            this.columns.get(i).setTable(this.table);
            if (!this.primaryKeys.contains(this.columns.get(i).getFullyQualifiedName())) continue;
            Object expression = expressions.get(i).getASTNode().jjtGetValue();
            keyValues.put(this.columns.get(i).getFullyQualifiedName(), Reflection.invokeN(expression.getClass(), (String)"getValue", (Object)expression, (Object[])new Object[0]));
        }
        return keyValues;
    }
}

