/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tc.core.transaction.txc.analy.util;

import com.codingapi.txlcn.common.exception.SerializerException;
import com.codingapi.txlcn.common.util.serializer.SerializerContext;
import com.codingapi.txlcn.tc.core.transaction.txc.analy.def.bean.FieldCluster;
import com.codingapi.txlcn.tc.core.transaction.txc.analy.def.bean.FieldValue;
import com.codingapi.txlcn.tc.core.transaction.txc.analy.def.bean.ModifiedRecord;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;

public class SqlUtils {
    public static final String SQL_COMMA_SEPARATOR = ", ";
    public static final String DOT = ".";
    public static final String AND = " and ";
    public static final String OR = " or ";
    public static final String UPDATE = "UPDATE ";
    public static final String INSERT = "INSERT INTO ";
    public static final String DELETE = "DELETE ";
    public static final String SELECT = "SELECT ";
    public static final String FROM = " FROM ";
    public static final String WHERE = " WHERE ";
    public static final String SET = " SET ";
    public static final int MYSQL_TABLE_NOT_EXISTS_CODE = 1146;
    public static final String FOR_UPDATE = "FOR UPDATE";
    public static final String LOCK_IN_SHARE_MODE = "LOCK IN SHARE MODE";
    public static final int SQL_TYPE_INSERT = 1;
    public static final int SQL_TYPE_DELETE = 2;
    public static final int SQL_TYPE_UPDATE = 3;
    public static final int SQL_TYPE_SELECT = 4;

    public static String tableName(String fieldFullyQualifiedName) {
        if (fieldFullyQualifiedName.contains(DOT)) {
            return fieldFullyQualifiedName.substring(0, fieldFullyQualifiedName.indexOf(DOT));
        }
        return null;
    }

    public static void cutSuffix(String suffix, StringBuilder stringBuilder) {
        if (stringBuilder.substring(stringBuilder.length() - suffix.length()).equals(suffix)) {
            stringBuilder.delete(stringBuilder.length() - suffix.length(), stringBuilder.length());
        }
    }

    public static ModifiedRecord recordByColumns(ResultSet rs, List<String> columns) throws SQLException {
        ModifiedRecord record = new ModifiedRecord();
        for (String column : columns) {
            FieldValue fieldValue = new FieldValue();
            fieldValue.setFieldName(column);
            fieldValue.setTableName(SqlUtils.tableName(column));
            fieldValue.setValue(rs.getObject(column));
            fieldValue.setValueType(Objects.isNull(fieldValue.getValue()) ? Void.class : fieldValue.getValue().getClass());
            if (record.getFieldClusters().get(fieldValue.getTableName()) != null) {
                record.getFieldClusters().get(fieldValue.getTableName()).getFields().add(fieldValue);
                continue;
            }
            FieldCluster fieldCluster = new FieldCluster();
            fieldCluster.getFields().add(fieldValue);
            record.getFieldClusters().put(fieldValue.getTableName(), fieldCluster);
        }
        return record;
    }

    public static byte[] objectToBlob(Object o) {
        try {
            return SerializerContext.getInstance().serialize(o);
        }
        catch (SerializerException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T blobToObject(byte[] blob, Class<T> type) {
        try {
            return (T)SerializerContext.getInstance().deSerialize(blob, type);
        }
        catch (SerializerException e) {
            throw new IllegalStateException(e);
        }
    }
}

