/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tm.cluster;

import com.codingapi.txlcn.common.runner.TxLcnInitializer;
import com.codingapi.txlcn.common.util.ApplicationInformation;
import com.codingapi.txlcn.tm.cluster.TMProperties;
import com.codingapi.txlcn.tm.config.TxManagerConfig;
import com.codingapi.txlcn.tm.core.storage.FastStorage;
import com.codingapi.txlcn.txmsg.params.NotifyConnectParams;
import java.net.ConnectException;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

@Component
public class TMAutoCluster
implements TxLcnInitializer {
    private static final Logger log = LoggerFactory.getLogger(TMAutoCluster.class);
    private final FastStorage fastStorage;
    private final RestTemplate restTemplate;
    private final TxManagerConfig txManagerConfig;
    private static final String MANAGER_REFRESH_URL = "http://%s:%s/manager/refresh";
    private final ServerProperties serverProperties;

    @Autowired
    public TMAutoCluster(FastStorage fastStorage, RestTemplate restTemplate, TxManagerConfig txManagerConfig, ServerProperties serverProperties) {
        this.fastStorage = fastStorage;
        this.restTemplate = restTemplate;
        this.txManagerConfig = txManagerConfig;
        this.serverProperties = serverProperties;
    }

    public void init() throws Exception {
        List tmList = this.fastStorage.findTMProperties().stream().filter(tmProperties -> !tmProperties.getHost().equals(this.txManagerConfig.getHost()) || !tmProperties.getTransactionPort().equals(this.txManagerConfig.getPort())).collect(Collectors.toList());
        for (TMProperties properties : tmList) {
            NotifyConnectParams notifyConnectParams = new NotifyConnectParams();
            notifyConnectParams.setHost(this.txManagerConfig.getHost());
            notifyConnectParams.setPort(this.txManagerConfig.getPort());
            String url = String.format(MANAGER_REFRESH_URL, properties.getHost(), properties.getHttpPort());
            try {
                ResponseEntity res = this.restTemplate.postForEntity(url, (Object)notifyConnectParams, Boolean.class, new Object[0]);
                if (res.getStatusCode().equals((Object)HttpStatus.OK) || res.getStatusCode().is5xxServerError()) {
                    log.info("manager auto refresh res->{}", (Object)res);
                    break;
                }
                this.fastStorage.removeTMProperties(properties.getHost(), properties.getTransactionPort());
            }
            catch (Exception e) {
                ResourceAccessException resourceAccessException;
                log.error("manager auto refresh error: {}", (Object)e.getMessage());
                if (!(e instanceof ResourceAccessException) || (resourceAccessException = (ResourceAccessException)e).getCause() == null || !(resourceAccessException.getCause() instanceof ConnectException)) continue;
                this.fastStorage.removeTMProperties(properties.getHost(), properties.getTransactionPort());
            }
        }
        if (StringUtils.hasText((String)this.txManagerConfig.getHost())) {
            TMProperties tmProperties2 = new TMProperties();
            tmProperties2.setHttpPort(ApplicationInformation.serverPort((ServerProperties)this.serverProperties));
            tmProperties2.setHost(this.txManagerConfig.getHost());
            tmProperties2.setTransactionPort(this.txManagerConfig.getPort());
            this.fastStorage.saveTMProperties(tmProperties2);
        }
    }

    public void destroy() throws Exception {
        this.fastStorage.removeTMProperties(this.txManagerConfig.getHost(), this.txManagerConfig.getPort());
    }

    public int order() {
        return Integer.MAX_VALUE;
    }
}

