/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tm.core;

import com.codingapi.txlcn.common.exception.FastStorageException;
import com.codingapi.txlcn.common.exception.TransactionException;
import com.codingapi.txlcn.tm.core.DTXContext;
import com.codingapi.txlcn.tm.core.storage.FastStorage;
import com.codingapi.txlcn.tm.core.storage.TransactionUnit;
import java.util.List;

public class DefaultDTXContext
implements DTXContext {
    private final FastStorage fastStorage;
    private final String groupId;

    DefaultDTXContext(String groupId, FastStorage fastStorage) {
        this.fastStorage = fastStorage;
        this.groupId = groupId;
    }

    @Override
    public void join(TransactionUnit transactionUnit) throws TransactionException {
        try {
            this.fastStorage.saveTransactionUnitToGroup(this.groupId, transactionUnit);
        }
        catch (FastStorageException e) {
            throw new TransactionException("attempts to join the non-existent transaction group. [" + transactionUnit.getUnitId() + '@' + transactionUnit.getModId() + ']');
        }
    }

    @Override
    public void resetTransactionState(int state) throws TransactionException {
        try {
            this.fastStorage.saveTransactionState(this.groupId, state);
        }
        catch (FastStorageException e) {
            throw new TransactionException((Throwable)e);
        }
    }

    @Override
    public List<TransactionUnit> transactionUnits() throws TransactionException {
        try {
            return this.fastStorage.findTransactionUnitsFromGroup(this.groupId);
        }
        catch (FastStorageException e) {
            throw new TransactionException((Throwable)e);
        }
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public int transactionState() {
        try {
            return this.fastStorage.getTransactionState(this.groupId);
        }
        catch (FastStorageException e) {
            return -1;
        }
    }
}

