/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tm.support.service.impl;

import com.codingapi.txlcn.common.exception.TxManagerException;
import com.codingapi.txlcn.common.util.id.RandomUtils;
import com.codingapi.txlcn.logger.db.LogDbProperties;
import com.codingapi.txlcn.logger.db.TxLog;
import com.codingapi.txlcn.logger.exception.TxLoggerException;
import com.codingapi.txlcn.logger.helper.TxLcnLogDbHelper;
import com.codingapi.txlcn.logger.model.Field;
import com.codingapi.txlcn.logger.model.GroupId;
import com.codingapi.txlcn.logger.model.LogList;
import com.codingapi.txlcn.logger.model.StartTime;
import com.codingapi.txlcn.logger.model.StopTime;
import com.codingapi.txlcn.logger.model.Tag;
import com.codingapi.txlcn.tm.config.TxManagerConfig;
import com.codingapi.txlcn.tm.support.restapi.auth.DefaultTokenStorage;
import com.codingapi.txlcn.tm.support.restapi.vo.DTXInfo;
import com.codingapi.txlcn.tm.support.restapi.vo.DeleteLogsReq;
import com.codingapi.txlcn.tm.support.restapi.vo.ListAppMods;
import com.codingapi.txlcn.tm.support.restapi.vo.TxLogList;
import com.codingapi.txlcn.tm.support.restapi.vo.TxManagerInfo;
import com.codingapi.txlcn.tm.support.restapi.vo.TxManagerLog;
import com.codingapi.txlcn.tm.support.service.AdminService;
import com.codingapi.txlcn.txmsg.RpcClient;
import com.codingapi.txlcn.txmsg.dto.AppInfo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.stereotype.Service;

@Service
public class AdminServiceImpl
implements AdminService {
    private final TxManagerConfig managerConfig;
    private final LogDbProperties logDbProperties;
    private final DefaultTokenStorage defaultTokenStorage;
    private final TxLcnLogDbHelper txLoggerHelper;
    private final RpcClient rpcClient;

    @Autowired
    public AdminServiceImpl(TxManagerConfig managerConfig, DefaultTokenStorage defaultTokenStorage, TxLcnLogDbHelper txLoggerHelper, RpcClient rpcClient, LogDbProperties logDbProperties) {
        this.managerConfig = managerConfig;
        this.defaultTokenStorage = defaultTokenStorage;
        this.txLoggerHelper = txLoggerHelper;
        this.rpcClient = rpcClient;
        this.logDbProperties = logDbProperties;
    }

    @Override
    public String login(String password) throws TxManagerException {
        if (this.managerConfig.getAdminKey().equals(password)) {
            String token = RandomUtils.getUUID();
            this.defaultTokenStorage.add(token);
            return token;
        }
        throw new TxManagerException("password error.");
    }

    @Override
    public TxLogList txLogList(Integer page, Integer limit, String groupId, String tag, String startTime, String stopTime, Integer timeOrder) throws TxManagerException {
        LogList logList;
        if (Objects.isNull(page) || page < 1) {
            page = 1;
        }
        if (Objects.isNull(limit) || limit < 1) {
            limit = 10;
        }
        if (Objects.isNull(timeOrder) || timeOrder < 1 || timeOrder > 2) {
            timeOrder = 2;
        }
        List list = Stream.of(new GroupId(groupId), new Tag(tag), new StartTime(startTime), new StopTime(stopTime)).filter(Field::ok).collect(Collectors.toList());
        try {
            logList = this.txLoggerHelper.findByLimitAndFields(page.intValue(), limit.intValue(), timeOrder.intValue(), list);
        }
        catch (TxLoggerException e) {
            throw new TxManagerException((Throwable)e);
        }
        ArrayList<TxManagerLog> txManagerLogs = new ArrayList<TxManagerLog>(logList.getTxLogs().size());
        for (TxLog txLog : logList.getTxLogs()) {
            TxManagerLog txManagerLog = new TxManagerLog();
            BeanUtils.copyProperties((Object)txLog, (Object)txManagerLog);
            txManagerLogs.add(txManagerLog);
        }
        TxLogList txLogList = new TxLogList();
        txLogList.setTotal(logList.getTotal());
        txLogList.setLogs(txManagerLogs);
        return txLogList;
    }

    @Override
    public void deleteLogs(DeleteLogsReq deleteLogsReq) throws TxManagerException {
        List list = Stream.of(new GroupId(deleteLogsReq.getGroupId()), new Tag(deleteLogsReq.getTag()), new StartTime(deleteLogsReq.getLTime()), new StopTime(deleteLogsReq.getRTime())).filter(Field::ok).collect(Collectors.toList());
        try {
            this.txLoggerHelper.deleteByFields(list);
        }
        catch (TxLoggerException e) {
            throw new TxManagerException((Throwable)e);
        }
    }

    @Override
    public DTXInfo dtxInfo() {
        return new DTXInfo();
    }

    @Override
    public TxManagerInfo getTxManagerInfo() {
        TxManagerInfo txManagerInfo = new TxManagerInfo();
        txManagerInfo.setClientCount(this.rpcClient.loadAllRemoteKey().size());
        txManagerInfo.setConcurrentLevel(Math.max((int)((double)Runtime.getRuntime().availableProcessors() / 0.19999999999999996), this.managerConfig.getConcurrentLevel()));
        txManagerInfo.setDtxTime(this.managerConfig.getDtxTime());
        txManagerInfo.setHeartbeatTime(this.managerConfig.getHeartTime());
        txManagerInfo.setSocketHost(this.managerConfig.getHost());
        txManagerInfo.setSocketPort(this.managerConfig.getPort());
        txManagerInfo.setExUrl(this.managerConfig.isExUrlEnabled() ? this.managerConfig.getExUrl() : "disabled");
        txManagerInfo.setEnableTxLogger(String.valueOf(this.logDbProperties.isEnabled()));
        txManagerInfo.setTmVersion("5.0.2.RELEASE");
        return txManagerInfo;
    }

    @Override
    public ListAppMods listAppMods(Integer page, Integer limit) {
        if (Objects.isNull(limit) || limit < 1) {
            limit = 10;
        }
        if (Objects.isNull(page) || page < 1) {
            page = 1;
        }
        ArrayList<ListAppMods.AppMod> appMods = new ArrayList<ListAppMods.AppMod>(limit);
        int firIdx = (page - 1) * limit;
        List apps = this.rpcClient.apps();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (int i = 0; i < apps.size() && firIdx <= apps.size() - 1; ++i) {
            if (i < firIdx) continue;
            AppInfo appInfo = (AppInfo)apps.get(i);
            ListAppMods.AppMod appMod = new ListAppMods.AppMod();
            PropertyMapper.get().from(() -> ((AppInfo)appInfo).getAppName()).to(appMod::setModName);
            PropertyMapper.get().from(() -> ((AppInfo)appInfo).getLabelName()).to(appMod::setModId);
            PropertyMapper.get().from(() -> ((AppInfo)appInfo).getCreateTime()).to(t -> appMod.setRegisterTime(dateFormat.format((Date)t)));
            appMods.add(appMod);
        }
        ListAppMods listAppMods = new ListAppMods();
        listAppMods.setTotal(apps.size());
        listAppMods.setAppMods(appMods);
        return listAppMods;
    }
}

