/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tm.txmsg;

import com.codingapi.txlcn.common.runner.TxLcnInitializer;
import com.codingapi.txlcn.tm.config.TxManagerConfig;
import com.codingapi.txlcn.txmsg.RpcConfig;
import com.codingapi.txlcn.txmsg.RpcServerInitializer;
import com.codingapi.txlcn.txmsg.dto.ManagerProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TMRpcServer
implements TxLcnInitializer {
    private final TxManagerConfig txManagerConfig;
    private final RpcServerInitializer rpcServerInitializer;
    private final RpcConfig rpcConfig;

    @Autowired
    public TMRpcServer(TxManagerConfig txManagerConfig, RpcServerInitializer rpcServerInitializer, RpcConfig rpcConfig) {
        this.txManagerConfig = txManagerConfig;
        this.rpcServerInitializer = rpcServerInitializer;
        this.rpcConfig = rpcConfig;
    }

    public void init() {
        if (this.rpcConfig.getWaitTime() <= 5L) {
            this.rpcConfig.setWaitTime(1000L);
        }
        if (this.rpcConfig.getAttrDelayTime() < 0L) {
            this.rpcConfig.setAttrDelayTime(this.txManagerConfig.getDtxTime());
        }
        ManagerProperties managerProperties = new ManagerProperties();
        managerProperties.setCheckTime(this.txManagerConfig.getHeartTime());
        managerProperties.setRpcPort(this.txManagerConfig.getPort());
        managerProperties.setRpcHost(this.txManagerConfig.getHost());
        this.rpcServerInitializer.init(managerProperties);
    }

    public int order() {
        return Integer.MIN_VALUE;
    }
}

