/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tm.txmsg.transaction;

import com.codingapi.txlcn.common.exception.FastStorageException;
import com.codingapi.txlcn.common.exception.TxManagerException;
import com.codingapi.txlcn.tm.core.storage.FastStorage;
import com.codingapi.txlcn.tm.core.storage.LockValue;
import com.codingapi.txlcn.tm.txmsg.RpcExecuteService;
import com.codingapi.txlcn.tm.txmsg.TransactionCmd;
import com.codingapi.txlcn.txmsg.params.DTXLockParams;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="rpc_acquire-dtx-lock")
public class AcquireDTXLockExecuteService
implements RpcExecuteService {
    private final FastStorage fastStorage;

    @Autowired
    public AcquireDTXLockExecuteService(FastStorage fastStorage) {
        this.fastStorage = fastStorage;
    }

    @Override
    public Serializable execute(TransactionCmd transactionCmd) throws TxManagerException {
        DTXLockParams dtxLockParams = (DTXLockParams)transactionCmd.getMsg().loadBean(DTXLockParams.class);
        try {
            LockValue lockValue = new LockValue();
            lockValue.setGroupId(dtxLockParams.getGroupId());
            lockValue.setLockType(dtxLockParams.getLockType());
            this.fastStorage.acquireLocks(dtxLockParams.getContextId(), dtxLockParams.getLocks(), lockValue);
            return Boolean.valueOf(true);
        }
        catch (FastStorageException e) {
            throw new TxManagerException((Throwable)e);
        }
    }
}

