/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tm.txmsg.transaction;

import com.codingapi.txlcn.common.exception.TransactionException;
import com.codingapi.txlcn.common.exception.TxManagerException;
import com.codingapi.txlcn.logger.TxLogger;
import com.codingapi.txlcn.tm.core.DTXContext;
import com.codingapi.txlcn.tm.core.DTXContextRegistry;
import com.codingapi.txlcn.tm.core.TransactionManager;
import com.codingapi.txlcn.tm.txmsg.RpcExecuteService;
import com.codingapi.txlcn.tm.txmsg.TransactionCmd;
import com.codingapi.txlcn.txmsg.RpcClient;
import com.codingapi.txlcn.txmsg.params.JoinGroupParams;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rpc_join-group")
public class JoinGroupExecuteService
implements RpcExecuteService {
    private static final TxLogger txLogger = TxLogger.newLogger(JoinGroupExecuteService.class);
    private final TransactionManager transactionManager;
    private final DTXContextRegistry dtxContextRegistry;
    private final RpcClient rpcClient;

    @Autowired
    public JoinGroupExecuteService(TransactionManager transactionManager, DTXContextRegistry dtxContextRegistry, RpcClient rpcClient) {
        this.transactionManager = transactionManager;
        this.dtxContextRegistry = dtxContextRegistry;
        this.rpcClient = rpcClient;
    }

    @Override
    public Serializable execute(TransactionCmd transactionCmd) throws TxManagerException {
        try {
            DTXContext dtxContext = this.dtxContextRegistry.get(transactionCmd.getGroupId());
            JoinGroupParams joinGroupParams = (JoinGroupParams)transactionCmd.getMsg().loadBean(JoinGroupParams.class);
            txLogger.txTrace(transactionCmd.getGroupId(), joinGroupParams.getUnitId(), "unit:{} try join group:{}", new Object[]{joinGroupParams.getUnitId(), transactionCmd.getGroupId()});
            this.transactionManager.join(dtxContext, joinGroupParams.getUnitId(), joinGroupParams.getUnitType(), this.rpcClient.getAppName(transactionCmd.getRemoteKey()), joinGroupParams.getTransactionState());
            txLogger.txTrace(transactionCmd.getGroupId(), joinGroupParams.getUnitId(), "unit:{} joined.", new Object[]{joinGroupParams.getUnitId()});
        }
        catch (TransactionException e) {
            txLogger.error(this.getClass().getSimpleName(), e.getMessage(), new Object[0]);
            throw new TxManagerException(e.getLocalizedMessage());
        }
        return null;
    }
}

