/*
 * Decompiled with CFR 0.152.
 */
package com.coreos.jetcd.internal.impl;

import com.coreos.jetcd.Cluster;
import com.coreos.jetcd.api.ClusterGrpc;
import com.coreos.jetcd.api.MemberAddRequest;
import com.coreos.jetcd.api.MemberListRequest;
import com.coreos.jetcd.api.MemberRemoveRequest;
import com.coreos.jetcd.api.MemberUpdateRequest;
import com.coreos.jetcd.cluster.MemberAddResponse;
import com.coreos.jetcd.cluster.MemberListResponse;
import com.coreos.jetcd.cluster.MemberRemoveResponse;
import com.coreos.jetcd.cluster.MemberUpdateResponse;
import com.coreos.jetcd.internal.impl.ClientConnectionManager;
import com.coreos.jetcd.internal.impl.Util;
import java.util.List;
import java.util.concurrent.CompletableFuture;

class ClusterImpl
implements Cluster {
    private final ClusterGrpc.ClusterFutureStub stub;
    private final ClientConnectionManager connectionManager;

    ClusterImpl(ClientConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        this.stub = connectionManager.newStub(ClusterGrpc::newFutureStub);
    }

    @Override
    public CompletableFuture<MemberListResponse> listMember() {
        return Util.toCompletableFuture(this.stub.memberList(MemberListRequest.getDefaultInstance()), MemberListResponse::new, this.connectionManager.getExecutorService());
    }

    @Override
    public CompletableFuture<MemberAddResponse> addMember(List<String> peerAddrs) {
        MemberAddRequest memberAddRequest = MemberAddRequest.newBuilder().addAllPeerURLs(peerAddrs).build();
        return Util.toCompletableFuture(this.stub.memberAdd(memberAddRequest), MemberAddResponse::new, this.connectionManager.getExecutorService());
    }

    @Override
    public CompletableFuture<MemberRemoveResponse> removeMember(long memberID) {
        MemberRemoveRequest memberRemoveRequest = MemberRemoveRequest.newBuilder().setID(memberID).build();
        return Util.toCompletableFuture(this.stub.memberRemove(memberRemoveRequest), MemberRemoveResponse::new, this.connectionManager.getExecutorService());
    }

    @Override
    public CompletableFuture<MemberUpdateResponse> updateMember(long memberID, List<String> peerAddrs) {
        MemberUpdateRequest memberUpdateRequest = MemberUpdateRequest.newBuilder().addAllPeerURLs(peerAddrs).setID(memberID).build();
        return Util.toCompletableFuture(this.stub.memberUpdate(memberUpdateRequest), MemberUpdateResponse::new, this.connectionManager.getExecutorService());
    }
}

