/*
 * Decompiled with CFR 0.152.
 */
package com.coreos.jetcd.internal.impl;

import com.coreos.jetcd.Lock;
import com.coreos.jetcd.api.lock.LockGrpc;
import com.coreos.jetcd.api.lock.LockRequest;
import com.coreos.jetcd.api.lock.UnlockRequest;
import com.coreos.jetcd.data.ByteSequence;
import com.coreos.jetcd.internal.impl.ClientConnectionManager;
import com.coreos.jetcd.internal.impl.Util;
import com.coreos.jetcd.lock.LockResponse;
import com.coreos.jetcd.lock.UnlockResponse;
import com.google.common.base.Preconditions;
import java.util.concurrent.CompletableFuture;

class LockImpl
implements Lock {
    private final ClientConnectionManager connectionManager;
    private final LockGrpc.LockFutureStub stub;

    LockImpl(ClientConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        this.stub = connectionManager.newStub(LockGrpc::newFutureStub);
    }

    @Override
    public CompletableFuture<LockResponse> lock(ByteSequence name, long leaseId) {
        Preconditions.checkNotNull((Object)name);
        LockRequest request = LockRequest.newBuilder().setName(name.getByteString()).setLease(leaseId).build();
        return Util.toCompletableFutureWithRetry(() -> this.stub.lock(request), LockResponse::new, Util::isRetriable, this.connectionManager.getExecutorService());
    }

    @Override
    public CompletableFuture<UnlockResponse> unlock(ByteSequence lockKey) {
        Preconditions.checkNotNull((Object)lockKey);
        UnlockRequest request = UnlockRequest.newBuilder().setKey(lockKey.getByteString()).build();
        return Util.toCompletableFutureWithRetry(() -> this.stub.unlock(request), UnlockResponse::new, Util::isRetriable, this.connectionManager.getExecutorService());
    }
}

