/*
 * Decompiled with CFR 0.152.
 */
package com.coreos.jetcd.op;

import com.coreos.jetcd.api.Compare;
import com.coreos.jetcd.data.ByteSequence;
import com.coreos.jetcd.op.CmpTarget;
import com.google.protobuf.ByteString;

public class Cmp {
    private final ByteString key;
    private final Op op;
    private final CmpTarget<?> target;

    public Cmp(ByteSequence key, Op compareOp, CmpTarget<?> target) {
        this.key = ByteString.copyFrom((byte[])key.getBytes());
        this.op = compareOp;
        this.target = target;
    }

    Compare toCompare() {
        Compare.Builder compareBuiler = Compare.newBuilder().setKey(this.key);
        switch (this.op) {
            case EQUAL: {
                compareBuiler.setResult(Compare.CompareResult.EQUAL);
                break;
            }
            case GREATER: {
                compareBuiler.setResult(Compare.CompareResult.GREATER);
                break;
            }
            case LESS: {
                compareBuiler.setResult(Compare.CompareResult.LESS);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected compare type (" + (Object)((Object)this.op) + ")");
            }
        }
        Compare.CompareTarget target = this.target.getTarget();
        Object value = this.target.getTargetValue();
        compareBuiler.setTarget(target);
        switch (target) {
            case VERSION: {
                compareBuiler.setVersion((Long)value);
                break;
            }
            case VALUE: {
                compareBuiler.setValue((ByteString)value);
                break;
            }
            case MOD: {
                compareBuiler.setModRevision((Long)value);
                break;
            }
            case CREATE: {
                compareBuiler.setCreateRevision((Long)value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected target type (" + (Object)((Object)target) + ")");
            }
        }
        return compareBuiler.build();
    }

    public static enum Op {
        EQUAL,
        GREATER,
        LESS;

    }
}

