/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.internals;

import com.ctrip.framework.apollo.build.ApolloInjector;
import com.ctrip.framework.apollo.core.utils.ClassLoaderUtil;
import com.ctrip.framework.apollo.exceptions.ApolloConfigException;
import com.ctrip.framework.apollo.internals.AbstractConfigRepository;
import com.ctrip.framework.apollo.internals.ConfigRepository;
import com.ctrip.framework.apollo.internals.RepositoryChangeListener;
import com.ctrip.framework.apollo.tracer.Tracer;
import com.ctrip.framework.apollo.tracer.spi.Transaction;
import com.ctrip.framework.apollo.util.ConfigUtil;
import com.ctrip.framework.apollo.util.ExceptionUtil;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileConfigRepository
extends AbstractConfigRepository
implements RepositoryChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(LocalFileConfigRepository.class);
    private static final String CONFIG_DIR = "/config-cache";
    private final String m_namespace;
    private File m_baseDir;
    private final ConfigUtil m_configUtil;
    private volatile Properties m_fileProperties;
    private volatile ConfigRepository m_upstream;

    public LocalFileConfigRepository(String namespace) {
        this(namespace, null);
    }

    public LocalFileConfigRepository(String namespace, ConfigRepository upstream) {
        this.m_namespace = namespace;
        this.m_configUtil = ApolloInjector.getInstance(ConfigUtil.class);
        this.setLocalCacheDir(this.findLocalCacheDir(), false);
        this.setUpstreamRepository(upstream);
        this.trySync();
    }

    void setLocalCacheDir(File baseDir, boolean syncImmediately) {
        this.m_baseDir = baseDir;
        this.checkLocalConfigCacheDir(this.m_baseDir);
        if (syncImmediately) {
            this.trySync();
        }
    }

    private File findLocalCacheDir() {
        try {
            String defaultCacheDir = this.m_configUtil.getDefaultLocalCacheDir();
            Path path = Paths.get(defaultCacheDir, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            if (Files.exists(path, new LinkOption[0]) && Files.isWritable(path)) {
                return new File(defaultCacheDir, CONFIG_DIR);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new File(ClassLoaderUtil.getClassPath(), CONFIG_DIR);
    }

    @Override
    public Properties getConfig() {
        if (this.m_fileProperties == null) {
            this.sync();
        }
        Properties result = new Properties();
        result.putAll((Map<?, ?>)this.m_fileProperties);
        return result;
    }

    @Override
    public void setUpstreamRepository(ConfigRepository upstreamConfigRepository) {
        if (upstreamConfigRepository == null) {
            return;
        }
        if (this.m_upstream != null) {
            this.m_upstream.removeChangeListener(this);
        }
        this.m_upstream = upstreamConfigRepository;
        this.trySyncFromUpstream();
        upstreamConfigRepository.addChangeListener(this);
    }

    @Override
    public void onRepositoryChange(String namespace, Properties newProperties) {
        if (newProperties.equals(this.m_fileProperties)) {
            return;
        }
        Properties newFileProperties = new Properties();
        newFileProperties.putAll((Map<?, ?>)newProperties);
        this.updateFileProperties(newFileProperties);
        this.fireRepositoryChange(namespace, newProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sync() {
        boolean syncFromUpstreamResultSuccess = this.trySyncFromUpstream();
        if (syncFromUpstreamResultSuccess) {
            return;
        }
        Transaction transaction = Tracer.newTransaction((String)"Apollo.ConfigService", (String)"syncLocalConfig");
        Throwable exception = null;
        try {
            transaction.addData("Basedir", (Object)this.m_baseDir.getAbsolutePath());
            this.m_fileProperties = this.loadFromLocalCacheFile(this.m_baseDir, this.m_namespace);
            transaction.setStatus("0");
        }
        catch (Throwable ex) {
            Tracer.logEvent((String)"ApolloConfigException", (String)ExceptionUtil.getDetailMessage(ex));
            transaction.setStatus(ex);
            exception = ex;
        }
        finally {
            transaction.complete();
        }
        if (this.m_fileProperties == null) {
            throw new ApolloConfigException("Load config from local config failed!", exception);
        }
    }

    private boolean trySyncFromUpstream() {
        if (this.m_upstream == null) {
            return false;
        }
        try {
            Properties properties = this.m_upstream.getConfig();
            this.updateFileProperties(properties);
            return true;
        }
        catch (Throwable ex) {
            Tracer.logError((Throwable)ex);
            logger.warn("Sync config from upstream repository {} failed, reason: {}", this.m_upstream.getClass(), (Object)ExceptionUtil.getDetailMessage(ex));
            return false;
        }
    }

    private synchronized void updateFileProperties(Properties newProperties) {
        if (newProperties.equals(this.m_fileProperties)) {
            return;
        }
        this.m_fileProperties = newProperties;
        this.persistLocalCacheFile(this.m_baseDir, this.m_namespace);
    }

    private Properties loadFromLocalCacheFile(File baseDir, String namespace) throws IOException {
        Preconditions.checkNotNull((Object)baseDir, (Object)"Basedir cannot be null");
        File file = this.assembleLocalCacheFile(baseDir, namespace);
        Properties properties = null;
        if (file.isFile() && file.canRead()) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                properties = new Properties();
                properties.load(in);
                logger.debug("Loading local config file {} successfully!", (Object)file.getAbsolutePath());
            }
            catch (IOException ex) {
                Tracer.logError((Throwable)ex);
                throw new ApolloConfigException(String.format("Loading config from local cache file %s failed", file.getAbsolutePath()), ex);
            }
            finally {
                try {
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                }
                catch (IOException ex) {}
            }
        }
        throw new ApolloConfigException(String.format("Cannot read from local cache file %s", file.getAbsolutePath()));
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void persistLocalCacheFile(File baseDir, String namespace) {
        if (baseDir == null) {
            return;
        }
        File file = this.assembleLocalCacheFile(baseDir, namespace);
        FileOutputStream out = null;
        Transaction transaction = Tracer.newTransaction((String)"Apollo.ConfigService", (String)"persistLocalConfigFile");
        transaction.addData("LocalConfigFile", (Object)file.getAbsolutePath());
        try {
            out = new FileOutputStream(file);
            this.m_fileProperties.store(out, "Persisted by DefaultConfig");
            transaction.setStatus("0");
        }
        catch (IOException ex) {
            ApolloConfigException exception = new ApolloConfigException(String.format("Persist local cache file %s failed", file.getAbsolutePath()), ex);
            Tracer.logError((Throwable)exception);
            transaction.setStatus((Throwable)exception);
            logger.warn("Persist local cache file {} failed, reason: {}.", (Object)file.getAbsolutePath(), (Object)ExceptionUtil.getDetailMessage(ex));
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException ex) {}
            }
            transaction.complete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLocalConfigCacheDir(File baseDir) {
        if (baseDir.exists()) {
            return;
        }
        Transaction transaction = Tracer.newTransaction((String)"Apollo.ConfigService", (String)"createLocalConfigDir");
        transaction.addData("BaseDir", (Object)baseDir.getAbsolutePath());
        try {
            Files.createDirectory(baseDir.toPath(), new FileAttribute[0]);
            transaction.setStatus("0");
        }
        catch (IOException ex) {
            ApolloConfigException exception = new ApolloConfigException(String.format("Create local config directory %s failed", baseDir.getAbsolutePath()), ex);
            Tracer.logError((Throwable)exception);
            transaction.setStatus((Throwable)exception);
            logger.warn("Unable to create local config cache directory {}, reason: {}. Will not able to cache config file.", (Object)baseDir.getAbsolutePath(), (Object)ExceptionUtil.getDetailMessage(ex));
        }
        finally {
            transaction.complete();
        }
    }

    File assembleLocalCacheFile(File baseDir, String namespace) {
        String fileName = String.format("%s.properties", Joiner.on((String)"+").join((Object)this.m_configUtil.getAppId(), (Object)this.m_configUtil.getCluster(), new Object[]{namespace}));
        return new File(baseDir, fileName);
    }
}

