/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.internals;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigFile;
import com.ctrip.framework.apollo.build.ApolloInjector;
import com.ctrip.framework.apollo.core.enums.ConfigFileFormat;
import com.ctrip.framework.apollo.enums.ConfigSourceType;
import com.ctrip.framework.apollo.internals.ConfigManager;
import com.ctrip.framework.apollo.spi.ConfigFactory;
import com.ctrip.framework.apollo.spi.ConfigFactoryManager;
import com.ctrip.framework.apollo.tracer.Tracer;
import com.ctrip.framework.apollo.util.ConfigUtil;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.util.Map;

public class DefaultConfigManager
implements ConfigManager {
    private ConfigFactoryManager m_factoryManager;
    private ConfigUtil m_configUtil;
    private Table<String, String, Config> m_configs = Tables.synchronizedTable((Table)HashBasedTable.create());
    private Map<String, Object> m_configLocks = Maps.newConcurrentMap();
    private Table<String, String, ConfigFile> m_configFiles = Tables.synchronizedTable((Table)HashBasedTable.create());
    private Map<String, Object> m_configFileLocks = Maps.newConcurrentMap();

    public DefaultConfigManager() {
        this.m_factoryManager = ApolloInjector.getInstance(ConfigFactoryManager.class);
        this.m_configUtil = ApolloInjector.getInstance(ConfigUtil.class);
    }

    @Override
    public Config getConfig(String namespace) {
        return this.getConfig(this.m_configUtil.getAppId(), namespace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Config getConfig(String appId, String namespace) {
        Config config = (Config)this.m_configs.get((Object)appId, (Object)namespace);
        if (config == null) {
            Object lock;
            Object object = lock = this.m_configLocks.computeIfAbsent(String.format("%s.%s", appId, namespace), key -> new Object());
            synchronized (object) {
                config = (Config)this.m_configs.get((Object)appId, (Object)namespace);
                if (config == null) {
                    ConfigFactory factory = this.m_factoryManager.getFactory(appId, namespace);
                    config = factory.create(appId, namespace);
                    this.m_configs.put((Object)appId, (Object)namespace, (Object)config);
                }
            }
        }
        if (!ConfigSourceType.NONE.equals((Object)config.getSourceType())) {
            Tracer.logMetricsForCount((String)("Apollo.Client.NamespaceUsage:" + namespace));
        }
        return config;
    }

    @Override
    public ConfigFile getConfigFile(String namespace, ConfigFileFormat configFileFormat) {
        return this.getConfigFile(this.m_configUtil.getAppId(), namespace, configFileFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigFile getConfigFile(String appId, String namespace, ConfigFileFormat configFileFormat) {
        String namespaceFileName = String.format("%s.%s", namespace, configFileFormat.getValue());
        String lockNamespaceFileName = String.format("%s+%s.%s", appId, namespace, configFileFormat.getValue());
        ConfigFile configFile = (ConfigFile)this.m_configFiles.get((Object)appId, (Object)namespaceFileName);
        if (configFile == null) {
            Object lock;
            Object object = lock = this.m_configFileLocks.computeIfAbsent(lockNamespaceFileName, key -> new Object());
            synchronized (object) {
                configFile = (ConfigFile)this.m_configFiles.get((Object)appId, (Object)namespaceFileName);
                if (configFile == null) {
                    ConfigFactory factory = this.m_factoryManager.getFactory(appId, namespaceFileName);
                    configFile = factory.createConfigFile(appId, namespaceFileName, configFileFormat);
                    this.m_configFiles.put((Object)appId, (Object)namespaceFileName, (Object)configFile);
                }
            }
        }
        return configFile;
    }
}

